/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.metadata.impl;

import com.digiwin.dap.middleware.entity.UnionKey;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.entity.Metadata;
import com.digiwin.dap.middleware.iam.entity.MetadataColumn;
import com.digiwin.dap.middleware.iam.mapper.MetadataMapper;
import com.digiwin.dap.middleware.iam.repository.MetadataRepository;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataColumnCrudService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityWithUnionKeyManagerService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MetadataCrudServiceImpl
extends BaseEntityWithUnionKeyManagerService<Metadata>
implements MetadataCrudService {
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    private MetadataColumnCrudService metadataColumnCrudService;
    @Autowired
    private MetadataMapper metadataMapper;

    protected UnionKey createUnionKey() {
        return UnionKey.create().apply(Metadata.class).add("tenantSid").add("columnSid").add("userSid");
    }

    protected MetadataRepository getRepository() {
        return this.metadataRepository;
    }

    @Override
    public List<Metadata> findByUserSid(long userSid) {
        return this.metadataRepository.findByUserSid(userSid);
    }

    @Override
    public List<Metadata> findByTenantSidAndUserSid(long tenantSid, long userSid) {
        return this.metadataRepository.findByTenantSidAndUserSid(tenantSid, userSid);
    }

    @Override
    public Metadata findByTenantSidAndUserSidAndColumnSid(long tenantSid, long userSid, long columnSid) {
        return this.metadataRepository.findByTenantSidAndUserSidAndColumnSid(tenantSid, userSid, columnSid);
    }

    @Override
    public void removeMetadata(long tenantSid, long userSid, String catalogId, String key) {
        MetadataColumn metadataColumn = this.metadataColumnCrudService.getByCatalogIdAndKey(catalogId, key);
        if (metadataColumn == null) {
            return;
        }
        Metadata metadata = this.metadataRepository.findByTenantSidAndUserSidAndColumnSid(tenantSid, userSid, metadataColumn.getSid());
        if (metadata != null) {
            this.metadataRepository.delete((Object)metadata);
        }
    }

    @Override
    public List<UserMetadataVO> findByTenantSidAndUserSidsOrUserIdsAndColumnSid(long tenantSid, List<Long> userSids, List<String> userIds, long columnSid) {
        if (CollectionUtils.isEmpty(userSids) && CollectionUtils.isEmpty(userIds)) {
            return new ArrayList<UserMetadataVO>();
        }
        return this.metadataMapper.findByTenantSidAndUserSidsOrUserIdsAndColumnSid(tenantSid, userSids, userIds, columnSid);
    }
}

