/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.metadata.impl;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.IntegrationQueryRequestVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.IntegrationQueryResponseVO;
import com.digiwin.dap.middleware.iam.entity.Metadata;
import com.digiwin.dap.middleware.iam.entity.MetadataColumn;
import com.digiwin.dap.middleware.iam.mapper.MetadataMapper;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataColumnCrudService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataCrudService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MetadataQueryServiceImpl
implements MetadataQueryService {
    @Autowired
    private MetadataMapper metadataMapper;
    @Autowired
    private MetadataCrudService metadataCrudService;
    @Autowired
    private MetadataColumnCrudService metadataColumnCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;

    @Override
    public List<UserMetadataVO> queryUserMetadataByUserSid(Long userSid) {
        return this.metadataMapper.findByUserSid(userSid);
    }

    @Override
    public List<UserMetadataVO> queryUserMetadataByTenantSidAndUserSid(Long tenantSid, Long userSid) {
        return this.metadataMapper.findByTenantSidAndUserSid(tenantSid, userSid);
    }

    @Override
    public UserMetadataVO getUserMetadataValue(long tenantSid, long userSid, String catalogId, String key) {
        Metadata metadata;
        MetadataColumn column = this.metadataColumnCrudService.getByCatalogIdAndKey(catalogId, key);
        if (column != null && (metadata = this.metadataCrudService.findByTenantSidAndUserSidAndColumnSid(tenantSid, userSid, column.getSid())) != null) {
            UserMetadataVO userMetadataVO = new UserMetadataVO();
            userMetadataVO.setName(column.getName());
            userMetadataVO.setValue(metadata.getValue());
            return userMetadataVO;
        }
        return null;
    }

    @Override
    public List<UserMetadataVO> batchGetUserMetadataValue(long tenantSid, List<Long> userSidList, List<String> userIdList, String catalogId, String key) {
        MetadataColumn column = this.metadataColumnCrudService.getByCatalogIdAndKey(catalogId, key);
        if (Objects.isNull((Object)column)) {
            return new ArrayList<UserMetadataVO>();
        }
        List<UserMetadataVO> userMetadataList = this.metadataCrudService.findByTenantSidAndUserSidsOrUserIdsAndColumnSid(tenantSid, userSidList, userIdList, column.getSid());
        if (CollectionUtils.isEmpty(userMetadataList)) {
            return new ArrayList<UserMetadataVO>();
        }
        ArrayList<UserMetadataVO> userMetadataVOList = new ArrayList<UserMetadataVO>();
        userMetadataList.forEach(x -> {
            UserMetadataVO userMetadataVO = new UserMetadataVO();
            userMetadataVO.setName(column.getName());
            userMetadataVO.setValue(x.getValue());
            userMetadataVO.setUserSid(x.getUserSid());
            userMetadataVO.setUserId(x.getUserId());
            userMetadataVOList.add(userMetadataVO);
        });
        return userMetadataVOList;
    }

    @Override
    public List<IntegrationQueryResponseVO> getIntegrationUserId(IntegrationQueryRequestVO vo) {
        if (CollectionUtils.isEmpty(vo.getUserIds())) {
            return new ArrayList<IntegrationQueryResponseVO>();
        }
        long tenantSid = Optional.ofNullable(this.tenantCrudService.findById(vo.getTenantId())).map(BaseEntity::getSid).orElse(0L);
        List<IntegrationQueryResponseVO> allUser = this.metadataMapper.findIntegrationUserId(vo);
        Collection<List<IntegrationQueryResponseVO>> groupByUser = allUser.stream().collect(Collectors.groupingBy(IntegrationQueryResponseVO::getUserId)).values();
        ArrayList<IntegrationQueryResponseVO> result = new ArrayList<IntegrationQueryResponseVO>();
        for (List<IntegrationQueryResponseVO> aUser : groupByUser) {
            result.addAll(aUser.stream().filter(a -> a.getTenantSid() == tenantSid).findFirst().map(xva$0 -> CollUtil.newArrayList((Object[])new IntegrationQueryResponseVO[]{xva$0})).orElseGet(() -> allUser.stream().filter(a -> a.getTenantSid() == 0L).findFirst().map(xva$0 -> CollUtil.newArrayList((Object[])new IntegrationQueryResponseVO[]{xva$0})).orElseGet(ArrayList::new)));
        }
        return result;
    }

    @Override
    public List<UserMetadataVO> queryUserMetadata(long tenantSid, List<String> userIdList, String catalogId, String key) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return new ArrayList<UserMetadataVO>();
        }
        return this.metadataMapper.findByUserIdList(tenantSid, userIdList, catalogId, key);
    }

    @Override
    public List<UserMetadataVO> queryUserMetadataByValue(long tenantSid, String value, String catalogId, String key) {
        return this.metadataMapper.findByValue(tenantSid, value, catalogId, key);
    }
}

