/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.metadata.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.metadata.MetadaVO;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.entity.Metadata;
import com.digiwin.dap.middleware.iam.entity.MetadataColumn;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataColumnCrudService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataCrudService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataQueryService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class MetadataUpdateServiceImpl
implements MetadataUpdateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataUpdateServiceImpl.class);
    private static final Long WECHAT_COLUMN_SID = 3L;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private MetadataCrudService metadataCrudService;
    @Autowired
    private MetadataQueryService metadataQueryService;
    @Autowired
    private MetadataColumnCrudService metadataColumnCrudService;
    @Autowired
    private ChangeLogService changeLogService;

    @Override
    public void updateMetadataByTenant(long tenantSid, String userId, List<UserMetadataVO> userMetadataVOList) {
        this.updateMetadataByTenant(tenantSid, userId, "onlyAppend", userMetadataVOList);
    }

    @Override
    public void updateMetadataByTenant(long tenantSid, String userId, String updateMode, List<UserMetadataVO> userMetadataVOList) {
        User user = (User)this.userCrudService.findById(userId);
        List<UserMetadataVO> metadataDBList = this.metadataQueryService.queryUserMetadataByTenantSidAndUserSid(tenantSid, user.getSid());
        HashMap<String, UserMetadataVO> metadataVOMap = new HashMap<String, UserMetadataVO>();
        for (UserMetadataVO metadataDB : metadataDBList) {
            metadataVOMap.put(metadataDB.getKey(), metadataDB);
        }
        this.updateMetadata(tenantSid, updateMode, userMetadataVOList, user, metadataVOMap);
    }

    @Override
    public void updateMetadataByUser(long tenantSid, String userId, List<UserMetadataVO> userMetadataVOList) {
        User user = (User)this.userCrudService.findById(userId);
        List<UserMetadataVO> metadataDBList = this.metadataQueryService.queryUserMetadataByUserSid(user.getSid());
        HashMap<String, UserMetadataVO> metadataDBMap = new HashMap<String, UserMetadataVO>();
        for (UserMetadataVO metadataDB : metadataDBList) {
            metadataDBMap.put(metadataDB.getKey(), metadataDB);
        }
        this.updateMetadata(tenantSid, "onlyAppend", userMetadataVOList, user, metadataDBMap);
    }

    private void updateMetadata(long tenantSid, String updateMode, List<UserMetadataVO> userMetadataVOList, User user, Map<String, UserMetadataVO> metadataDBMap) {
        String booleanType = "boolean";
        String intType = "int";
        for (UserMetadataVO userMetadataVO : userMetadataVOList) {
            Metadata metadata;
            MetadataColumn metadataColumn = this.metadataColumnCrudService.getByCatalogIdAndKey(userMetadataVO.getCatalogId(), userMetadataVO.getKey());
            if (ObjectUtils.isEmpty((Object)((Object)metadataColumn))) {
                throw new BusinessException((ErrorHandler)I18nError.META_DATE_COLUMN_NOT_EXIST, new Object[]{userMetadataVO.getCatalogId(), userMetadataVO.getKey()});
            }
            if (booleanType.equals(metadataColumn.getType().toLowerCase()) && Boolean.parseBoolean(userMetadataVO.getValue())) {
                throw new BusinessException((ErrorHandler)I18nError.META_DATE_TYPE_ERROR, new Object[]{metadataColumn.getKey()});
            }
            if (intType.equals(metadataColumn.getType().toLowerCase()) && StringUtil.isInt(userMetadataVO.getValue())) {
                throw new BusinessException((ErrorHandler)I18nError.META_DATE_TYPE_ERROR, new Object[]{metadataColumn.getKey()});
            }
            AuthoredSys authoredSys = AppAuthContextHolder.getContext().getAuthoredSys();
            if (metadataColumn.isReadOnly() && metadataColumn.getProvider().contains(authoredSys.getId())) {
                throw new BusinessException((ErrorHandler)I18nError.NO_PERMISSION_UPDATE_META_DATE, new Object[]{metadataColumn.getKey()});
            }
            UserMetadataVO current = metadataDBMap.get(userMetadataVO.getKey());
            if (current != null) {
                if (!userMetadataVO.getValue().equals(current.getValue())) {
                    metadata = new Metadata();
                    metadata.setSid(current.getSid());
                    metadata.setTenantSid(tenantSid);
                    metadata.setUserSid(user.getSid());
                    metadata.setHash(current.getHash());
                    metadata.setValue(userMetadataVO.getValue());
                    metadata.setColumnSid(metadataColumn.getSid());
                    this.metadataCrudService.update((BaseEntity)metadata);
                }
            } else {
                metadata = new Metadata();
                metadata.setTenantSid(tenantSid);
                metadata.setUserSid(user.getSid());
                metadata.setValue(userMetadataVO.getValue());
                metadata.setColumnSid(metadataColumn.getSid());
                this.metadataCrudService.create((BaseEntity)metadata);
            }
            if (!"all".equals(updateMode)) continue;
            metadataDBMap.forEach((key, value) -> this.metadataCrudService.removeMetadata(tenantSid, user.getSid(), value.getCatalogId(), value.getKey()));
        }
    }

    @Override
    public void updateMetadata(MetadaVO metadaVO) {
        long userSid = this.userCrudService.getSidById(metadaVO.getUserId());
        if (userSid == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{metadaVO.getUserId()});
        }
        long tenantSid = this.tenantCrudService.getSidById(metadaVO.getTenantId());
        if (tenantSid == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{metadaVO.getTenantId()});
        }
        Metadata oldMetadata = (Metadata)this.metadataCrudService.findByUnionKey(new Object[]{tenantSid, WECHAT_COLUMN_SID, userSid});
        if (oldMetadata != null) {
            oldMetadata.setValue(metadaVO.getParameter());
            this.metadataCrudService.update((BaseEntity)oldMetadata);
        } else {
            Metadata metadata = new Metadata();
            metadata.setValue(metadaVO.getParameter());
            metadata.setColumnSid(WECHAT_COLUMN_SID);
            metadata.setTenantSid(tenantSid);
            metadata.setUserSid(userSid);
            this.metadataCrudService.create((BaseEntity)metadata);
        }
    }

    @Override
    public void updateMetadataValue(UserMetadataVO userMetadataVO) {
        MetadataColumn metadataColumn = this.metadataColumnCrudService.getByCatalogIdAndKey(userMetadataVO.getCatalogId(), userMetadataVO.getKey());
        if (metadataColumn == null) {
            throw new BusinessException(String.format("%s\u7c7b\u522b\u4e0b\u7684%s\u81ea\u5b9a\u4e49\u5c5e\u6027\u4e0d\u5b58\u5728", userMetadataVO.getCatalogId(), userMetadataVO.getKey()));
        }
        Metadata metadata = this.metadataCrudService.findByTenantSidAndUserSidAndColumnSid(userMetadataVO.getTenantSid(), userMetadataVO.getUserSid(), metadataColumn.getSid());
        if (metadata == null) {
            metadata = new Metadata();
            metadata.setColumnSid(metadataColumn.getSid());
            metadata.setUserSid(userMetadataVO.getUserSid());
            metadata.setValue(userMetadataVO.getValue());
            metadata.setTenantSid(userMetadataVO.getTenantSid());
            this.metadataCrudService.create((BaseEntity)metadata);
            LOGGER.info("\u7528\u6237\u81ea\u5b9a\u4e49\u5c5e\u6027\u521b\u5efa\u6210\u529f\uff0c\u7528\u6237sid\u4e3a\uff1a{}\uff0c\u5c5e\u6027catalogId\u4e3a\uff1a{}\uff0ckey\u4e3a\uff1a{}\uff0c\u79df\u6237sid\u4e3a\uff1a{}\uff0c\u5c5e\u6027\u503c\u4e3a\uff1a{}", new Object[]{userMetadataVO.getUserSid(), userMetadataVO.getCatalogId(), userMetadataVO.getKey(), userMetadataVO.getTenantSid(), userMetadataVO.getValue()});
        } else {
            Metadata oldMetadata = new Metadata();
            BeanUtils.copyProperties((Object)((Object)metadata), (Object)((Object)oldMetadata));
            metadata.setValue(userMetadataVO.getValue());
            this.metadataCrudService.update((BaseEntity)metadata);
            LOGGER.info("\u7528\u6237\u81ea\u5b9a\u4e49\u5c5e\u6027\u66f4\u65b0\u6210\u529f\uff0c\u7528\u6237sid\u4e3a\uff1a{}\uff0c\u5c5e\u6027catalogId\u4e3a\uff1a{}\uff0ckey\u4e3a\uff1a{}\uff0c\u79df\u6237sid\u4e3a\uff1a{}\uff0c\u5c5e\u6027\u503c\u4e3a\uff1a{}", new Object[]{userMetadataVO.getUserSid(), userMetadataVO.getCatalogId(), userMetadataVO.getKey(), userMetadataVO.getTenantSid(), userMetadataVO.getValue()});
        }
    }

    @Override
    public void batchAddMetadata(String catalogId, String key, Boolean updateMode, List<UserMetadataVO> userMetadataVOList) {
        MetadataColumn metadataColumn = this.metadataColumnCrudService.getByCatalogIdAndKey(catalogId, key);
        if (metadataColumn == null) {
            throw new BusinessException((ErrorHandler)I18nError.META_DATE_CATALOG_NOT_EXIST, new Object[]{catalogId, key});
        }
        ArrayList metadatas = new ArrayList();
        userMetadataVOList.forEach(um -> {
            Metadata metadata = this.metadataCrudService.findByTenantSidAndUserSidAndColumnSid(um.getTenantSid(), um.getUserSid(), metadataColumn.getSid());
            if (metadata == null) {
                metadata = new Metadata();
                metadata.setTenantSid(um.getTenantSid());
                metadata.setUserSid(um.getUserSid());
                metadata.setColumnSid(metadataColumn.getSid());
                metadata.setValue(um.getValue());
                metadatas.add(metadata);
            } else if (updateMode.booleanValue()) {
                metadata.setValue(um.getValue());
                metadatas.add(metadata);
            }
        });
        this.metadataCrudService.saveAll(metadatas);
    }
}

