/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.migration.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.CommonCode;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.entity.BaseEntityWithPartition;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.app.ActionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.ConditionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.SysCascade;
import com.digiwin.dap.middleware.iam.domain.app.SysVO;
import com.digiwin.dap.middleware.iam.domain.auth.AuthDataDO;
import com.digiwin.dap.middleware.iam.domain.migration.MigrateAppVO;
import com.digiwin.dap.middleware.iam.domain.migration.TenantAppUpgradeDTO;
import com.digiwin.dap.middleware.iam.domain.migration.TenantAuthUpgradeDTO;
import com.digiwin.dap.middleware.iam.domain.migration.TenantSyncDTO;
import com.digiwin.dap.middleware.iam.domain.org.OrgAspectVO;
import com.digiwin.dap.middleware.iam.domain.org.OrgResultVO;
import com.digiwin.dap.middleware.iam.domain.org.OrgRoleTreeNode;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.domain.permission.v2.StatementInfo;
import com.digiwin.dap.middleware.iam.domain.permission.v2.StatementType;
import com.digiwin.dap.middleware.iam.domain.policy.BatchSaveTargetPolicyRequestVO;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetCondition;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetPolicy;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.role.RoleQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.role.rolebean.RoleBean;
import com.digiwin.dap.middleware.iam.domain.role.rolebean.RoleQueryParameter;
import com.digiwin.dap.middleware.iam.domain.tenant.RegisterTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuditVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantSimpleVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryPageVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserAllInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.domain.user.UserBasicInfoResultVO;
import com.digiwin.dap.middleware.iam.domain.user.UserBasicInfoVO;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Policy;
import com.digiwin.dap.middleware.iam.entity.PolicyConditionValue;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysInTenant;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.ActionMapper;
import com.digiwin.dap.middleware.iam.mapper.ConditionMapper;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.repository.PolicyConditionValueRepository;
import com.digiwin.dap.middleware.iam.repository.PolicyRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.migration.MigrationService;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgQueryService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import com.digiwin.dap.middleware.iam.service.org.impl.OrgCrudServiceImpl;
import com.digiwin.dap.middleware.iam.service.policy.PolicyConditionValueCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCrudService;
import com.digiwin.dap.middleware.iam.service.policy.impl.PolicyHandleServiceImpl;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleQueryService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.sys.impl.SysQueryServiceImpl;
import com.digiwin.dap.middleware.iam.service.tenant.PurchaseApplicationService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantAuditService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantRegisterService;
import com.digiwin.dap.middleware.iam.service.user.UserBasicInfoQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.impl.UserInRoleServiceImpl;
import com.digiwin.dap.middleware.iam.support.clean.RefreshCacheService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.PurchaseService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteBossIamService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteIamService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.CacAuth;
import com.digiwin.dap.middleware.iam.support.remote.domain.GoodsAuthDO;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplication;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplicationDTO;
import com.digiwin.dap.middleware.iam.support.remote.domain.cac.ProductTypeVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.Goods;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.SellingStrategyVO;
import com.digiwin.dap.middleware.iam.util.BatchCodeUtil;
import com.digiwin.dap.middleware.util.EnvUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class MigrationServiceImpl
implements MigrationService {
    private static final Logger logger = LoggerFactory.getLogger(MigrationServiceImpl.class);
    public static final long MILLIS = 1000L;
    public static final String DEFAULT_PASS_WD = "default1234";
    @Resource
    private CacService cacService;
    @Resource
    private PurchaseApplicationService purchaseApplicationService;
    @Resource
    private PurchaseService purchaseService;
    @Resource
    private TenantCrudService tenantCrudService;
    @Resource
    private SysInTenantCrudService sysInTenantCrudService;
    @Resource
    private SysCrudService sysCrudService;
    @Resource
    private PolicyRepository policyRepository;
    @Resource
    private ActionMapper actionMapper;
    @Resource
    private ConditionMapper conditionMapper;
    @Resource
    private PolicyCrudService policyCrudService;
    @Resource
    private PolicyConditionValueRepository policyConditionValueRepository;
    @Resource
    private PolicyConditionValueCrudService policyConditionValueCrudService;
    @Resource
    private TenantMapper tenantMapper;
    @Resource
    private RefreshCacheService refreshCacheService;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private RemoteBossIamService remoteBossIamService;
    @Autowired
    private TenantRegisterService tenantRegisterService;
    @Autowired
    private TenantAuditService tenantAuditService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private UserBasicInfoQueryService userBasicInfoQueryService;
    @Autowired
    private RemoteIamService remoteIamService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private RoleQueryService roleQueryService;
    @Autowired
    private OrgQueryService orgQueryService;
    @Autowired
    private OrgCatalogCrudService orgCatalogCrudService;
    @Autowired
    private OrgAspectCrudService orgAspectCrudService;
    @Autowired
    private OrgCrudServiceImpl orgCrudService;
    @Autowired
    private OrgTypeCrudService orgTypeCrudService;
    @Autowired
    private RoleCatalogCrudService roleCatalogCrudService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private UserInRoleServiceImpl userInRoleService;
    @Autowired
    private UserInOrgUpdateService userInOrgUpdateService;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private SysQueryServiceImpl sysQueryService;
    @Autowired
    private PolicyHandleServiceImpl policyHandleService;

    @Override
    public void migrateApp(MigrateAppVO body) {
        String sourceAppId = body.getSourceAppId();
        String targetAppId = body.getTargetAppId();
        boolean doAuthUsers = body.isDoAuthUsers();
        List<String> tenantIds = body.getTenantIds();
        if (CollectionUtils.isEmpty(tenantIds)) {
            tenantIds = this.cacService.findAuthTenant(sourceAppId);
        }
        for (String tenantId : tenantIds) {
            logger.info("\u5f00\u59cb\u6388\u6743\u79df\u6237\uff1a{}", (Object)tenantId);
            AuthorizationVO targetCacAuth = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(tenantId, targetAppId);
            if (targetCacAuth != null) {
                logger.info("\u79df\u6237\uff1a{}\u5df2\u6709{}\u6388\u6743", (Object)tenantId, (Object)targetAppId);
                if (!doAuthUsers) continue;
                try {
                    List<String> userIds = this.cacService.queryAuthUser(tenantId, sourceAppId);
                    this.cacService.batchAddIncremental(targetAppId, userIds, tenantId);
                }
                catch (Exception e) {
                    logger.error("\u79df\u6237\uff1a{},\u6388\u6743\u4eba\u5458\u5931\u8d25", (Object)tenantId);
                }
                continue;
            }
            Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
            if (tenant == null) {
                logger.info("\u79df\u6237\u4e0d\u5b58\u5728");
                continue;
            }
            AuthorizationVO sourceCacAuth = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(tenantId, sourceAppId);
            if (sourceCacAuth == null) {
                logger.info("\u79df\u6237\uff1a{}\u6ca1\u6709\u6765\u6e90\u5e94\u7528{}\u6388\u6743\uff0c\u8df3\u8fc7", (Object)tenantId, (Object)sourceAppId);
                continue;
            }
            ArrayList<String> userIds = new ArrayList();
            if (doAuthUsers) {
                userIds = this.cacService.queryAuthUser(tenantId, sourceAppId);
            }
            LocalDateTime expiredTime = sourceCacAuth.getExpiredTime();
            if (body.isUseStrategyExpireDate()) {
                expiredTime = null;
            }
            AuthDataDO authDataDO = new AuthDataDO();
            authDataDO.setAppId(targetAppId);
            authDataDO.setStrategyCode(body.getTargetSellingStrategySid().toString());
            authDataDO.setEffectiveDateTime(LocalDateTime.now());
            authDataDO.setExpiredDateTime(expiredTime);
            authDataDO.setMemo("\u6307\u5b9a\u79df\u6237\u589e\u52a0\u6388\u6743");
            GoodsAuthDO goodsAuthDO = new GoodsAuthDO(authDataDO, tenant, userIds);
            this.purchaseService.purchaseAuth(tenant.getId(), goodsAuthDO);
            SysVO sysVO = new SysVO();
            sysVO.setId(targetAppId);
            this.purchaseApplicationService.purchaseApplication(tenant.getId(), "virtual", sysVO, false);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void migratePolicy(MigrateAppVO body) {
        String targetAppId = body.getTargetAppId();
        List<String> oldModuleIds = body.getOldModuleIds();
        List<String> newModuleIds = body.getNewModuleIds();
        boolean copyCondition = body.isDoCopyCondition();
        List<String> tenantIds = body.getTenantIds();
        ArrayList tenantSids = new ArrayList();
        Sys sys = (Sys)this.sysCrudService.findById(targetAppId);
        long sysSid = sys.getSid();
        if (CollectionUtils.isEmpty(tenantIds)) {
            List<SysInTenant> bySysSid = this.sysInTenantCrudService.findBySysSid(sysSid);
            tenantSids.addAll(bySysSid.stream().map(BaseEntityWithPartition::getTenantSid).collect(Collectors.toList()));
        } else {
            List<TenantSimpleVO> tenantsBasicByIds = this.tenantMapper.findTenantsBasicByIds(tenantIds);
            tenantSids.addAll(tenantsBasicByIds.stream().map(TenantSimpleVO::getTenantSid).collect(Collectors.toList()));
        }
        if (tenantSids.isEmpty()) {
            logger.info("no tenant");
            return;
        }
        List<ActionQueryResultVO> allActions = this.actionMapper.findActionBySys(0L, sysSid);
        HashMap<Long, Long> oldActionSid2NewActionSid = MigrationServiceImpl.prepareOldAction2NewAction(allActions, oldModuleIds, newModuleIds);
        HashMap<Long, Long> newActionSid2NewModuleSid = MigrationServiceImpl.prepareNewActionModuleSid(allActions, oldActionSid2NewActionSid);
        HashMap<Long, Long> oldConditionSid2NewConditionSid = this.prepareOldCondition2NewCondition(sys, oldActionSid2NewActionSid);
        for (Long tenantSid : tenantSids) {
            this.processEachTenant(tenantSid, sysSid, oldActionSid2NewActionSid, newActionSid2NewModuleSid, copyCondition, oldConditionSid2NewConditionSid);
        }
        this.refreshCacheService.deletePermissionBySys(targetAppId);
    }

    private void processEachTenant(Long tenantSid, long sysSid, HashMap<Long, Long> oldActionSid2NewActionSid, HashMap<Long, Long> newActionSid2NewModuleSid, boolean copyCondition, HashMap<Long, Long> oldConditionSid2NewConditionSid) {
        logger.info("\u590d\u5236policy,tenantSid:{}", (Object)tenantSid);
        List policyList = this.policyRepository.findByTenantSidAndSysSid(tenantSid, sysSid).stream().filter(a -> StringUtils.hasLength((String)a.getStatementValue())).collect(Collectors.toList());
        for (Policy policy : policyList) {
            this.addPolicyStatement(oldActionSid2NewActionSid, newActionSid2NewModuleSid, policy);
            this.copyConditionValue(oldActionSid2NewActionSid, copyCondition, oldConditionSid2NewConditionSid, policy);
        }
    }

    private void addPolicyStatement(HashMap<Long, Long> oldActionSid2NewActionSid, HashMap<Long, Long> newActionSid2NewModuleSid, Policy policy) {
        HashMap<Long, Integer> added = new HashMap<Long, Integer>();
        HashMap<Long, Integer> addedModules = new HashMap<Long, Integer>();
        Map<Long, Integer> statement = StatementInfo.getStatementType(policy.getStatementValue());
        for (Map.Entry<Long, Integer> entry : statement.entrySet()) {
            if (oldActionSid2NewActionSid.containsKey(entry.getKey()) && !statement.containsKey(oldActionSid2NewActionSid.get(entry.getKey()))) {
                logger.info("sid:{},\u539faction\uff1a{}\uff0c\u65b0action\uff1a{}", new Object[]{policy.getSid(), entry.getKey(), oldActionSid2NewActionSid.get(entry.getKey())});
                added.put(oldActionSid2NewActionSid.get(entry.getKey()), entry.getValue());
            }
            for (Map.Entry newStatement : added.entrySet()) {
                if (!newActionSid2NewModuleSid.containsKey(newStatement.getKey()) || ((Integer)newStatement.getValue()).intValue() != StatementType.ACTION_ALLOW.ordinal() || statement.containsKey(newActionSid2NewModuleSid.get(newStatement.getKey()))) continue;
                logger.info("sid:{},\u52a0\u4e86\u65b0action\uff1a{}\uff0c\u6240\u4ee5\u540c\u6b65\u6dfb\u52a0\u65b0module\uff1a{}", new Object[]{policy.getSid(), newStatement.getKey(), newActionSid2NewModuleSid.get(newStatement.getKey())});
                addedModules.put(newActionSid2NewModuleSid.get(newStatement.getKey()), StatementType.MODULE_ALLOW.ordinal());
            }
        }
        added.putAll(addedModules);
        if (!added.isEmpty()) {
            statement.putAll(added);
            logger.info("sid:{},\u65e7statement\uff1a{}", (Object)policy.getSid(), (Object)policy.getStatementValue());
            policy.setStatementValue(StatementInfo.getStatementValue(statement));
            logger.info("sid:{},\u65b0statement\uff1a{}", (Object)policy.getSid(), (Object)policy.getStatementValue());
            this.policyCrudService.update((BaseEntity)policy);
        }
    }

    private void copyConditionValue(HashMap<Long, Long> oldActionSid2NewActionSid, boolean copyCondition, HashMap<Long, Long> oldConditionSid2NewConditionSid, Policy policy) {
        if (!copyCondition) {
            return;
        }
        List<PolicyConditionValue> conditions = this.policyConditionValueRepository.findByPolicySid(policy.getSid());
        ArrayList<PolicyConditionValue> toAdd = new ArrayList<PolicyConditionValue>();
        for (PolicyConditionValue aCondition : conditions) {
            if (!oldActionSid2NewActionSid.containsKey(aCondition.getActionSid())) continue;
            PolicyConditionValue newCondition = new PolicyConditionValue();
            newCondition.setPolicySid(policy.getSid());
            newCondition.setActionSid(oldActionSid2NewActionSid.get(aCondition.getActionSid()));
            List<TargetCondition> values = TargetPolicy.getValues(aCondition.getConditionValue());
            ArrayList<TargetCondition> newValues = new ArrayList<TargetCondition>();
            for (TargetCondition value : values) {
                if (!oldConditionSid2NewConditionSid.containsKey(value.getSid())) continue;
                value.setSid(oldConditionSid2NewConditionSid.get(value.getSid()));
                newValues.add(value);
            }
            newCondition.setConditionValue(JsonUtils.objToJson(newValues));
            toAdd.add(newCondition);
        }
        toAdd.removeIf(newOne -> {
            if (conditions.stream().anyMatch(old -> old.getActionSid() == newOne.getActionSid())) {
                logger.info("policy:{},actionSid:{}\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u6dfb\u52a0", (Object)policy.getSid(), (Object)newOne.getActionSid());
                return true;
            }
            return false;
        });
        this.policyConditionValueCrudService.saveAll(toAdd);
    }

    private HashMap<Long, Long> prepareOldCondition2NewCondition(Sys sys, HashMap<Long, Long> oldActionSid2NewActionSid) {
        HashMap<Long, Long> oldConditionSid2NewConditionSid = new HashMap<Long, Long>();
        List<ConditionQueryResultVO> allConditions = this.conditionMapper.findConditionBySysSid(sys.getSid(), false);
        Map<Long, List<ConditionQueryResultVO>> conditionsByActionSid = allConditions.stream().collect(Collectors.groupingBy(ConditionQueryResultVO::getActionSid));
        oldActionSid2NewActionSid.forEach((oldActionSid, newActionSid) -> {
            List oldConditions = conditionsByActionSid.getOrDefault(oldActionSid, Collections.emptyList());
            List newConditions = conditionsByActionSid.getOrDefault(newActionSid, Collections.emptyList());
            for (ConditionQueryResultVO oldCondition : oldConditions) {
                for (ConditionQueryResultVO newCondition : newConditions) {
                    if (!oldCondition.getKey().equals(newCondition.getKey())) continue;
                    oldConditionSid2NewConditionSid.put(oldCondition.getSid(), newCondition.getSid());
                }
            }
        });
        return oldConditionSid2NewConditionSid;
    }

    @NotNull
    private static HashMap<Long, Long> prepareNewActionModuleSid(List<ActionQueryResultVO> allActions, HashMap<Long, Long> oldActionSid2NewActionSid) {
        HashMap<Long, Long> newActionSid2NewModuleSid = new HashMap<Long, Long>();
        for (ActionQueryResultVO aAction : allActions) {
            if (!oldActionSid2NewActionSid.containsValue(aAction.getSid())) continue;
            newActionSid2NewModuleSid.put(aAction.getSid(), aAction.getModuleSid());
        }
        return newActionSid2NewModuleSid;
    }

    @NotNull
    private static HashMap<Long, Long> prepareOldAction2NewAction(List<ActionQueryResultVO> allActions, List<String> oldModuleIds, List<String> newModuleIds) {
        HashMap<Long, Long> oldActionSid2NewActionSid = new HashMap<Long, Long>();
        Map<String, List<ActionQueryResultVO>> groupByActionId = allActions.stream().collect(Collectors.groupingBy(ActionQueryResultVO::getId));
        groupByActionId.forEach((id, actions) -> {
            List oldGroup = actions.stream().filter(action -> oldModuleIds.contains(action.getModuleId())).collect(Collectors.toList());
            List newGroup = actions.stream().filter(action -> newModuleIds.contains(action.getModuleId())).collect(Collectors.toList());
            for (ActionQueryResultVO oldAction : oldGroup) {
                for (ActionQueryResultVO newAction : newGroup) {
                    if (oldAction.getModuleId().equals(newAction.getModuleId())) continue;
                    logger.info("\u65b0\u65e7actionSid\u5bf9\u5e94\u5173\u7cfb\u65e7\u6a21\u7ec4id:{},\u65b0\u6a21\u7ec4id\uff1a{},actionId:{}", new Object[]{oldAction.getModuleId(), newAction.getModuleId(), newAction.getId()});
                    oldActionSid2NewActionSid.put(oldAction.getSid(), newAction.getSid());
                }
            }
        });
        return oldActionSid2NewActionSid;
    }

    @Override
    public void expireOldModules(MigrateAppVO body) {
        this.cacService.expireModules(body);
        this.refreshCacheService.deletePermissionBySys(body.getTargetAppId());
    }

    @Override
    public String updateTenantAuthWithApp(TenantAuthUpgradeDTO dto) {
        Tenant tenant;
        List<CacAuth> currentCacAuthList;
        List currentCacTenantIds;
        DeployAreaEnum areaEnum = DeployAreaEnum.get((String)dto.getSourceCloudArea());
        if (areaEnum == null) {
            throw new BusinessException("\u6765\u6e90\u4e91\u533a\u4e0d\u5b58\u5728");
        }
        List<String> tenantIds = dto.getTenantIds();
        String gmcUri = EnvUtils.getUri((CommonCode)CommonCode.GMC, (DeployAreaEnum)areaEnum);
        String bossIamUri = EnvUtils.getUri((CommonCode)CommonCode.BOSS, (DeployAreaEnum)areaEnum);
        String cacUri = EnvUtils.getUri((CommonCode)CommonCode.CAC, (DeployAreaEnum)areaEnum);
        AuthoredUser authoredUser = UserUtils.getAuthoredUser();
        StringBuilder stringBuilder = new StringBuilder();
        List<CacAuth> sourceCacAuthList = this.cacService.getTenantsAndApps(tenantIds, Collections.singletonList(dto.getAppId()), Boolean.TRUE, cacUri, dto.getUserToken());
        List<String> sourceCacTenantIds = sourceCacAuthList.stream().map(CacAuth::getTenantId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sourceCacTenantIds)) {
            String msg = String.format("\u67e5\u8be2\u5e94\u7528%s\u6ca1\u6709\u6388\u6743\u7684\u79df\u6237\uff1b", dto.getAppId());
            logger.info(msg);
            stringBuilder.append(msg);
            return stringBuilder.toString();
        }
        ArrayList<String> requestTenantIdList = new ArrayList<String>(tenantIds);
        requestTenantIdList.removeAll(sourceCacTenantIds);
        if (!CollectionUtils.isEmpty(requestTenantIdList)) {
            String msg = String.format("\u8df3\u8fc7\u5165\u53c2\u7684\u79df\u6237\u4e2d%s\u6ca1\u6709%s\u5e94\u7528\u7684\u6388\u6743\uff1b", requestTenantIdList, dto.getAppId());
            logger.info(msg);
            stringBuilder.append(msg);
        }
        List<Tenant> existTenantList = this.tenantRepository.findByIdIn(sourceCacTenantIds);
        Map<String, Tenant> existTenantMap = existTenantList.stream().collect(Collectors.toMap(BaseEntityWithId::getId, x -> x, (k1, k2) -> k1));
        ArrayList<String> notExistTenantIds = new ArrayList<String>(sourceCacTenantIds);
        notExistTenantIds.removeAll(existTenantList.stream().map(BaseEntityWithId::getId).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty(notExistTenantIds)) {
            logger.info("\u5f53\u524d\u533a\u4e0d\u5b58\u5728\u7684\u79df\u6237\uff0c\u9700\u8981\u521b\u5efa notExistTenantIds:{}", notExistTenantIds);
            List<TenantVO> sourceTenantVOList = this.remoteBossIamService.getBossTenantQueryVos(bossIamUri, dto.getUserToken(), notExistTenantIds);
            logger.info("\u67e5\u8be2\u6d4b\u8bd5\u533a\u79df\u6237\u7684\u4fe1\u606f sourceTenantVOList:{}", sourceTenantVOList.stream().map(TenantVO::getId).collect(Collectors.toList()));
            for (TenantVO tenantVO : sourceTenantVOList) {
                logger.info("\u5f00\u59cb\u521b\u5efa\u79df\u6237\uff1a{}", (Object)tenantVO.getId());
                tenantVO.setSid(0L);
                tenantVO.setOwnerUserSid(authoredUser.getSid());
                tenantVO.setSourceTenantSid(0L);
                RegisterTenantVO registerTenantVO = new RegisterTenantVO();
                registerTenantVO.setTenant(tenantVO);
                registerTenantVO.setOwnerUserId(tenantVO.getUserId());
                this.tenantRegisterService.register(registerTenantVO, authoredUser.getSid());
                Tenant tenant2 = (Tenant)this.tenantCrudService.findById(registerTenantVO.getTenant().getId());
                TenantAuditVO tenantAuditVO = new TenantAuditVO();
                tenantAuditVO.setSid(tenant2.getSid());
                tenantAuditVO.setTestTenant(Optional.ofNullable(registerTenantVO.getTenant().getTestTenant()).orElse(false));
                tenantAuditVO.setEoc(Optional.ofNullable(registerTenantVO.getTenant().getEoc()).orElse(false));
                this.tenantAuditService.confirm(tenantAuditVO);
                existTenantMap.put(tenant2.getId(), tenant2);
                logger.info("\u5b8c\u6210 \u521b\u5efa\u79df\u6237\uff1a{}", (Object)tenantVO.getId());
                this.sleepMillis();
            }
        }
        if (!(currentCacTenantIds = (currentCacAuthList = this.cacService.getTenantsAndApps(sourceCacTenantIds, Collections.singletonList(dto.getAppId()))).stream().map(CacAuth::getTenantId).collect(Collectors.toList())).isEmpty()) {
            String msg = String.format("\u8df3\u8fc7\u6b63\u5f0f\u533a\u79df\u6237\u4e2d%s\u5df2\u7ecf\u5b58\u5728%s\u5e94\u7528\u7684\u6388\u6743;", currentCacTenantIds, dto.getAppId());
            logger.info(msg);
            stringBuilder.append(msg);
        }
        List needAuthCacAuthList = sourceCacAuthList.stream().filter(x -> !currentCacTenantIds.contains(x.getTenantId())).collect(Collectors.toList());
        Goods sourceGoods = null;
        Goods goods = null;
        if (!CollectionUtils.isEmpty(needAuthCacAuthList)) {
            for (CacAuth cacAuth : needAuthCacAuthList) {
                SysVO sysVO = new SysVO();
                sysVO.setIdFirst(dto.getAppId());
                this.purchaseApplicationService.purchaseApplication(cacAuth.getTenantId(), dto.getAppId(), sysVO, false);
                logger.info("\u5f00\u59cb\u6388\u6743\u79df\u6237\uff1a{}", (Object)cacAuth.getTenantId());
                tenant = existTenantMap.get(cacAuth.getTenantId());
                CacAuth cacAuthDto = new CacAuth();
                cacAuthDto.setTenantSid(tenant.getSid());
                cacAuthDto.setTenantId(tenant.getId());
                cacAuthDto.setTenantName(tenant.getName());
                cacAuthDto.setAction(0);
                cacAuthDto.setAuthUser(false);
                cacAuthDto.setSourceId("API");
                if (sourceGoods == null) {
                    sourceGoods = this.gmcService.getGoodsInfoForTestEnv(dto.getAppId(), gmcUri);
                }
                SellingStrategyVO sourceSellingStrategy = sourceGoods.getSellingStrategys().stream().filter(x -> x.getId().toString().equals(cacAuth.getLastStrategyId())).findFirst().orElse(null);
                if (goods == null) {
                    goods = this.gmcService.getGoodsInfoForTestEnv(dto.getAppId());
                }
                SellingStrategyVO sellingStrategy = null;
                sellingStrategy = sourceSellingStrategy == null ? goods.getSellingStrategys().stream().filter(x -> Boolean.TRUE.equals(x.getMainPush())).findFirst().orElse(goods.getSellingStrategys().get(0)) : goods.getSellingStrategys().stream().filter(x -> x.getId().equals(sourceSellingStrategy.getId())).findFirst().orElse(goods.getSellingStrategys().stream().filter(x -> Boolean.TRUE.equals(x.getMainPush())).findFirst().orElse(goods.getSellingStrategys().get(0)));
                AuthorizationVO sourceAuth = this.cacService.getAuthorizationVoByTenantIdAndGoodCode(cacAuth.getTenantId(), dto.getAppId(), cacUri);
                sellingStrategy.setEnabledModules(sourceAuth.getEnabledModules());
                goods.setCategory(3);
                goods.setMemo(Optional.ofNullable(sourceAuth.getMemo()).orElse("") + " \u5f00\u53d1\u5e73\u53f0\u5347\u7ea7\u6388\u6743" + LocalDateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (DateTimeFormatter)DatePattern.PURE_DATETIME_FORMATTER));
                long totalUserCount = sourceAuth.getTotalUserCount();
                totalUserCount = totalUserCount == -1L ? 9999L : totalUserCount;
                goods.setTotalUsage(totalUserCount);
                goods.setTotalCount(totalUserCount);
                goods.setRemainingUsage(sourceAuth.getRemainingUsage());
                goods.setOrderNumber(1);
                goods.setEffectiveTime(sourceAuth.getEffectiveTime());
                goods.setExpiredTime(sourceAuth.getExpiredTime());
                goods.setSellingStrategy(sellingStrategy);
                cacAuthDto.setAuthorizations(Collections.singletonList(goods));
                this.cacService.purchaseOrUpdateApp(cacAuthDto);
                logger.info("\u5b8c\u6210\u6388\u6743\u79df\u6237\uff1a{}", (Object)cacAuth.getTenantId());
                this.sleepMillis();
            }
        }
        for (CacAuth cacAuth : sourceCacAuthList) {
            List<String> sourceAuthUserIdList = this.cacService.queryAuthUser(cacAuth.getTenantId(), dto.getAppId(), cacUri, dto.getUserToken());
            if (CollectionUtils.isEmpty(sourceAuthUserIdList)) {
                String msg = String.format("\u6388\u6743\u7528\u6237\uff1a\u8df3\u8fc7\u79df\u6237%s\uff0c\u6388\u6743\u5e94\u7528%s\u4e0b\u65e0\u7528\u6237\uff1b", cacAuth.getTenantId(), dto.getAppId());
                logger.info(msg);
                stringBuilder.append(msg);
                continue;
            }
            tenant = existTenantMap.get(cacAuth.getTenantId());
            List<User> userList = this.userRepository.findByIdIn(sourceAuthUserIdList);
            if (userList.isEmpty()) {
                String msg = String.format("\u6388\u6743\u7528\u6237\uff1a\u8df3\u8fc7\u79df\u6237%s\uff0c\u6388\u6743\u5e94\u7528%s\u4e0b\u7684\u7528\u6237\u5728\u6b63\u5f0f\u533a\u4e0d\u5b58\u5728\uff0csourceAuthUserIdList = %s\uff1b", cacAuth.getTenantId(), dto.getAppId(), sourceAuthUserIdList);
                logger.info(msg);
                stringBuilder.append(msg);
                continue;
            }
            List userIdList = userList.stream().map(BaseEntityWithId::getId).collect(Collectors.toList());
            ArrayList<String> notExistedUserIdList = new ArrayList<String>(sourceAuthUserIdList);
            notExistedUserIdList.removeAll(userIdList);
            if (!notExistedUserIdList.isEmpty()) {
                String msg = String.format("\u6388\u6743\u7528\u6237\uff1a\u79df\u6237%s\uff0c\u6388\u6743\u5e94\u7528%s\u4e0b\u7684\u7528\u6237\u5728\u6b63\u5f0f\u533a\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7\u4e0d\u5b58\u5728\u7684\u7528\u6237 notExistedUserIdList = %s\uff1b", cacAuth.getTenantId(), dto.getAppId(), notExistedUserIdList);
                logger.info(msg);
                stringBuilder.append(msg);
            }
            for (User user : userList) {
                boolean exists = this.userInTenantCrudService.existsByUnionKey(Objects.requireNonNull(tenant).getSid(), user.getSid());
                if (exists) continue;
                UserInTenant userInTenant = new UserInTenant(Objects.requireNonNull(user).getSid(), tenant.getSid());
                this.userInTenantCrudService.create(userInTenant);
            }
            int batchSize = 500;
            for (int i = 0; i < userIdList.size(); i += batchSize) {
                int end = Math.min(i + batchSize, userIdList.size());
                List<String> batch = userIdList.subList(i, end);
                this.cacService.batchAddIncremental(dto.getAppId(), batch, cacAuth.getTenantId());
                this.sleepMillis();
            }
            this.sleepMillis();
        }
        return stringBuilder.toString();
    }

    @Override
    public String syncTenantAllInfo(TenantSyncDTO dto, AuthoredUser authoredUser) {
        if (dto.getTenantSid() != null && !Objects.equals(dto.getTenantSid(), authoredUser.getTenantSid())) {
            throw new BusinessException(StrUtil.format((CharSequence)"\u79df\u6237SID\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u540c\u6b65\u8d44\u6599\uff0c\u5f53\u524d\u79df\u6237sid={}", (Object[])new Object[]{authoredUser.getTenantSid()}));
        }
        if (!Objects.equals(dto.getTenantId(), authoredUser.getTenantId())) {
            throw new BusinessException(StrUtil.format((CharSequence)"\u79df\u6237ID\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u540c\u6b65\u8d44\u6599\uff0c\u5f53\u524d\u79df\u6237id={}", (Object[])new Object[]{authoredUser.getTenantId()}));
        }
        String userToken = dto.getUserToken();
        String tenantId = dto.getTenantId();
        String userPwd = Optional.ofNullable(dto.getPwd()).filter(StringUtils::hasText).orElse(DEFAULT_PASS_WD);
        long tenantSid = authoredUser.getTenantSid();
        DeployAreaEnum areaEnum = DeployAreaEnum.get((String)dto.getSourceCloudArea());
        if (areaEnum == null) {
            throw new BusinessException(StrUtil.format((CharSequence)"\u6765\u6e90\u4e91\u533a{}\u4e0d\u5b58\u5728", (Object[])new Object[]{dto.getSourceCloudArea()}));
        }
        AuthoredUser remoteAuthoredUser = this.remoteIamService.getUserInfo(userToken, areaEnum);
        if (!Objects.equals(remoteAuthoredUser.getTenantId(), "99990000")) {
            throw new BusinessException(StrUtil.format((CharSequence)"\u8c03\u7528\u8005{}\u975e\u9f0e\u6377\u5458\u5de5\uff0c\u4e0d\u80fd\u4f7f\u7528\u8be5\u63a5\u53e3", (Object[])new Object[]{remoteAuthoredUser.getUserId()}));
        }
        String cacUri = EnvUtils.getUri((CommonCode)CommonCode.CAC, (DeployAreaEnum)areaEnum);
        String iamUri = EnvUtils.getUri((CommonCode)CommonCode.IAM, (DeployAreaEnum)areaEnum);
        StringBuilder stringBuilder = new StringBuilder();
        QueryPageVO pageVO = new QueryPageVO();
        pageVO.setPageCount(9999L);
        UserBasicInfoResultVO userInfosList = this.userBasicInfoQueryService.getUserBasicInfosByTenantWithPage(tenantSid, pageVO);
        logger.info("\u672c\u5730\u7528\u6237\u6570\u91cf={}", (Object)userInfosList.getTotalCount());
        String integrationUserToken = this.remoteIamService.getUserToken(tenantId, areaEnum);
        QueryUserAllInfoVO userAllInfoVO = new QueryUserAllInfoVO();
        userAllInfoVO.setQueryPage(pageVO);
        userAllInfoVO.setType("all");
        UserBasicInfoResultVO remoteUserInfosList = this.remoteIamService.queryUserAllInformationWithPage(userAllInfoVO, integrationUserToken, areaEnum);
        logger.info("\u8fdc\u7a0b\u7528\u6237\u6570\u91cf={}", (Object)remoteUserInfosList.getTotalCount());
        for (UserBasicInfoVO remoteUserBasicInfo : remoteUserInfosList.getUserBasicInformation()) {
            User remoteUser = remoteUserBasicInfo.getUser();
            if (!userInfosList.getUserBasicInformation().stream().noneMatch(userBasicInfoVO -> userBasicInfoVO.getUser().getId().equals(remoteUser.getId()))) continue;
            User user = (User)this.userRepository.findById(remoteUser.getId());
            if (user == null && !remoteUser.getId().endsWith("@digiwin.com")) {
                user = new User();
                com.digiwin.dap.middleware.commons.util.BeanUtils.mergeDifferentTypeObject((Object)((Object)remoteUser), (Object)((Object)user));
                user.setPassword(DigestUtils.sha256((String)userPwd));
                user.setChanged(Boolean.FALSE);
                user.setDefaultTenantSid(0L);
                this.userCrudService.create((BaseEntity)user);
            }
            if (user == null) continue;
            UserInTenant userInTenant = new UserInTenant(user.getSid(), tenantSid);
            this.userInTenantCrudService.create(userInTenant);
        }
        OrgAspectVO orgAspectVO = new OrgAspectVO();
        orgAspectVO.setCatalogId("defaultOrgCatalog");
        orgAspectVO.setId("defaultOrgAspect");
        long orgCatalogSid = this.orgCatalogCrudService.getSidByTenantAndId(tenantSid, orgAspectVO.getCatalogId());
        long orgAspectSid = this.orgAspectCrudService.getSidByUnionKey(new Object[]{tenantSid, orgCatalogSid, orgAspectVO.getId()});
        List orgTypeList = this.orgTypeCrudService.findByTenantSid(tenantSid);
        List<OrgResultVO> orgResultList = this.orgQueryService.getAspect(tenantSid, orgAspectSid);
        for (OrgResultVO orgResultVO : orgResultList) {
            this.orgCrudService.deleteOrgBySid(orgResultVO.getSid());
        }
        List<OrgResultVO> remoteOrgResultList = this.remoteIamService.getOrgAspect(orgAspectVO, integrationUserToken, areaEnum);
        ArrayList<Org> orgList = new ArrayList<Org>();
        for (OrgResultVO remoteOrgResult : remoteOrgResultList) {
            Org org = new Org();
            com.digiwin.dap.middleware.commons.util.BeanUtils.mergeDifferentTypeObject((Object)remoteOrgResult, (Object)((Object)org));
            org.setId(remoteOrgResult.getLabel());
            org.setTenantSid(tenantSid);
            org.setOrgAspectSid(orgAspectSid);
            Long orgTypeSid = orgTypeList.stream().filter(orgType -> Objects.equals(orgType.getUri(), remoteOrgResult.getTypeUri())).findFirst().map(BaseEntity::getSid).orElse(0L);
            org.setOrgTypeSid(orgTypeSid);
            orgList.add(org);
        }
        if (!orgList.isEmpty()) {
            this.orgCrudService.saveAll(orgList);
        }
        List<RoleQueryResultVO> roleInfoList = this.roleQueryService.getRoleQueryResultVosByType(false, tenantSid);
        logger.info("\u672c\u5730\u89d2\u8272\u6570\u91cf={}", (Object)roleInfoList.size());
        List roleCatalogList = this.roleCatalogCrudService.findByTenantSid(tenantSid);
        Long defaultRoleCatalogSid = roleCatalogList.stream().filter(x -> "defaultRoleCatalog".equals(x.getId())).map(BaseEntity::getSid).findFirst().orElse(0L);
        RoleBean roleBean = new RoleBean();
        RoleQueryParameter queryParameter = new RoleQueryParameter();
        queryParameter.setType("enabled");
        roleBean.setQueryParameter(queryParameter);
        List<RoleQueryResultVO> remoteRoleInfoList = this.remoteIamService.getRoleInCatalog(roleBean, integrationUserToken, areaEnum);
        ArrayList<Role> roleList = new ArrayList<Role>();
        for (RoleQueryResultVO remoteRoleInfo : remoteRoleInfoList) {
            if (!roleInfoList.stream().noneMatch(roleInfo -> roleInfo.getId().equals(remoteRoleInfo.getId()))) continue;
            Role role = new Role();
            BeanUtils.copyProperties((Object)remoteRoleInfo, (Object)((Object)role), (String[])new String[]{"createBy"});
            Long roleCatalogSid = roleCatalogList.stream().filter(roleCatalog -> Objects.equals(roleCatalog.getId(), remoteRoleInfo.getCatalogId())).findFirst().map(BaseEntity::getSid).orElse(defaultRoleCatalogSid);
            role.setRoleCatalogSid(roleCatalogSid);
            role.setTenantSid(tenantSid);
            roleList.add(role);
        }
        if (!roleList.isEmpty()) {
            this.roleCrudService.saveAll(roleList);
        }
        for (UserBasicInfoVO remoteUserBasicInfo : remoteUserInfosList.getUserBasicInformation()) {
            List<QueryRoleResultVO> remoteRoleList;
            Object remoteUser = remoteUserBasicInfo.getUser();
            User user = (User)this.userRepository.findById(remoteUser.getId());
            if (user == null) {
                String msg = StrUtil.format((CharSequence)"\u3010\u7ed1\u5b9a\u5173\u7cfb-\u7fa4\u7ec4\u3001\u89d2\u8272\u3011\u8df3\u8fc7\u4e0d\u5b58\u5728\u7528\u6237={}\uff1b", (Object[])new Object[]{remoteUser.getId()});
                logger.warn(msg);
                stringBuilder.append(msg);
                continue;
            }
            List<QueryUserInOrgResultVO> userInOrgList = remoteUserBasicInfo.getUserInOrg();
            if (!CollectionUtils.isEmpty(userInOrgList)) {
                List<Long> orgSids = userInOrgList.stream().map(QueryUserInOrgResultVO::getOrgSid).collect(Collectors.toList());
                this.userInOrgUpdateService.updateUserInOrgByUser(tenantSid, user.getSid(), "all", orgSids);
            }
            if (CollectionUtils.isEmpty(remoteRoleList = remoteUserBasicInfo.getRole()) || "default".equals(remoteUser.getId())) continue;
            List<String> roleIds = remoteRoleList.stream().map(QueryRoleResultVO::getId).collect(Collectors.toList());
            this.userInRoleService.updateUserInRoleByUser(tenantSid, user.getSid(), roleIds);
        }
        List<AuthorizationResultVO> authorizationList = this.cacService.queryAllAuthorization(tenantId);
        logger.info("\u672c\u5730\u6388\u6743\u5e94\u7528list={}", authorizationList.stream().map(AuthorizationResultVO::getCode).collect(Collectors.toList()));
        List<AuthorizationResultVO> remoteAuthorizationList = this.cacService.queryAllAuthorization(tenantId, false, cacUri);
        logger.info("\u8fdc\u7a0b\u6388\u6743\u5e94\u7528list={}", remoteAuthorizationList.stream().map(AuthorizationResultVO::getCode).collect(Collectors.toList()));
        for (AuthorizationResultVO remoteAuthorization : remoteAuthorizationList) {
            String appId = remoteAuthorization.getCode();
            if (authorizationList.stream().noneMatch(authorization -> authorization.getCode().equals(appId))) {
                String msg = StrUtil.format((CharSequence)"\u3010\u7528\u6237\u6388\u6743\u6307\u5b9a\u7684\u5e94\u7528\u3011\u672c\u5730\u79df\u6237\u6ca1\u6709\u6388\u6743\u8be5\u5e94\u7528={}, \u8df3\u8fc7\uff1b\n", (Object[])new Object[]{appId});
                logger.warn(msg);
                stringBuilder.append(msg);
                continue;
            }
            List<String> remoteAuthUserIdList = this.cacService.queryAuthUser(tenantId, appId, cacUri, integrationUserToken);
            logger.info("tenantId={}, appId={}, \u6388\u6743\u7528\u6237={}", new Object[]{tenantId, appId, remoteAuthUserIdList});
            if (CollectionUtils.isEmpty(remoteAuthUserIdList)) {
                String msg = String.format("\u3010\u6388\u6743\u7528\u6237\u3011\u8df3\u8fc7\u79df\u6237%s\uff0c\u6388\u6743\u5e94\u7528%s\u4e0b\u65e0\u7528\u6237\uff1b", tenantId, appId);
                logger.info(msg);
                stringBuilder.append(msg);
                continue;
            }
            List<User> userList = this.userRepository.findByIdIn(remoteAuthUserIdList);
            List userIdList = userList.stream().map(BaseEntityWithId::getId).collect(Collectors.toList());
            for (User user : userList) {
                boolean exists = this.userInTenantCrudService.existsByUnionKey(tenantSid, user.getSid());
                if (exists) continue;
                UserInTenant userInTenant = new UserInTenant(Objects.requireNonNull(user).getSid(), tenantSid);
                this.userInTenantCrudService.create(userInTenant);
            }
            int batchSize = 500;
            for (int i = 0; i < userIdList.size(); i += batchSize) {
                int end = Math.min(i + batchSize, userIdList.size());
                List<String> batch = userIdList.subList(i, end);
                this.cacService.batchAddIncremental(appId, batch, tenantId);
                this.sleepMillis();
            }
            this.sleepMillis();
        }
        List<TenantApplication> remoteTenantApplications = this.remoteIamService.getUserApplicationByTenant(iamUri, integrationUserToken);
        TenantApplicationDTO tenantApplicationDTO = new TenantApplicationDTO(tenantId);
        tenantApplicationDTO.setCountApiInvoke(true);
        List<TenantApplication> tenantApplications = this.tenantQueryService.getTenantApplicationAndPlatFormByTenant(tenantApplicationDTO);
        tenantApplications.removeIf(a -> StrUtils.isNotEmpty((String)a.getBundleCode()));
        List tenantAppIdList = tenantApplications.stream().map(TenantApplication::getId).collect(Collectors.toList());
        Map<String, List<OrgRoleTreeNode>> remoteOrgRoleTrees = this.remoteIamService.getOrgCascadeInTenant(iamUri, integrationUserToken);
        List<OrgRoleTreeNode> remoteDefaultOrgAspect = remoteOrgRoleTrees.get("defaultOrgAspect");
        List<RoleQueryResultVO> roleInfoList2 = this.roleQueryService.getRoleQueryResultVosByType(false, tenantSid);
        UserBasicInfoResultVO userInfosList2 = this.userBasicInfoQueryService.getUserBasicInfosByTenantWithPage(tenantSid, pageVO);
        for (TenantApplication remoteApplication : remoteTenantApplications) {
            if (!tenantAppIdList.contains(remoteApplication.getId())) {
                String msg = StrUtil.format((CharSequence)"\u3010\u529f\u80fd\u6743\u9650\u3011\u672c\u5730\u79df\u6237\u6ca1\u6709\u6388\u6743\u8be5\u5e94\u7528={}\uff0c \u8df3\u8fc7\uff1b\n", (Object[])new Object[]{remoteApplication.getId()});
                logger.warn(msg);
                stringBuilder.append(msg);
                continue;
            }
            RequestParameterVO requestParameterVO = new RequestParameterVO();
            requestParameterVO.setId(remoteApplication.getId());
            SysCascade remoteSysCascade = this.remoteIamService.getApp(requestParameterVO, iamUri, integrationUserToken);
            if (remoteSysCascade == null) {
                String msg = StrUtil.format((CharSequence)"\u3010\u529f\u80fd\u6743\u9650\u3011\u67e5\u8be2\u8fdc\u7a0b\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a={}\uff0c \u8df3\u8fc7\uff1b\n", (Object[])new Object[]{remoteApplication.getId()});
                logger.warn(msg);
                stringBuilder.append(msg);
                continue;
            }
            SysCascade sysCascade = this.sysQueryService.getSysCascadeBySid(authoredUser.getTenantSid(), authoredUser.getTenantId(), 0L, remoteApplication.getId(), false, true);
            if (sysCascade == null) {
                String msg = StrUtil.format((CharSequence)"\u3010\u529f\u80fd\u6743\u9650\u3011\u67e5\u8be2\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a={}\uff0c \u8df3\u8fc7\uff1b\n", (Object[])new Object[]{remoteApplication.getId()});
                logger.warn(msg);
                stringBuilder.append(msg);
                continue;
            }
            if (!CollectionUtils.isEmpty(remoteDefaultOrgAspect)) {
                for (OrgRoleTreeNode remoteOrgRoleTreeNode : remoteDefaultOrgAspect) {
                    this.processOrgRoleTreeNode(remoteOrgRoleTreeNode, tenantSid, remoteSysCascade, sysCascade, iamUri, integrationUserToken, stringBuilder);
                }
            }
            for (RoleQueryResultVO remoteRoleInfo : remoteRoleInfoList) {
                if ("superadmin".equals(remoteRoleInfo.getId())) continue;
                RoleQueryResultVO roleInfo2 = roleInfoList2.stream().filter(x -> x.getId().equals(remoteRoleInfo.getId())).findFirst().orElse(null);
                if (roleInfo2 == null) {
                    String msg = StrUtil.format((CharSequence)"\u3010\u529f\u80fd\u6743\u9650\u3011\u672c\u5730\u89d2\u8272={}\u4e3a\u7a7a\uff0c \u8df3\u8fc7\uff1b\n", (Object[])new Object[]{remoteRoleInfo.getId()});
                    logger.warn(msg);
                    stringBuilder.append(msg);
                    continue;
                }
                long remoteTargetSid = remoteRoleInfo.getSid();
                long targetSid = roleInfo2.getSid();
                String type = "role";
                this.handlePolicy(type, remoteSysCascade, remoteTargetSid, iamUri, integrationUserToken, targetSid, tenantSid, sysCascade, stringBuilder);
            }
            List remoteFilterUserList = remoteUserInfosList.getUserBasicInformation().stream().filter(x -> !x.getUser().getId().endsWith("@digiwin.com")).collect(Collectors.toList());
            for (UserBasicInfoVO remoteUserBasicInfo : remoteFilterUserList) {
                User remoteUser = remoteUserBasicInfo.getUser();
                UserBasicInfoVO userBasicInfo = userInfosList2.getUserBasicInformation().stream().filter(userBasicInfoVO -> userBasicInfoVO.getUser().getId().equals(remoteUser.getId())).findFirst().orElse(null);
                if (userBasicInfo == null) {
                    String msg = StrUtil.format((CharSequence)"\u3010\u7528\u6237\u6743\u9650\u3011\u672c\u5730\u7528\u6237={}\u4e3a\u7a7a\uff0c \u8df3\u8fc7\uff1b\n", (Object[])new Object[]{remoteUser.getId()});
                    logger.warn(msg);
                    stringBuilder.append(msg);
                    continue;
                }
                long remoteTargetSid = remoteUser.getSid();
                long targetSid = userBasicInfo.getUser().getSid();
                String type = "user";
                this.handlePolicy(type, remoteSysCascade, remoteTargetSid, iamUri, integrationUserToken, targetSid, tenantSid, sysCascade, stringBuilder);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String upgradeTenantsApps(TenantAppUpgradeDTO dto, AuthoredUser authoredUser) {
        List<String> tenantIds = dto.getTenantIds();
        Map<String, String> apps = dto.getApps();
        Map<String, Map<String, String>> actions = dto.getActions();
        Boolean expiredOldSys = dto.getExpiredOldSys();
        StringBuilder stringBuilder = new StringBuilder();
        List<Tenant> tenantList = this.tenantRepository.findByIdIn(tenantIds);
        if (tenantList.isEmpty()) {
            throw new BusinessException("\u79df\u6237\u4e0d\u5b58\u5728, tenantIds=" + tenantIds);
        }
        ArrayList<String> ids = new ArrayList<String>(tenantIds);
        ids.removeAll(tenantList.stream().map(BaseEntityWithId::getId).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty(ids)) {
            throw new BusinessException("\u79df\u6237\u4e0d\u5b58\u5728, tenantIds=" + ids);
        }
        Map<String, Tenant> tenantMap = tenantList.stream().collect(Collectors.toMap(BaseEntityWithId::getId, x -> x, (k1, k2) -> k1));
        for (Map.Entry<String, Tenant> tenantEntry : tenantMap.entrySet()) {
            String tenantId = tenantEntry.getKey();
            Tenant tenant = tenantEntry.getValue();
            long tenantSid = tenant.getSid();
            TenantApplicationDTO tenantApplicationDTO = new TenantApplicationDTO(tenantId);
            tenantApplicationDTO.setCountApiInvoke(true);
            List<TenantApplication> tenantApplications = this.tenantQueryService.getTenantApplicationAndPlatFormByTenant(tenantApplicationDTO);
            tenantApplications.removeIf(a -> StrUtils.isNotEmpty((String)a.getBundleCode()));
            List tenantAppIdList = tenantApplications.stream().map(TenantApplication::getId).collect(Collectors.toList());
            logger.info("\u79df\u6237[{}]\u6388\u6743\u5e94\u7528list = {}", (Object)tenantId, tenantAppIdList);
            Map<String, List<OrgRoleTreeNode>> orgRoleTrees = this.orgQueryService.findOrgRoleTreeByTenantSid(tenantSid);
            List<OrgRoleTreeNode> defaultOrgAspect = orgRoleTrees.get("defaultOrgAspect");
            logger.info("\u79df\u6237[{}] \u7ec4\u7ec7\u6570\u91cf defaultOrgAspect.size() = {}", (Object)tenantId, (Object)defaultOrgAspect.size());
            List<RoleQueryResultVO> roleInfoList = this.roleQueryService.getRoleQueryResultVosByType(false, tenantSid);
            logger.info("\u79df\u6237[{}] \u89d2\u8272\u6570\u91cf roleInfoList.size() = {}", (Object)tenantId, (Object)roleInfoList.size());
            QueryPageVO pageVO = new QueryPageVO();
            pageVO.setPageCount(9999L);
            UserBasicInfoResultVO userInfosList = this.userBasicInfoQueryService.getUserBasicInfosByTenantWithPage(tenantSid, pageVO);
            logger.info("\u79df\u6237[{}] \u7528\u6237\u6570\u91cf userInfosList.size() = {}", (Object)tenantId, (Object)userInfosList.getTotalCount());
            for (Map.Entry<String, String> appEntry : apps.entrySet()) {
                String type;
                String msg;
                String oldAppId = appEntry.getKey();
                String newAppId = appEntry.getValue();
                if (!tenantAppIdList.contains(oldAppId)) {
                    msg = StrUtil.format((CharSequence)"\u79df\u6237[{}]\u65e0\u65e7\u5e94\u7528{}\u7684\u6388\u6743\uff0c\u8df3\u8fc7\uff1b", (Object[])new Object[]{tenantId, oldAppId});
                    logger.warn(msg);
                    stringBuilder.append(msg);
                    continue;
                }
                if (!tenantAppIdList.contains(newAppId)) {
                    msg = StrUtil.format((CharSequence)"\u79df\u6237[{}]\u65e0\u65b0\u5e94\u7528{}\u7684\u6388\u6743\uff0c\u8df3\u8fc7\uff1b", (Object[])new Object[]{tenantId, newAppId});
                    logger.warn(msg);
                    stringBuilder.append(msg);
                    continue;
                }
                SysCascade oldSysCascade = this.sysQueryService.getSysCascadeBySid(tenantSid, tenantId, 0L, oldAppId, false, true);
                if (oldSysCascade == null) {
                    String msg2 = StrUtil.format((CharSequence)"\u3010\u529f\u80fd\u6743\u9650\u3011\u79df\u6237[{}] \u67e5\u8be2\u65e7\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a oldSysCascade = {}\uff0c \u8df3\u8fc7\uff1b", (Object[])new Object[]{tenantId, oldAppId});
                    logger.warn(msg2);
                    stringBuilder.append(msg2);
                    continue;
                }
                SysCascade newSysCascade = this.sysQueryService.getSysCascadeBySid(tenantSid, tenantId, 0L, newAppId, false, true);
                if (newSysCascade == null) {
                    String msg3 = StrUtil.format((CharSequence)"\u3010\u529f\u80fd\u6743\u9650\u3011\u79df\u6237[{}] \u67e5\u8be2\u65b0\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a newSysCascade = {}\uff0c \u8df3\u8fc7\uff1b", (Object[])new Object[]{tenantId, newAppId});
                    logger.warn(msg3);
                    stringBuilder.append(msg3);
                    continue;
                }
                List<String> authUserIdList = this.cacService.queryAuthUser(tenantId, oldAppId);
                logger.info("\u3010\u6388\u6743\u7528\u6237\u3011tenantId = {}, appId = {}, \u6388\u6743\u7528\u6237 = {}", new Object[]{tenantId, oldAppId, authUserIdList});
                if (CollectionUtils.isEmpty(authUserIdList)) {
                    String msg4 = String.format("\u3010\u6388\u6743\u7528\u6237\u3011\u8df3\u8fc7\u79df\u6237%s\uff0c\u6388\u6743\u5e94\u7528%s\u4e0b\u65e0\u7528\u6237\uff1b", tenantId, oldAppId);
                    logger.info(msg4);
                    stringBuilder.append(msg4);
                } else {
                    int batchSize = 500;
                    for (int i = 0; i < authUserIdList.size(); i += batchSize) {
                        int end = Math.min(i + batchSize, authUserIdList.size());
                        List<String> batch = authUserIdList.subList(i, end);
                        this.cacService.batchAddIncremental(newAppId, batch, tenantId);
                        this.sleepMillis();
                    }
                }
                if (!CollectionUtils.isEmpty(defaultOrgAspect)) {
                    for (OrgRoleTreeNode remoteOrgRoleTreeNode : defaultOrgAspect) {
                        this.processOrgRoleTreeNode(remoteOrgRoleTreeNode, tenantSid, oldSysCascade, newSysCascade, actions, stringBuilder);
                    }
                }
                for (RoleQueryResultVO roleInfo : roleInfoList) {
                    if ("superadmin".equals(roleInfo.getId())) continue;
                    long targetSid = roleInfo.getSid();
                    type = "role";
                    this.handlePolicy(type, oldSysCascade, targetSid, tenantSid, newSysCascade, actions, stringBuilder);
                }
                for (UserBasicInfoVO userBasicInfo : userInfosList.getUserBasicInformation()) {
                    long targetSid = userBasicInfo.getUser().getSid();
                    type = "user";
                    this.handlePolicy(type, oldSysCascade, targetSid, tenantSid, newSysCascade, actions, stringBuilder);
                }
                if (!Boolean.TRUE.equals(expiredOldSys)) continue;
                ProductTypeVO productType = new ProductTypeVO(tenantId, oldAppId, BatchCodeUtil.generateBatchCode(BatchCodeUtil.API), StrUtil.format((CharSequence)"\u8fc1\u79fb\u591a\u4e2a\u79df\u6237\u4e0b\u7684\u591a\u4e2a\u5e94\u7528\u7684\u6388\u6743\u8d44\u6599\u53ca\u4f5c\u4e1a\u6743\u9650\uff0c\u8fc7\u671f\u65e7\u5e94\u7528\uff0c\u64cd\u4f5c\u4eba={}", (Object[])new Object[]{authoredUser.getUserId()}));
                this.cacService.updateGoodsAndModuleExpiredDateTime(productType);
                this.sleepMillis();
            }
        }
        return stringBuilder.toString();
    }

    private void handlePolicy(String type, SysCascade oldSysCascade, long targetSid, long tenantSid, SysCascade newSysCascade, Map<String, Map<String, String>> actions, StringBuilder stringBuilder) {
        TargetPolicy getActionInput = new TargetPolicy();
        getActionInput.setTenantSid(tenantSid);
        getActionInput.setType(type);
        getActionInput.setSysSid(oldSysCascade.getApp().getSid());
        getActionInput.setTargetSid(targetSid);
        Map<Long, String> oldPolicyActionActualMap = this.policyHandleService.getPolicyActionActual(getActionInput.getTenantSid(), getActionInput.getSysSid(), getActionInput.getTargetSid(), getActionInput.getType());
        BatchSaveTargetPolicyRequestVO batchSaveTargetPolicyInput = new BatchSaveTargetPolicyRequestVO();
        batchSaveTargetPolicyInput.setType(type);
        batchSaveTargetPolicyInput.setTargetSid(targetSid);
        batchSaveTargetPolicyInput.setTenantSid(tenantSid);
        batchSaveTargetPolicyInput.setSysSid(newSysCascade.getApp().getSid());
        ArrayList<TargetPolicy> targets = new ArrayList<TargetPolicy>();
        batchSaveTargetPolicyInput.setTargets(targets);
        ArrayList<TargetPolicy> savePolicyActionConditionList = new ArrayList<TargetPolicy>();
        if (!oldPolicyActionActualMap.isEmpty()) {
            for (Map.Entry<Long, String> oldPolicyActionActualEntry : oldPolicyActionActualMap.entrySet()) {
                Long oldModuleOrActionSid = oldPolicyActionActualEntry.getKey();
                String oldTargetValue = oldPolicyActionActualEntry.getValue();
                TargetPolicy target = new TargetPolicy();
                List<ActionQueryResultVO> oldSysCascadeActions = oldSysCascade.getActions();
                if (CollectionUtils.isEmpty(oldSysCascadeActions)) continue;
                boolean existed = false;
                block1: for (ActionQueryResultVO oldAction : oldSysCascadeActions) {
                    String moduleId;
                    if (oldAction.getModuleSid().equals(oldModuleOrActionSid)) {
                        existed = true;
                        moduleId = oldAction.getModuleId();
                        List<ActionQueryResultVO> sysCascadeActions = newSysCascade.getActions();
                        if (CollectionUtils.isEmpty(sysCascadeActions)) continue;
                        for (ActionQueryResultVO sysAction : sysCascadeActions) {
                            if (!sysAction.getModuleId().equals(moduleId)) continue;
                            target.setModuleSid(sysAction.getModuleSid());
                            if ("allow".equals(oldTargetValue)) {
                                target.setEffect(true);
                                targets.add(target);
                                continue block1;
                            }
                            if (!"deny".equals(oldTargetValue)) continue;
                            target.setEffect(false);
                            targets.add(target);
                            continue block1;
                        }
                        continue;
                    }
                    if (!oldAction.getSid().equals(oldModuleOrActionSid)) continue;
                    existed = true;
                    moduleId = oldAction.getModuleId();
                    String oldActionId = oldAction.getId();
                    Map<String, String> appActions = actions.get(oldSysCascade.getApp().getId());
                    if (CollectionUtils.isEmpty(appActions)) {
                        String msg = StrUtil.format((CharSequence)"\u3010\u529f\u80fd\u6743\u9650\u3011\u79df\u6237[{}] \u67e5\u8be2\u5e94\u7528[{}]\u884c\u4e3a\u6620\u5c04\u5173\u7cfb\u4e3a\u7a7a\uff0c\u8df3\u8fc7\uff1b", (Object[])new Object[]{tenantSid, oldSysCascade.getApp().getId()});
                        logger.warn(msg);
                        stringBuilder.append(msg);
                        continue;
                    }
                    String newActionId = appActions.get(oldActionId);
                    if (!StringUtils.hasText((String)newActionId)) {
                        String msg = StrUtil.format((CharSequence)"\u3010\u529f\u80fd\u6743\u9650\u3011\u79df\u6237[{}] \u67e5\u8be2\u5e94\u7528[{}]\u884c\u4e3a[{}]\u6620\u5c04\u5173\u7cfb\u4e3a\u7a7a\uff0c\u8df3\u8fc7\uff1b", (Object[])new Object[]{tenantSid, oldSysCascade.getApp().getId(), oldActionId});
                        logger.warn(msg);
                        stringBuilder.append(msg);
                        continue;
                    }
                    List<ActionQueryResultVO> sysCascadeActions = newSysCascade.getActions();
                    if (CollectionUtils.isEmpty(sysCascadeActions)) continue;
                    boolean existed2 = false;
                    for (ActionQueryResultVO sysAction : sysCascadeActions) {
                        if (!sysAction.getModuleId().equals(moduleId) || !sysAction.getId().equals(newActionId)) continue;
                        existed2 = true;
                        target.setActionSid(sysAction.getSid());
                        if ("allow".equals(oldTargetValue)) {
                            List<TargetCondition> oldConditionValueList;
                            target.setEffect(true);
                            targets.add(target);
                            TargetPolicy remoteConditionInput = new TargetPolicy();
                            com.digiwin.dap.middleware.commons.util.BeanUtils.mergeDifferentTypeObject((Object)getActionInput, (Object)remoteConditionInput);
                            remoteConditionInput.setActionSid(oldAction.getSid());
                            TargetPolicy oldActionInput = this.policyHandleService.queryConditionValue(remoteConditionInput);
                            if (oldActionInput == null || CollectionUtils.isEmpty(oldConditionValueList = oldActionInput.getConditionValue())) break;
                            TargetPolicy savePolicyActionCondition = new TargetPolicy();
                            savePolicyActionCondition.setTenantSid(tenantSid);
                            savePolicyActionCondition.setType(getActionInput.getType());
                            savePolicyActionCondition.setTargetSid(targetSid);
                            savePolicyActionCondition.setSysSid(newSysCascade.getApp().getSid());
                            savePolicyActionCondition.setActionSid(sysAction.getSid());
                            ArrayList<TargetCondition> conditionValueList = new ArrayList<TargetCondition>();
                            savePolicyActionCondition.setConditionValue(conditionValueList);
                            for (TargetCondition oldCondition : oldConditionValueList) {
                                String oldCconditionKey = oldCondition.getKey();
                                String oldConditionValue = oldCondition.getValue();
                                List<ConditionQueryResultVO> conditionList = sysAction.getCondition();
                                if (CollectionUtils.isEmpty(conditionList)) continue;
                                for (ConditionQueryResultVO condition : conditionList) {
                                    String conditionKey = condition.getKey();
                                    if (!oldCconditionKey.equals(conditionKey)) continue;
                                    TargetCondition targetCondition = new TargetCondition();
                                    com.digiwin.dap.middleware.commons.util.BeanUtils.mergeDifferentTypeObject((Object)condition, (Object)targetCondition);
                                    targetCondition.setValue(oldConditionValue);
                                    conditionValueList.add(targetCondition);
                                }
                            }
                            if (conditionValueList.isEmpty()) break;
                            savePolicyActionConditionList.add(savePolicyActionCondition);
                            break;
                        }
                        if (!"deny".equals(oldTargetValue)) continue;
                        target.setEffect(false);
                        targets.add(target);
                        break;
                    }
                    if (existed2) continue;
                    String msg = StrUtil.format((CharSequence)"\u3010{}\u6743\u9650\u3011\u79df\u6237[{}] \u67e5\u627emoduleId={}, oldActionId={}\u4e3a\u7a7a\uff0c \u8df3\u8fc7\uff1b", (Object[])new Object[]{type, tenantSid, moduleId, oldActionId});
                    logger.warn(msg);
                    stringBuilder.append(msg);
                }
                if (existed) continue;
                String msg = StrUtil.format((CharSequence)"\u3010{}\u6743\u9650\u3011\u79df\u6237[{}] \u67e5\u627emodule action oldModuleOrActionSid={}\u4e3a\u7a7a\uff0c \u8df3\u8fc7\uff1b", (Object[])new Object[]{type, tenantSid, oldModuleOrActionSid});
                logger.warn(msg);
                stringBuilder.append(msg);
            }
            if (!CollectionUtils.isEmpty(targets)) {
                this.policyHandleService.batchUpdate(batchSaveTargetPolicyInput);
                for (TargetPolicy savePolicyActionCondition : savePolicyActionConditionList) {
                    Policy policy = this.policyHandleService.savePolicy(savePolicyActionCondition.getTenantSid(), savePolicyActionCondition.getSysSid(), savePolicyActionCondition.getTargetSid(), savePolicyActionCondition.getType());
                    this.policyHandleService.saveConditionValue(policy.getSid(), savePolicyActionCondition);
                }
            }
        }
    }

    private void processOrgRoleTreeNode(OrgRoleTreeNode remoteOrgRoleTreeNode, long tenantSid, SysCascade remoteSysCascade, SysCascade sysCascade, Map<String, Map<String, String>> actions, StringBuilder stringBuilder) {
        long targetSid = remoteOrgRoleTreeNode.getKey();
        String type = "org";
        this.handlePolicy(type, remoteSysCascade, targetSid, tenantSid, sysCascade, actions, stringBuilder);
        List<OrgRoleTreeNode> children = remoteOrgRoleTreeNode.getChildren();
        if (!CollectionUtils.isEmpty(children)) {
            for (OrgRoleTreeNode child : children) {
                this.processOrgRoleTreeNode(child, tenantSid, remoteSysCascade, sysCascade, actions, stringBuilder);
            }
        }
    }

    private void processOrgRoleTreeNode(OrgRoleTreeNode remoteOrgRoleTreeNode, long tenantSid, SysCascade remoteSysCascade, SysCascade sysCascade, String iamUri, String integrationUserToken, StringBuilder stringBuilder) {
        long remoteTargetSid;
        long targetSid = remoteTargetSid = remoteOrgRoleTreeNode.getKey();
        String type = "org";
        this.handlePolicy(type, remoteSysCascade, remoteTargetSid, iamUri, integrationUserToken, targetSid, tenantSid, sysCascade, stringBuilder);
        List<OrgRoleTreeNode> children = remoteOrgRoleTreeNode.getChildren();
        if (!CollectionUtils.isEmpty(children)) {
            for (OrgRoleTreeNode child : children) {
                this.processOrgRoleTreeNode(child, tenantSid, remoteSysCascade, sysCascade, iamUri, integrationUserToken, stringBuilder);
            }
        }
    }

    private void handlePolicy(String type, SysCascade remoteSysCascade, long remoteTargetSid, String iamUri, String integrationUserToken, long targetSid, long tenantSid, SysCascade sysCascade, StringBuilder stringBuilder) {
        TargetPolicy remoteGetActionInput = new TargetPolicy();
        remoteGetActionInput.setType(type);
        remoteGetActionInput.setSysSid(remoteSysCascade.getApp().getSid());
        remoteGetActionInput.setTargetSid(remoteTargetSid);
        Map<Long, String> remotePolicyActionActualMap = this.remoteIamService.getAction(remoteGetActionInput, iamUri, integrationUserToken);
        BatchSaveTargetPolicyRequestVO batchSaveTargetPolicyInput = new BatchSaveTargetPolicyRequestVO();
        batchSaveTargetPolicyInput.setType(type);
        batchSaveTargetPolicyInput.setTargetSid(targetSid);
        batchSaveTargetPolicyInput.setTenantSid(tenantSid);
        batchSaveTargetPolicyInput.setSysSid(sysCascade.getApp().getSid());
        ArrayList<TargetPolicy> targets = new ArrayList<TargetPolicy>();
        batchSaveTargetPolicyInput.setTargets(targets);
        ArrayList<TargetPolicy> savePolicyActionConditionList = new ArrayList<TargetPolicy>();
        if (!remotePolicyActionActualMap.isEmpty()) {
            for (Map.Entry<Long, String> remotePolicyActionActualEntry : remotePolicyActionActualMap.entrySet()) {
                Long remoteModuleOrActionSid = remotePolicyActionActualEntry.getKey();
                String remotetargetValue = remotePolicyActionActualEntry.getValue();
                TargetPolicy target = new TargetPolicy();
                List<ActionQueryResultVO> remoteSysCascadeActions = remoteSysCascade.getActions();
                if (CollectionUtils.isEmpty(remoteSysCascadeActions)) continue;
                boolean existed = false;
                block1: for (ActionQueryResultVO remoteAction : remoteSysCascadeActions) {
                    String moduleId;
                    if (remoteAction.getModuleSid().equals(remoteModuleOrActionSid)) {
                        existed = true;
                        moduleId = remoteAction.getModuleId();
                        List<ActionQueryResultVO> sysCascadeActions = sysCascade.getActions();
                        if (CollectionUtils.isEmpty(sysCascadeActions)) continue;
                        for (ActionQueryResultVO sysAction : sysCascadeActions) {
                            if (!sysAction.getModuleId().equals(moduleId)) continue;
                            target.setModuleSid(sysAction.getModuleSid());
                            if ("allow".equals(remotetargetValue)) {
                                target.setEffect(true);
                                targets.add(target);
                                continue block1;
                            }
                            if (!"deny".equals(remotetargetValue)) continue;
                            target.setEffect(false);
                            targets.add(target);
                            continue block1;
                        }
                        continue;
                    }
                    if (!remoteAction.getSid().equals(remoteModuleOrActionSid)) continue;
                    existed = true;
                    moduleId = remoteAction.getModuleId();
                    String actionId = remoteAction.getId();
                    List<ActionQueryResultVO> sysCascadeActions = sysCascade.getActions();
                    if (CollectionUtils.isEmpty(sysCascadeActions)) continue;
                    boolean existed2 = false;
                    for (ActionQueryResultVO sysAction : sysCascadeActions) {
                        if (!sysAction.getModuleId().equals(moduleId) || !sysAction.getId().equals(actionId)) continue;
                        existed2 = true;
                        target.setActionSid(sysAction.getSid());
                        if ("allow".equals(remotetargetValue)) {
                            List<TargetCondition> remoteConditionValueList;
                            target.setEffect(true);
                            targets.add(target);
                            TargetPolicy remoteConditionInput = new TargetPolicy();
                            com.digiwin.dap.middleware.commons.util.BeanUtils.mergeDifferentTypeObject((Object)remoteGetActionInput, (Object)remoteConditionInput);
                            remoteConditionInput.setActionSid(remoteAction.getSid());
                            TargetPolicy remoteActionInput = this.remoteIamService.getPolicyActionCondition(remoteConditionInput, iamUri, integrationUserToken);
                            if (remoteActionInput == null || CollectionUtils.isEmpty(remoteConditionValueList = remoteActionInput.getConditionValue())) break;
                            TargetPolicy savePolicyActionCondition = new TargetPolicy();
                            savePolicyActionCondition.setTenantSid(tenantSid);
                            savePolicyActionCondition.setType(remoteGetActionInput.getType());
                            savePolicyActionCondition.setTargetSid(targetSid);
                            savePolicyActionCondition.setSysSid(sysCascade.getApp().getSid());
                            savePolicyActionCondition.setActionSid(sysAction.getSid());
                            ArrayList<TargetCondition> conditionValueList = new ArrayList<TargetCondition>();
                            savePolicyActionCondition.setConditionValue(conditionValueList);
                            for (TargetCondition remoteCondition : remoteConditionValueList) {
                                String remoteCconditionKey = remoteCondition.getKey();
                                String remoteConditionValue = remoteCondition.getValue();
                                List<ConditionQueryResultVO> conditionList = sysAction.getCondition();
                                if (CollectionUtils.isEmpty(conditionList)) continue;
                                for (ConditionQueryResultVO condition : conditionList) {
                                    String conditionKey = condition.getKey();
                                    if (!remoteCconditionKey.equals(conditionKey)) continue;
                                    TargetCondition targetCondition = new TargetCondition();
                                    com.digiwin.dap.middleware.commons.util.BeanUtils.mergeDifferentTypeObject((Object)condition, (Object)targetCondition);
                                    targetCondition.setValue(remoteConditionValue);
                                    conditionValueList.add(targetCondition);
                                }
                            }
                            if (conditionValueList.isEmpty()) break;
                            savePolicyActionConditionList.add(savePolicyActionCondition);
                            break;
                        }
                        if (!"deny".equals(remotetargetValue)) continue;
                        target.setEffect(false);
                        targets.add(target);
                        break;
                    }
                    if (existed2) continue;
                    String msg = StrUtil.format((CharSequence)"\u3010{}\u6743\u9650\u3011\u67e5\u627e\u672c\u5730moduleId={}, actionId={}\u4e3a\u7a7a\uff0c \u8df3\u8fc7\uff1b\n", (Object[])new Object[]{type, moduleId, actionId});
                    logger.warn(msg);
                    stringBuilder.append(msg);
                }
                if (existed) continue;
                String msg = StrUtil.format((CharSequence)"\u3010{}\u6743\u9650\u3011\u67e5\u627e\u672c\u5730module action remoteModuleOrActionSid={}\u4e3a\u7a7a\uff0c \u8df3\u8fc7\uff1b\n", (Object[])new Object[]{type, remoteModuleOrActionSid});
                logger.warn(msg);
                stringBuilder.append(msg);
            }
            if (!CollectionUtils.isEmpty(targets)) {
                this.policyHandleService.batchUpdate(batchSaveTargetPolicyInput);
                for (TargetPolicy savePolicyActionCondition : savePolicyActionConditionList) {
                    Policy policy = this.policyHandleService.savePolicy(savePolicyActionCondition.getTenantSid(), savePolicyActionCondition.getSysSid(), savePolicyActionCondition.getTargetSid(), savePolicyActionCondition.getType());
                    this.policyHandleService.saveConditionValue(policy.getSid(), savePolicyActionCondition);
                }
            }
        }
    }

    private void sleepMillis() {
        try {
            logger.info("\u907f\u514d\u8fc7\u70ed\uff0c\u4f11\u606f{}s...", (Object)1L);
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

