/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.notice.impl;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middleware.iam.domain.notice.SysNoticeLogPage;
import com.digiwin.dap.middleware.iam.entity.SysNoticeLog;
import com.digiwin.dap.middleware.iam.repository.SysNoticeLogRepository;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeLogCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SysNoticeLogCrudServiceImpl
extends BaseEntityManagerService<SysNoticeLog>
implements SysNoticeLogCrudService {
    @Autowired
    private SysNoticeLogRepository sysNoticeLogRepository;

    protected SysNoticeLogRepository getRepository() {
        return this.sysNoticeLogRepository;
    }

    @Override
    public PageSerializable<?> findByPage(final SysNoticeLogPage body) {
        PageRequest pageable = PageRequest.of((int)(body.getPageNum() - 1), (int)body.getPageSize(), (Sort)Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"sid")}));
        Specification condition = new Specification(){

            public Predicate toPredicate(Root root, CriteriaQuery query, CriteriaBuilder cb) {
                Predicate predicate = cb.conjunction();
                if (body.getNoticeSid() != null) {
                    predicate.getExpressions().add(cb.equal((Expression)root.get("noticeSid"), (Object)body.getNoticeSid()));
                }
                if (StringUtils.hasText((String)body.getSysId())) {
                    predicate.getExpressions().add(cb.equal((Expression)root.get("sysId"), (Object)body.getSysId()));
                }
                if (StringUtils.hasText((String)body.getTypeId())) {
                    predicate.getExpressions().add(cb.equal((Expression)root.get("typeId"), (Object)body.getTypeId()));
                }
                if (body.getStatus() != null) {
                    predicate.getExpressions().add(cb.equal((Expression)root.get("status"), (Object)body.getStatus()));
                }
                return predicate;
            }
        };
        Page noticeLogs = this.sysNoticeLogRepository.findAll(condition, (Pageable)pageable);
        PageSerializable pageSerializable = PageSerializable.of((List)noticeLogs.getContent());
        pageSerializable.setTotal(noticeLogs.getTotalElements());
        return pageSerializable;
    }

    @Override
    public void log(long noticeSid, String sourceId, String sysId, String typeId, String noticeUrl, MessageBody messageBody) {
        this.log(noticeSid, sourceId, sysId, typeId, false, noticeUrl, 0, messageBody);
    }

    @Override
    public void log(long noticeSid, String sourceId, String sysId, String typeId, String noticeUrl, MessageBody messageBody, String message) {
        this.log(noticeSid, sourceId, sysId, typeId, false, noticeUrl, 0, messageBody, message);
    }

    @Override
    public void log(long noticeSid, String sourceId, String sysId, String typeId, boolean status, String noticeUrl, int statusCode, MessageBody messageBody) {
        this.log(noticeSid, sourceId, sysId, typeId, status, noticeUrl, statusCode, messageBody, messageBody.getMessage());
    }

    @Override
    public void log(long noticeSid, String sourceId, String sysId, String typeId, boolean status, String noticeUrl, int statusCode, MessageBody messageBody, String message) {
        SysNoticeLog log = new SysNoticeLog();
        log.setNoticeSid(noticeSid);
        log.setSourceId(sourceId);
        log.setSysId(sysId);
        log.setTypeId(typeId);
        log.setStatus(status);
        log.setNoticeUrl(noticeUrl);
        log.setStatusCode(statusCode);
        log.setRequestBody(JsonUtils.writeValue((Object)messageBody));
        log.setResponseBody(message);
        this.create(log);
    }
}

