/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.notice.impl;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.domain.MessageType;
import com.digiwin.dap.middle.stream.domain.SysNoticeEnum;
import com.digiwin.dap.middle.stream.producer.ProducerService;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.constant.DapHttpHeaders;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.enumeration.InternalSysNoticeTypeEnum;
import com.digiwin.dap.middleware.iam.domain.notice.SysNoticeVO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysNotice;
import com.digiwin.dap.middleware.iam.entity.SysNoticeDomain;
import com.digiwin.dap.middleware.iam.entity.SysNoticeLog;
import com.digiwin.dap.middleware.iam.entity.SysNoticeType;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeCrudService;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeDomainCrudService;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeLogCrudService;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeService;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeTypeCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.support.initialize.AsscInitializeService;
import com.digiwin.dap.middleware.iam.util.TempUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Service
public class SysNoticeServiceImpl
implements SysNoticeService {
    private static final Logger logger = LoggerFactory.getLogger(SysNoticeServiceImpl.class);
    private static final long ZERO = 0L;
    public static final List<String> TYPE_ID_LIST = Arrays.asList(SysNoticeEnum.APP_USER_JOINED.name(), SysNoticeEnum.EMP_DISABLE.name(), SysNoticeEnum.DELETE_CORP.name());
    @Qualifier(value="noticeRestTemplate")
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private ProducerService producerService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private SysNoticeCrudService sysNoticeCrudService;
    @Autowired
    private AsscInitializeService asscInitializeService;
    @Autowired
    private SysNoticeLogCrudService sysNoticeLogCrudService;
    @Autowired
    private SysNoticeTypeCrudService sysNoticeTypeCrudService;
    @Autowired
    private SysNoticeDomainCrudService sysNoticeDomainCrudService;

    @Override
    public void noticeSys(MessageBody messageBody) {
        this.noticeSys(messageBody, 0L);
    }

    private void noticeSys(MessageBody messageBody, long noticeSid) {
        String sourceId = messageBody.getSourceId();
        String sysId = messageBody.getSysId();
        String typeId = messageBody.getOpType();
        ArrayList<SysNotice> notices = new ArrayList<SysNotice>();
        if (noticeSid > 0L) {
            SysNotice sysNotice = (SysNotice)this.sysNoticeCrudService.findBySid(noticeSid);
            if (sysNotice != null) {
                notices.add(sysNotice);
            }
        } else {
            if (SysNoticeEnum.APP_CALLBACK.name().equals(typeId)) {
                this.doNoticeSys(0L, this.envProperties.getAppName(), sysId, messageBody.getBackUri(), messageBody);
                return;
            }
            if (SysNoticeEnum.SERVICE_NEW.name().equals(typeId)) {
                SysNotice serviceNotice = new SysNotice();
                serviceNotice.setSysId(sysId);
                serviceNotice.setTypeId(typeId);
                serviceNotice.setPath(SysNoticeEnum.SERVICE_NEW.path());
                serviceNotice.setEnable(true);
                serviceNotice.setBackUri(messageBody.getBackUri());
                notices.add(serviceNotice);
            } else if (TYPE_ID_LIST.contains(typeId)) {
                notices.addAll(this.sysNoticeCrudService.findByTypeId(typeId));
            } else {
                notices.addAll(this.sysNoticeCrudService.findBySysIdAndTypeId(sysId, typeId));
            }
        }
        if (notices.isEmpty()) {
            String msg = noticeSid > 0L ? "\u8be5\u8bb0\u5f55\u5bf9\u5e94\u7684\u4e8b\u4ef6(" + noticeSid + ")\u5df2\u7ecf\u88ab\u5220\u9664" : "\u672a\u914d\u7f6e\u8be5\u901a\u77e5\u4e8b\u4ef6\uff1a\u8bf7\u5230\u3010OM->\u5546\u54c1\u7ef4\u62a4->\u8bbe\u7f6e\u3011\u53bb\u914d\u7f6e\u8be5\u4e8b\u4ef6";
            messageBody.setMessage(msg);
            this.sysNoticeLogCrudService.log(0L, sourceId, sysId, typeId, null, messageBody);
            this.noticeInternal(sysId, null, messageBody, false);
            return;
        }
        for (SysNotice notice : notices) {
            String backUri = this.getBackUri(messageBody.getTenantId(), notice);
            String domain = TempUtils.getDomain(backUri);
            if (domain == null) {
                messageBody.setMessage("\u8bf7\u6c42\u5730\u5740\u65e0\u6548\uff1a" + notice.combineUrl(backUri));
                this.sysNoticeLogCrudService.log(notice.getSid(), sourceId, notice.getSysId(), notice.getTypeId(), null, messageBody);
                this.noticeInternal(notice.getSysId(), null, messageBody, true);
                continue;
            }
            this.noticeSys(sourceId, notice.combineUrl(domain), notice, messageBody);
            this.noticeInternal(notice.getSysId(), domain, messageBody, true);
        }
    }

    private String getBackUri(String tenantId, SysNotice sysNotice) {
        SysNoticeDomain noticeDomain;
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (tenant != null && (noticeDomain = this.sysNoticeDomainCrudService.findByNoticeSid(sysNotice.getSid(), tenant.getComeFrom())) != null && StringUtils.hasText((String)noticeDomain.getBackUri())) {
            return noticeDomain.getBackUri();
        }
        if (StringUtils.hasText((String)sysNotice.getBackUri())) {
            return sysNotice.getBackUri();
        }
        Sys sys = (Sys)this.sysCrudService.findById(sysNotice.getSysId());
        return sys == null ? null : sys.getBackUri();
    }

    private void noticeSys(String sourceId, String noticeUrl, SysNotice notice, MessageBody messageBody) {
        if (notice.isEnable()) {
            this.doNoticeSys(notice.getSid(), sourceId, notice.getSysId(), noticeUrl, messageBody);
        } else {
            messageBody.setMessage("\u672a\u542f\u7528\u8be5\u901a\u77e5\u4e8b\u4ef6\uff1a\u8bf7\u5230\u3010OM->\u5546\u54c1\u7ef4\u62a4->\u8bbe\u7f6e->\u7f16\u8f91->\u662f\u5426\u542f\u7528\u3011\u542f\u7528\u8be5\u4e8b\u4ef6");
            this.sysNoticeLogCrudService.log(notice.getSid(), sourceId, notice.getSysId(), notice.getTypeId(), noticeUrl, messageBody);
        }
    }

    private void doNoticeSys(long noticeSid, String sourceId, String sysId, String uri, MessageBody messageBody) {
        try {
            String json = JsonUtils.writeValue((Object)messageBody.getData());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set(DapHttpHeaders.USER_TOKEN.getHeader(), messageBody.getUserToken());
            HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, String.class, new Object[0]);
            messageBody.setSuccess(response.getStatusCode().is2xxSuccessful());
            this.sysNoticeLogCrudService.log(noticeSid, sourceId, sysId, messageBody.getOpType(), messageBody.isSuccess(), uri, response.getStatusCode().value(), messageBody);
        }
        catch (HttpStatusCodeException e) {
            messageBody.setMessage(e.getResponseBodyAsString());
            this.sysNoticeLogCrudService.log(noticeSid, sourceId, sysId, messageBody.getOpType(), false, uri, e.getStatusCode().value(), messageBody, e.getResponseBodyAsString());
        }
        catch (Exception e) {
            messageBody.setMessage(e.getMessage());
            this.sysNoticeLogCrudService.log(noticeSid, sourceId, sysId, messageBody.getOpType(), uri, messageBody, e.getMessage());
        }
    }

    private void noticeInternal(String sysId, String uri, MessageBody messageBody, boolean needMsg) {
        String noticeUri = messageBody.getNoticeUri();
        String opType = messageBody.getOpType();
        if (StringUtils.hasText((String)noticeUri) && (SysNoticeEnum.APP_NEW.name().equals(opType) || SysNoticeEnum.APP_RENEW.name().equals(opType) || SysNoticeEnum.APP_EXPIRED.name().equals(opType) || SysNoticeEnum.APP_ADD_PURCHASE.name().equals(opType))) {
            MessageBody data = MessageBody.of((String)opType, (Object)messageBody.getNoticeData());
            data.setSuccess(messageBody.isSuccess());
            data.setNeedMsg(needMsg);
            data.setMessage(messageBody.getMessage());
            MessageBody noticeBody = MessageBody.of((String)SysNoticeEnum.APP_CALLBACK.name(), (Object)data);
            noticeBody.setSourceId(this.envProperties.getAppName());
            noticeBody.setMsgType(MessageType.SYS);
            noticeBody.setSysId(sysId);
            this.doNoticeSys(0L, noticeBody.getSourceId(), sysId, noticeUri, noticeBody);
        }
        if (SysNoticeEnum.APP_NEW.name().equals(opType) && messageBody.isSuccess()) {
            this.noticeASSC(messageBody.getTenantSid(), sysId, uri);
        }
    }

    private void noticeASSC(long tenantSid, String sysId, String uri) {
        if (sysId.contains("ASSC")) {
            try {
                this.asscInitializeService.initializeAsscPermission(tenantSid, sysId, uri, Collections.emptyList());
            }
            catch (Exception e) {
                logger.error("\u521d\u59cb\u5316\u552e\u540e\u4e91\u89d2\u8272\u53ca\u529f\u80fd\u6743\u9650\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @Override
    public void retryNotice(long noticeLogSid) {
        SysNoticeLog noticeLog = (SysNoticeLog)this.sysNoticeLogCrudService.findBySid(noticeLogSid);
        if (noticeLog != null) {
            MessageBody messageBody = (MessageBody)JsonUtils.readValue((String)noticeLog.getRequestBody(), MessageBody.class);
            messageBody.setSourceId(this.envProperties.getAppName());
            messageBody.setBackUri(noticeLog.getNoticeUrl());
            this.noticeSys(messageBody, noticeLog.getNoticeSid());
        }
    }

    @Override
    public void createNotice4Athena(List<SysNoticeVO> body) {
        for (SysNoticeVO sysNoticeVO : body) {
            SysNoticeType noticeType = this.sysNoticeTypeCrudService.findById(sysNoticeVO.getTypeId());
            Optional.ofNullable(noticeType).ifPresent(it -> {
                List<SysNotice> notices = this.sysNoticeCrudService.findBySysId(sysNoticeVO.getSysId());
                Optional<SysNotice> notice = notices.stream().filter(p -> p.getTypeId().equals(sysNoticeVO.getTypeId())).findFirst();
                if (!notice.isPresent()) {
                    SysNotice sysNotice = (SysNotice)((Object)((Object)sysNoticeVO.doForward()));
                    sysNotice.setPath(it.getPath());
                    sysNotice.setDescription(it.getDescription());
                    this.sysNoticeCrudService.create(sysNotice);
                } else {
                    notice.get().setEnable(true);
                    this.sysNoticeCrudService.update(notice.get());
                }
            });
        }
    }

    @Override
    public void userJoined(Map<String, Object> data, String userToken) {
        MessageBody messageBody = MessageBody.of((String)SysNoticeEnum.APP_USER_JOINED.name(), data);
        messageBody.setUserToken(userToken);
        this.producerService.sys(messageBody);
    }

    @Override
    public void authUser(Tenant tenant, String appId, Object strategyId, AuthoredUser authoredUser) {
        HashMap<String, Object> noticeData = new HashMap<String, Object>();
        noticeData.put("tenantSid", tenant.getSid());
        noticeData.put("tenantId", tenant.getId());
        noticeData.put("tenantName", tenant.getName());
        noticeData.put("appId", appId);
        noticeData.put("strategyId", strategyId);
        HashMap<String, Object> user = new HashMap<String, Object>();
        user.put("sid", authoredUser.getSid());
        user.put("id", authoredUser.getUserId());
        user.put("name", authoredUser.getUserName());
        noticeData.put("user", user);
        MessageBody messageBody = MessageBody.of((String)SysNoticeEnum.AUTH_USER.name(), noticeData);
        messageBody.setUserToken(authoredUser.getToken());
        messageBody.setSysId(appId);
        messageBody.setTenantId(tenant.getId());
        messageBody.setTenantSid(Long.valueOf(tenant.getSid()));
        this.producerService.sys(messageBody);
    }

    @Override
    public void syncDevAppInfo(Map<String, Object> data) {
        MessageBody messageData = MessageBody.of((String)InternalSysNoticeTypeEnum.SYS_SYNC.name(), data);
        messageData.setUserToken(" ");
        messageData.setSysId("INTERNAL_IAM");
        this.producerService.sys(messageData);
    }

    @Override
    public void reAuthenticate(String userId, String userToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", userId);
        MessageBody messageData = MessageBody.of((String)InternalSysNoticeTypeEnum.USER_RE_AUTHENTICATE.name(), params);
        messageData.setUserToken(userToken);
        messageData.setSysId("INTERNAL_IAM");
        this.producerService.sys(messageData);
    }
}

