/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.oauth.impl;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthAccessToken;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthAccessTokenRequest;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthAppVO;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthAuthCode;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthAuthRequest;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthRefreshTokenRequest;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthScopeApiVO;
import com.digiwin.dap.middleware.iam.entity.OauthApp;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.OauthMapper;
import com.digiwin.dap.middleware.iam.repository.OauthAppRepository;
import com.digiwin.dap.middleware.iam.repository.OauthScopeRepository;
import com.digiwin.dap.middleware.iam.repository.UserInTenantRepository;
import com.digiwin.dap.middleware.iam.service.oauth.OauthAppCrudService;
import com.digiwin.dap.middleware.iam.service.oauth.OauthService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.UserUtils;
import com.digiwin.dmc.sdk.util.StringUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OauthServiceImpl
implements OauthService {
    @Autowired
    private OauthAppCrudService oauthAppCrudService;
    @Autowired
    private UserInTenantRepository userInTenantRepository;
    @Autowired
    private OauthAppRepository oauthAppRepository;
    @Autowired
    private OauthScopeRepository oauthScopeRepository;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private OauthMapper oauthMapper;
    @Autowired
    private AuthValidateService authValidateService;

    @Override
    public long registerApp(OauthAppVO oauthAppVO) {
        String secret;
        String appId = oauthAppVO.getId();
        if (StringUtils.isEmpty((Object)appId)) {
            appId = UUID.randomUUID().toString().replace("-", "");
            oauthAppVO.setId(appId);
        }
        if (StringUtils.isEmpty((Object)(secret = oauthAppVO.getSecret()))) {
            String content = String.format("%s_@#$_%s_%s", appId, oauthAppVO.getTenantSid(), System.currentTimeMillis());
            secret = AES.encryptCBC((String)content, (String)KeyConstant.OTHER);
            oauthAppVO.setSecret(secret);
        }
        OauthApp oauthApp = oauthAppVO.generateEntity();
        return this.oauthAppCrudService.create(oauthApp);
    }

    @Override
    public long updateApp(OauthAppVO oauthAppVO) {
        if (oauthAppVO.getSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED);
        }
        OauthApp oauthApp = (OauthApp)this.oauthAppCrudService.findBySid(oauthAppVO.getSid());
        if (oauthApp == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{oauthAppVO.getSid()});
        }
        if (UserUtils.getTenantSid() != oauthApp.getTenantSid() && !this.authValidateService.checkAccessPermission("Sys", AppAuthContextHolder.getContext().getRequestInfo().getMethod(), AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        oauthApp.setDescription(oauthAppVO.getDescription());
        oauthApp.setName(oauthAppVO.getName());
        oauthApp.setCallbackUrl(oauthAppVO.getCallbackUrl());
        this.oauthAppCrudService.update(oauthApp);
        return oauthApp.getSid();
    }

    @Override
    public OauthAuthCode getAuthCode(OauthAuthRequest oauthAuthRequest, AuthoredUser authoredUser) {
        return this.getCommonAuthCode(oauthAuthRequest.getAppId(), oauthAuthRequest.getCallbackUrl(), oauthAuthRequest.getScope(), authoredUser);
    }

    @Override
    public OauthAuthCode getCommonAuthCode(String clientId, String redirectUri, String scope, AuthoredUser authoredUser) {
        OauthAuthCode oauthAuthCode;
        OauthApp oauthApp = this.oauthAppRepository.findById(clientId);
        if (oauthApp == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{clientId});
        }
        List<UserInTenant> userInTenants = this.userInTenantRepository.findByUserSid(authoredUser.getSid());
        if (userInTenants.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.USER_IN_TENANT_NOT_EXIST, new Object[]{authoredUser.getSid()});
        }
        if (!StringUtil.isEmpty((String)redirectUri) && !redirectUri.equals(oauthApp.getCallbackUrl())) {
            throw new BusinessException((ErrorHandler)I18nError.REDIRECT_ERROR, new Object[]{redirectUri, oauthApp.getCallbackUrl()});
        }
        ArrayList<String> scopeList = new ArrayList<String>();
        if (!StringUtil.isEmpty((String)scope)) {
            String[] scopes = scope.split(",");
            List<String> existedScopes = this.oauthScopeRepository.findAllIds();
            StringBuilder stringBuilder = new StringBuilder();
            for (String s : scopes) {
                if (!existedScopes.contains(s)) {
                    stringBuilder.append(s).append(";");
                    continue;
                }
                scopeList.add(s);
            }
            if (stringBuilder.length() > 0) {
                throw new BusinessException((ErrorHandler)I18nError.AUTHORITY_SCOPE_NOT_EXIST, new Object[]{stringBuilder.toString()});
            }
        } else {
            scopeList.add("user_read");
        }
        String authCode = UUID.randomUUID().toString().replace("-", "");
        String authCodeKey = this.uniqueKey(authCode, "iam:oauth:auth:code:%s");
        if (!RedisUtils.hasKey((String)authCodeKey)) {
            oauthAuthCode = new OauthAuthCode();
            oauthAuthCode.setCode(authCode);
            oauthAuthCode.setUserSid(authoredUser.getSid());
            oauthAuthCode.setScopes(scopeList);
            oauthAuthCode.setTenantSid(authoredUser.getTenantSid());
            oauthAuthCode.setTenantId(authoredUser.getTenantId());
            RedisUtils.set((String)authCodeKey, (Object)oauthAuthCode, (Duration)Duration.ofMinutes(10L));
        } else {
            oauthAuthCode = (OauthAuthCode)RedisUtils.get((Object)authCodeKey, OauthAuthCode.class);
        }
        return oauthAuthCode;
    }

    @Override
    public OauthAccessToken getAccessToken(OauthAccessTokenRequest oauthAccessTokenRequest) {
        User user;
        OauthApp oauthApp = this.oauthAppRepository.findById(oauthAccessTokenRequest.getAppId());
        if (oauthApp == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{oauthAccessTokenRequest.getAppId()});
        }
        if (!oauthAccessTokenRequest.getSecret().equals(oauthApp.getSecret())) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_SECRET_ERROR, new Object[]{oauthAccessTokenRequest.getSecret()});
        }
        if (!"authorization_code".equals(oauthAccessTokenRequest.getGrantType())) {
            throw new BusinessException((ErrorHandler)I18nError.GRANT_TYPE_ERROR);
        }
        String authCodeKey = this.uniqueKey(oauthAccessTokenRequest.getCode(), "iam:oauth:auth:code:%s");
        if (!RedisUtils.hasKey((String)authCodeKey)) {
            throw new BusinessException((ErrorHandler)I18nError.AUTHORITY_CODE_ERROR, new Object[]{oauthAccessTokenRequest.getCode()});
        }
        OauthAuthCode oauthAuthCode = (OauthAuthCode)RedisUtils.get((Object)authCodeKey, OauthAuthCode.class);
        if (!StringUtils.isEmpty((Object)oauthAuthCode.getState()) && !oauthAuthCode.getState().equals(oauthAccessTokenRequest.getState())) {
            throw new BusinessException((ErrorHandler)I18nError.REQUEST_AUTHORITY_PARAM_ERROR);
        }
        if (StringUtils.isEmpty((Object)oauthAccessTokenRequest.getScope())) {
            if (!(oauthAuthCode.getScopes().isEmpty() || oauthAuthCode.getScopes().size() <= 1 && oauthAuthCode.getScopes().contains("user_read"))) {
                throw new BusinessException((ErrorHandler)I18nError.REQUEST_AUTHORITY_SCOPE_ERROR);
            }
        } else {
            String[] scopes;
            for (String scope : scopes = oauthAccessTokenRequest.getScope().split(",")) {
                if (oauthAuthCode.getScopes().contains(scope)) continue;
                throw new BusinessException((ErrorHandler)I18nError.REQUEST_AUTHORITY_SCOPE_ERROR);
            }
        }
        if ((user = (User)this.userCrudService.findBySid(oauthAuthCode.getUserSid())) == null) {
            throw new BusinessException((ErrorHandler)I18nError.REQUEST_AUTHORITY_USER_ERROR, new Object[]{oauthAuthCode.getUserSid()});
        }
        List<UserInTenant> userInTenants = this.userInTenantRepository.findByUserSid(oauthAuthCode.getUserSid());
        if (userInTenants.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.USER_IN_TENANT_NOT_EXIST, new Object[]{oauthAuthCode.getUserSid()});
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(oauthAuthCode.getTenantSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{oauthApp.getTenantSid()});
        }
        String accessToken = UUID.randomUUID().toString();
        String accessTokenKey = this.uniqueKey(accessToken, "iam:oauth:access:token:%s");
        String refreshToken = UUID.randomUUID().toString();
        String refreshTokenKey = this.uniqueKey(refreshToken, "iam:oauth:refresh:token:%s");
        IamAuthoredUser authoredUser = IamAuthoredUser.createAuthoredUser(user, tenant);
        authoredUser.setAppId(oauthApp.getId());
        authoredUser.setToken(accessToken);
        if (!oauthAuthCode.getScopes().isEmpty()) {
            List<OauthScopeApiVO> oauthScopeApiVOS = this.oauthMapper.getApisByScope(oauthAuthCode.getScopes());
            authoredUser.setAuthoredApis(oauthScopeApiVOS);
        }
        RedisUtils.set((String)accessTokenKey, (Object)authoredUser, (Duration)Duration.ofMillis(this.envProperties.getOauthTokenExpire() * 60L * 1000L));
        RedisUtils.delete((String)authCodeKey);
        OauthAccessToken oauthAccessToken = new OauthAccessToken();
        oauthAccessToken.setAccessToken(accessToken);
        oauthAccessToken.setExpireIn(String.valueOf(this.envProperties.getOauthTokenExpire() * 60L));
        oauthAccessToken.setUserSid(oauthAuthCode.getUserSid());
        oauthAccessToken.setRefreshToken(refreshToken);
        RedisUtils.set((String)refreshTokenKey, (Object)authoredUser, (Duration)Duration.ofMinutes(this.envProperties.getTokenExpire()));
        return oauthAccessToken;
    }

    @Override
    public Map<String, Object> getCommonAccessToken(OauthAccessTokenRequest oauthAccessTokenRequest) {
        OauthAccessToken oauthAccessToken = this.getAccessTokenCore(oauthAccessTokenRequest.getClient_id(), oauthAccessTokenRequest.getClient_secret(), oauthAccessTokenRequest.getGrant_type(), oauthAccessTokenRequest.getCode());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("access_token", oauthAccessToken.getAccessToken());
        result.put("expires_in", oauthAccessToken.getExpireIn());
        result.put("token_type", "Bearer");
        result.put("refresh_token", oauthAccessToken.getRefreshToken());
        result.put("user_sid", oauthAccessToken.getUserSid());
        return result;
    }

    private OauthAccessToken getAccessTokenCore(String clientId, String secret, String grantType, String code) {
        OauthApp oauthApp = this.oauthAppRepository.findById(clientId);
        if (oauthApp == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{clientId});
        }
        if (!StringUtils.isEmpty((Object)secret) && !secret.equals(oauthApp.getSecret())) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_SECRET_ERROR, new Object[]{secret});
        }
        if (!"authorization_code".equals(grantType)) {
            throw new BusinessException((ErrorHandler)I18nError.GRANT_TYPE_ERROR);
        }
        String authCodeKey = this.uniqueKey(code, "iam:oauth:auth:code:%s");
        if (!RedisUtils.hasKey((String)authCodeKey)) {
            throw new BusinessException((ErrorHandler)I18nError.AUTHORITY_CODE_ERROR, new Object[]{code});
        }
        OauthAuthCode oauthAuthCode = (OauthAuthCode)RedisUtils.get((Object)authCodeKey, OauthAuthCode.class);
        User user = (User)this.userCrudService.findBySid(oauthAuthCode.getUserSid());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.REQUEST_AUTHORITY_USER_ERROR, new Object[]{oauthAuthCode.getUserSid()});
        }
        List<UserInTenant> userInTenants = this.userInTenantRepository.findByUserSid(oauthAuthCode.getUserSid());
        if (userInTenants.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.USER_IN_TENANT_NOT_EXIST, new Object[]{oauthAuthCode.getUserSid()});
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(oauthAuthCode.getTenantSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{oauthAuthCode.getTenantSid()});
        }
        String accessToken = UUID.randomUUID().toString();
        String accessTokenKey = this.uniqueKey(accessToken, "iam:oauth:access:token:%s");
        String refreshToken = UUID.randomUUID().toString();
        String refreshTokenKey = this.uniqueKey(refreshToken, "iam:oauth:refresh:token:%s");
        IamAuthoredUser authoredUser = IamAuthoredUser.createAuthoredUser(user, tenant);
        authoredUser.setAppId(oauthApp.getId());
        authoredUser.setToken(accessToken);
        if (!oauthAuthCode.getScopes().isEmpty()) {
            List<OauthScopeApiVO> oauthScopeApiVOS = this.oauthMapper.getApisByScope(oauthAuthCode.getScopes());
            authoredUser.setAuthoredApis(oauthScopeApiVOS);
        }
        RedisUtils.set((String)accessTokenKey, (Object)authoredUser, (Duration)Duration.ofMillis(this.envProperties.getOauthTokenExpire() * 60L * 1000L));
        RedisUtils.delete((String)authCodeKey);
        OauthAccessToken oauthAccessToken = new OauthAccessToken();
        oauthAccessToken.setAccessToken(accessToken);
        oauthAccessToken.setExpireIn(String.valueOf(this.envProperties.getOauthTokenExpire() * 60L));
        oauthAccessToken.setUserSid(oauthAuthCode.getUserSid());
        oauthAccessToken.setRefreshToken(refreshToken);
        RedisUtils.set((String)refreshTokenKey, (Object)authoredUser, (Duration)Duration.ofMinutes(this.envProperties.getTokenExpire()));
        return oauthAccessToken;
    }

    @Override
    public OauthAccessToken refreshAccessToken(OauthRefreshTokenRequest oauthRefreshTokenRequest) {
        String refreshToken = oauthRefreshTokenRequest.getRefreshToken();
        OauthApp oauthApp = this.oauthAppRepository.findById(oauthRefreshTokenRequest.getAppId());
        if (oauthApp == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{oauthRefreshTokenRequest.getAppId()});
        }
        if (!oauthRefreshTokenRequest.getSecret().equals(oauthApp.getSecret())) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_SECRET_ERROR, new Object[]{oauthRefreshTokenRequest.getSecret()});
        }
        if (!"refresh_token".equals(oauthRefreshTokenRequest.getGrantType())) {
            throw new BusinessException((ErrorHandler)I18nError.GRANT_TYPE_ERROR);
        }
        String refreshKey = this.uniqueKey(refreshToken, "iam:oauth:refresh:token:%s");
        if (!RedisUtils.hasKey((String)refreshKey)) {
            throw new BusinessException((ErrorHandler)I18nError.REFRESH_TOKEN_NOT_EXIST, new Object[]{refreshToken});
        }
        OauthAccessToken oauthAccessToken = new OauthAccessToken();
        IamAuthoredUser iamAuthoredUser = (IamAuthoredUser)RedisUtils.get((Object)refreshKey, IamAuthoredUser.class);
        if (iamAuthoredUser == null || StringUtils.isEmpty((Object)iamAuthoredUser.getToken())) {
            throw new BusinessException((ErrorHandler)I18nError.REFRESH_TOKEN_CACHE_NOT_EXIST, new Object[]{refreshToken});
        }
        if (!oauthRefreshTokenRequest.getAppId().equalsIgnoreCase(iamAuthoredUser.getAppId())) {
            throw new BusinessException((ErrorHandler)I18nError.REFRESH_TOKEN_CACHE_ERROR, new Object[]{oauthRefreshTokenRequest.getAppId(), iamAuthoredUser.getAppId()});
        }
        String accessToken = iamAuthoredUser.getToken();
        String accessTokenKey = this.uniqueKey(accessToken, "iam:oauth:access:token:%s");
        if (!RedisUtils.hasKey((String)accessTokenKey)) {
            accessToken = UUID.randomUUID().toString();
            iamAuthoredUser.setToken(accessToken);
            accessTokenKey = this.uniqueKey(accessToken, "iam:oauth:access:token:%s");
            RedisUtils.set((String)accessTokenKey, (Object)iamAuthoredUser, (Duration)Duration.ofMillis(this.envProperties.getOauthTokenExpire() * 60L * 1000L));
            RedisUtils.set((String)refreshKey, (Object)iamAuthoredUser);
        } else {
            RedisUtils.expire((String)accessTokenKey, (long)this.envProperties.getOauthTokenExpire(), (TimeUnit)TimeUnit.MINUTES);
        }
        oauthAccessToken.setAccessToken(accessToken);
        oauthAccessToken.setExpireIn(RedisUtils.getExpire((String)accessTokenKey).toString());
        oauthAccessToken.setUserSid(iamAuthoredUser.getSid());
        oauthAccessToken.setRefreshToken(refreshToken);
        return oauthAccessToken;
    }

    @Override
    public void syncOauthApp(List<OauthAppVO> oauthApps) {
        List<String> sysIds = oauthApps.stream().map(OauthAppVO::getSysId).collect(Collectors.toList());
        List<Integer> platforms = oauthApps.stream().map(OauthAppVO::getPlatform).collect(Collectors.toList());
        List<OauthApp> existedOauthApps = this.oauthMapper.getOauthApps(sysIds, platforms);
        ArrayList oauthAppList = new ArrayList();
        oauthApps.forEach(a -> {
            OauthApp existedApp = existedOauthApps.stream().filter(e -> a.getPlatform().equals(e.getPlatform()) && a.getSysId().equals(e.getSysId())).findFirst().orElse(null);
            if (null == existedApp) {
                OauthApp oauthApp = a.generateEntity();
                oauthApp.setSid(SnowFlake.getInstance().newId());
                EntityUtils.setCreateFields((BaseEntity)oauthApp);
                oauthAppList.add(oauthApp);
            } else {
                OauthApp oauthApp = existedApp;
                oauthApp.setId(a.getId());
                oauthApp.setSecret(a.getSecret());
                EntityUtils.setModifyFields((BaseEntity)oauthApp);
                oauthAppList.add(oauthApp);
            }
        });
        if (!oauthAppList.isEmpty()) {
            this.oauthAppRepository.saveAll(oauthAppList);
        }
    }

    private String uniqueKey(String code, String key) {
        return String.format(key, code);
    }
}

