/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.org.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.UserInOrg;
import com.digiwin.dap.middleware.iam.repository.OrgRepository;
import com.digiwin.dap.middleware.iam.repository.UserInOrgRepository;
import com.digiwin.dap.middleware.iam.service.org.EnableOrgService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgQueryService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnableOrgServiceImpl
implements EnableOrgService {
    @Autowired
    OrgCrudService orgCrudService;
    @Autowired
    UserInOrgRepository userInOrgRepository;
    @Autowired
    OrgRepository orgRepository;
    @Autowired
    OrgQueryService orgQueryService;
    @Autowired
    private AuthValidateService authValidateService;

    @Override
    public void disable(long orgSid) {
        Org org = (Org)this.orgCrudService.findBySid(orgSid);
        if (org == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NOT_EXIST, new Object[]{orgSid});
        }
        if (org.isDisabled()) {
            return;
        }
        if (UserUtils.getTenantSid() != org.getTenantSid() && !this.authValidateService.checkAccessPermission("Sys", AppAuthContextHolder.getContext().getRequestInfo().getMethod(), AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        List<Long> childrenOrgs = this.orgRepository.findEnableOrgSidsByParentSid(orgSid);
        if (childrenOrgs != null && childrenOrgs.size() > 0) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_CANNOT_DEACTIVATE1);
        }
        List<UserInOrg> userInOrgs = this.userInOrgRepository.findEnableUserInOrgByOrgSid(org.getSid());
        if (userInOrgs != null && userInOrgs.size() > 0) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_CANNOT_DEACTIVATE2);
        }
        this.orgCrudService.disable(orgSid);
    }

    @Override
    public void forceDisable(long orgSid) {
        Org org = (Org)this.orgCrudService.findBySid(orgSid);
        if (org == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NOT_EXIST, new Object[]{orgSid});
        }
        if (org.isDisabled()) {
            return;
        }
        if (UserUtils.getTenantSid() != org.getTenantSid() && !this.authValidateService.checkAccessPermission("Sys", AppAuthContextHolder.getContext().getRequestInfo().getMethod(), AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        List<Long> orgSids = this.orgQueryService.getChildrenOrgSids(orgSid);
        orgSids.add(orgSid);
        this.batchDisable(orgSids);
    }

    @Override
    public void batchDisable(List<Long> orgList) {
        if (orgList != null && orgList.size() > 0) {
            this.orgRepository.batchDisable(orgList);
            ArrayList<Long> userInOrgSidList = new ArrayList<Long>();
            for (Long orgSid : orgList) {
                List<Long> userSids = this.userInOrgRepository.findUserInOrgSidByOrgSid(orgSid);
                userInOrgSidList.addAll(userSids);
            }
            if (userInOrgSidList.size() > 0) {
                this.userInOrgRepository.batchDisable(userInOrgSidList);
            }
        }
    }

    @Override
    public void enable(long sid) {
        Org org = (Org)this.orgCrudService.findBySid(sid);
        if (org == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NOT_EXIST, new Object[]{sid});
        }
        if (!org.isDisabled()) {
            return;
        }
        if (UserUtils.getTenantSid() != org.getTenantSid() && !this.authValidateService.checkAccessPermission("Sys", AppAuthContextHolder.getContext().getRequestInfo().getMethod(), AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        this.orgCrudService.enable(sid);
    }
}

