/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.org.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.entity.OrgCatalog;
import com.digiwin.dap.middleware.iam.entity.OrgType;
import com.digiwin.dap.middleware.iam.repository.OrgRepository;
import com.digiwin.dap.middleware.iam.repository.OrgTypeRepository;
import com.digiwin.dap.middleware.iam.service.org.EnableOrgTypeService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnableOrgTypeServiceImpl
implements EnableOrgTypeService {
    @Autowired
    private OrgTypeCrudService orgTypeCrudService;
    @Autowired
    private OrgCatalogCrudService orgCatalogCrudService;
    @Autowired
    private OrgTypeRepository orgTypeRepository;
    @Autowired
    private OrgRepository orgRepository;

    @Override
    public void disable(Long tenantSid, long orgTypeSid) {
        OrgType orgType = this.orgTypeCrudService.findByTenantSidAndSid(tenantSid, orgTypeSid);
        if (orgType == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_TYPE_NOT_EXISTED, new Object[]{orgTypeSid});
        }
        if (orgType.isDisabled()) {
            return;
        }
        List<Long> sids = this.orgTypeRepository.findOrgTypeSidsByTenantSidAndParentSid(orgType.getTenantSid(), orgTypeSid);
        if (sids.size() > 0) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_TYPE_CANNOT_DEACTIVATE, new Object[]{orgTypeSid});
        }
        sids = this.orgRepository.findNotDisOrgSidsByOrgTypeSid(orgTypeSid);
        if (sids.size() > 0) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_TYPE_HAS_ORG, new Object[]{orgTypeSid});
        }
        this.orgTypeCrudService.disable(orgTypeSid, tenantSid);
    }

    @Override
    public void enable(Long tenantSid, long orgTypeSid) {
        if (orgTypeSid == 0L) {
            throw new IllegalArgumentException("orgTypeSid is null");
        }
        OrgType orgType = this.orgTypeCrudService.findByTenantSidAndSid(tenantSid, orgTypeSid);
        if (orgType == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_TYPE_NOT_EXISTED, new Object[]{orgTypeSid});
        }
        if (!orgType.isDisabled()) {
            return;
        }
        OrgCatalog orgCatalog = (OrgCatalog)this.orgCatalogCrudService.findBySid(orgType.getOrgCatalogSid());
        if (orgCatalog == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NO_CATALOG, new Object[]{orgType.getOrgCatalogSid()});
        }
        if (orgCatalog.isDisabled()) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_CATALOG_HAS_DISABLE);
        }
        OrgType newOrgType = this.orgTypeCrudService.findByTenantSidAndSid(tenantSid, orgType.getParentSid());
        if (newOrgType != null && newOrgType.isDisabled()) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_CATALOG_HAS_DISABLE);
        }
        this.orgTypeCrudService.enable(orgTypeSid, tenantSid);
    }
}

