/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.org.impl;

import cn.hutool.core.io.IoUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.entity.OrgAspect;
import com.digiwin.dap.middleware.iam.mapper.OrgMapper;
import com.digiwin.dap.middleware.iam.service.org.ExportOrgService;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.util.excelUtil.DWExcelBuilder;
import com.digiwin.dap.middleware.iam.util.excelUtil.DWExcelSheetSetting;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportOrgServiceImpl
implements ExportOrgService {
    @Autowired
    private OrgAspectCrudService orgAspectCrudService;
    @Autowired
    private OrgMapper orgMapper;

    @Override
    public byte[] getOrgFileByte(long aspectSid) {
        byte[] bytes;
        OrgAspect orgAspect = (OrgAspect)this.orgAspectCrudService.findBySid(aspectSid);
        if (orgAspect == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_ASPECT_NOT_EXISTED);
        }
        Workbook workbook = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            List<Map<String, Object>> mapList = this.orgMapper.findOrgForEcportByOrgAspectSid(orgAspect.getTenantSid(), aspectSid);
            DWExcelBuilder excelBuilder = new DWExcelBuilder();
            DWExcelSheetSetting sheetSetting = excelBuilder.addSheet("org");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ORG_ID.getMessage()).setDataMappingKey("orgId");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ORG_NAME.getMessage()).setDataMappingKey("orgName");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ORG_PARENT_ID.getMessage()).setDataMappingKey("orgParentId");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ORG_PARENT_NAME.getMessage()).setDataMappingKey("orgParentName");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ORG_TYPE_ID.getMessage()).setDataMappingKey("orgTypeId");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ORG_TYPE_NAME.getMessage()).setDataMappingKey("orgTypeName");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ORG_TYPE_PARENT_ID.getMessage()).setDataMappingKey("orgTypeParentId");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ORG_TYPE_PARENT_NAME.getMessage()).setDataMappingKey("orgTypeParentName");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ORG_ASPECT_ID.getMessage()).setDataMappingKey("orgAspectId");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ORG_ASPECT_NAME.getMessage()).setDataMappingKey("orgAspectName");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ORG_CATALOG_ID.getMessage()).setDataMappingKey("orgCatalogId");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ORG_CATALOG_NAME.getMessage()).setDataMappingKey("orgCatalogName");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ORG_URI.getMessage()).setDataMappingKey("uri");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ORG_URN.getMessage()).setDataMappingKey("urn");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ORG_TYPE_URI.getMessage()).setDataMappingKey("orgTypeUri");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ORG_TYPE_URN.getMessage()).setDataMappingKey("orgTypeUrn");
            sheetSetting.setDatas(mapList);
            workbook = excelBuilder.create();
            workbook.write((OutputStream)bos);
            bytes = bos.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
            }
            catch (Throwable throwable) {
                IoUtil.close(workbook);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)workbook);
        return bytes;
    }
}

