/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.org.impl;

import com.digiwin.dap.middleware.iam.domain.org.OrgCatalogCascadeVO;
import com.digiwin.dap.middleware.iam.entity.OrgAspect;
import com.digiwin.dap.middleware.iam.entity.OrgType;
import com.digiwin.dap.middleware.iam.mapper.OrgCatalogMapper;
import com.digiwin.dap.middleware.iam.repository.OrgAspectRepository;
import com.digiwin.dap.middleware.iam.repository.OrgTypeRepository;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogQueryService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgCatalogQueryServiceImpl
implements OrgCatalogQueryService {
    @Autowired
    private OrgCatalogMapper orgCatalogMapper;
    @Autowired
    private OrgAspectRepository orgAspectRepository;
    @Autowired
    private OrgTypeRepository orgTypeRepository;

    @Override
    public List<OrgCatalogCascadeVO> getOrgCatalogCascades(long tenantSid) {
        List<OrgCatalogCascadeVO> orgCatalogCascadeVOS = this.orgCatalogMapper.findOrgCatalogCascadesByTenantSid(tenantSid);
        if (orgCatalogCascadeVOS.size() > 0) {
            for (OrgCatalogCascadeVO orgCatalogCascadeVO : orgCatalogCascadeVOS) {
                List<OrgAspect> orgAspects = this.orgAspectRepository.findOrgAspectsByOrgCatalogSid(orgCatalogCascadeVO.getSid());
                orgCatalogCascadeVO.setOrgAspects(orgAspects);
                List<OrgType> orgTypes = this.orgTypeRepository.findOrgTypesByTenantSidAndOrgCatalogSid(tenantSid, orgCatalogCascadeVO.getSid());
                orgCatalogCascadeVO.setOrgTypes(orgTypes);
            }
        }
        return orgCatalogCascadeVOS;
    }
}

