/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.org.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.UnionKey;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.repository.OrgRepository;
import com.digiwin.dap.middleware.iam.repository.RoleRepository;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.support.clean.PolicyCascadeDeleteService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.service.impl.BaseEntityWithUnionKeyManagerService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgCrudServiceImpl
extends BaseEntityWithUnionKeyManagerService<Org>
implements OrgCrudService {
    @Autowired
    private OrgRepository orgRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private PolicyCascadeDeleteService policyCascadeDeleteService;
    @Autowired
    private ChangeLogService changeLogService;

    protected OrgRepository getRepository() {
        return this.orgRepository;
    }

    protected UnionKey createUnionKey() {
        return UnionKey.create().apply(Org.class).add("tenantSid").add("orgAspectSid").add("id").add("parentSid");
    }

    @Override
    public boolean existsByTenantSidAndId(long tenantSid, String id) {
        return this.orgRepository.existsByTenantSidAndId(tenantSid, id);
    }

    @Override
    public List<Org> findByTenantSidAndId(long sid, String id) {
        return this.orgRepository.findByTenantSidAndId(sid, id);
    }

    @Override
    public List<Long> getOrgSidsByUri(long tenantSid, String uri) {
        return this.orgRepository.findOrgSidsByTenantSidAndUri(tenantSid, uri);
    }

    @Override
    @Transactional
    public void deleteOrgBySid(long orgSid) {
        Org org = (Org)this.findBySid(orgSid);
        if (org == null) {
            return;
        }
        if (UserUtils.getTenantSid() != org.getTenantSid()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        this.deleteById(orgSid);
        this.changeLogService.createChangeLog(ChangeTypeEnum.ORG_DEL.getName(), (Object)org, ChangeTypeEnum.ORG_DEL.getPrimaryKey(), String.valueOf(org.getSid()));
        List<Role> roles = this.roleRepository.findByTenantSidAndOrgSid(org.getTenantSid(), orgSid);
        roles.forEach(p -> {
            p.setOrgSid(0L);
            p.setUri("");
            p.setUrn("");
        });
        this.roleRepository.saveAll(roles);
        this.policyCascadeDeleteService.deleteOrg(org.getTenantSid(), orgSid);
    }
}

