/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.org.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.org.OrgPath;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.OrgAspect;
import com.digiwin.dap.middleware.iam.entity.OrgCatalog;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgPathService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgPathServiceImpl
implements OrgPathService {
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private OrgAspectCrudService orgAspectCrudService;
    @Autowired
    private OrgCatalogCrudService orgCatalogCrudService;

    @Override
    public OrgPath getOrgPath(long orgCatalogSid, long orgAspectSid, long parentOrgSid, String currentOrgId, String currentOrgName) {
        if (parentOrgSid > 0L) {
            OrgPath orgPath = this.getOrgPath(parentOrgSid);
            orgPath.setOrgUri(orgPath.getOrgUri() + ":" + currentOrgId);
            orgPath.setOrgUrn(orgPath.getOrgUrn() + ":" + currentOrgName);
            return orgPath;
        }
        return this.getOrgPath(orgCatalogSid, orgAspectSid, currentOrgId, currentOrgName);
    }

    @Override
    public OrgPath getOrgPath(long orgSid) {
        OrgPath orgPath = new OrgPath();
        Org org = (Org)this.orgCrudService.findBySid(orgSid);
        if (org == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NOT_EXIST, new Object[]{orgSid});
        }
        OrgAspect orgAspect = (OrgAspect)this.orgAspectCrudService.findBySid(org.getOrgAspectSid());
        if (orgAspect == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_ASPECT_NOT_EXISTED, new Object[]{org.getOrgAspectSid()});
        }
        OrgCatalog orgCatalog = (OrgCatalog)this.orgCatalogCrudService.findBySid(orgAspect.getOrgCatalogSid());
        if (orgCatalog == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NO_CATALOG, new Object[]{org.getSid()});
        }
        StringBuffer urnBuffer = new StringBuffer();
        urnBuffer.append(org.getName());
        StringBuffer uriBuffer = new StringBuffer();
        uriBuffer.append(org.getId());
        if (org.getParentSid() != 0L) {
            this.buildParentOrg(org.getParentSid(), urnBuffer, uriBuffer);
        }
        uriBuffer.insert(0, "drn:iam:org:" + orgCatalog.getId() + ":" + orgAspect.getId() + ":");
        urnBuffer.insert(0, orgCatalog.getName() + ":" + orgAspect.getName() + ":");
        orgPath.setOrgUrn(urnBuffer.toString());
        orgPath.setOrgUri(uriBuffer.toString());
        return orgPath;
    }

    @Override
    public OrgPath getOrgPath(long orgCatalogSid, long orgAspectSid, String currentOrgId, String currentOrgName) {
        OrgPath orgPath = new OrgPath();
        OrgCatalog orgCatalog = (OrgCatalog)this.orgCatalogCrudService.findBySid(orgCatalogSid);
        if (orgCatalog == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_CATALOG_NOT_EXISTED, new Object[]{orgCatalogSid});
        }
        OrgAspect orgAspect = (OrgAspect)this.orgAspectCrudService.findBySid(orgAspectSid);
        if (orgAspect == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_ASPECT_NOT_EXISTED, new Object[]{orgAspectSid});
        }
        orgPath.setOrgUri("drn:iam:org:" + orgCatalog.getId() + ":" + orgAspect.getId() + ":" + currentOrgId);
        orgPath.setOrgUrn(orgCatalog.getName() + ":" + orgAspect.getName() + ":" + currentOrgName);
        return orgPath;
    }

    private void buildParentOrg(long sid, StringBuffer urnBuffer, StringBuffer uriBuffer) {
        Org org;
        if (sid > 0L && (org = (Org)this.orgCrudService.findBySid(sid)) != null) {
            urnBuffer.insert(0, org.getName() + ":");
            uriBuffer.insert(0, org.getId() + ":");
            long parentSid = org.getParentSid();
            this.buildParentOrg(parentSid, urnBuffer, uriBuffer);
        }
    }
}

