/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.org.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.OperateException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.org.OrgAncestor;
import com.digiwin.dap.middleware.iam.domain.org.OrgBean;
import com.digiwin.dap.middleware.iam.domain.org.OrgCascadeResultVO;
import com.digiwin.dap.middleware.iam.domain.org.OrgQueryParameter;
import com.digiwin.dap.middleware.iam.domain.org.OrgResultVO;
import com.digiwin.dap.middleware.iam.domain.org.OrgRoleTreeNode;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserOrgPageVO;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.OrgAspect;
import com.digiwin.dap.middleware.iam.entity.OrgCatalog;
import com.digiwin.dap.middleware.iam.entity.OrgType;
import com.digiwin.dap.middleware.iam.mapper.OrgMapper;
import com.digiwin.dap.middleware.iam.mapper.RoleMapper;
import com.digiwin.dap.middleware.iam.repository.OrgRepository;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgQueryService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.github.pagehelper.PageSerializable;
import com.github.pagehelper.page.PageMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class OrgQueryServiceImpl
implements OrgQueryService {
    @Autowired
    private OrgRepository orgRepository;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private OrgAspectCrudService orgAspectCrudService;
    @Autowired
    private OrgTypeCrudService orgTypeCrudService;
    @Autowired
    private OrgCatalogCrudService orgCatalogCrudService;
    @Autowired
    private OrgMapper orgMapper;
    @Autowired
    private RoleMapper roleMapper;

    @Override
    public List<Long> getChildrenOrgSids(Long sid) {
        if (sid == 0L) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> childrenSids = new ArrayList<Long>();
        this.queryChildrenOrgSids(sid, childrenSids);
        return childrenSids;
    }

    @Override
    public List<Long> getParentOrgSids(Long sid) {
        ArrayList<Long> orgSids = new ArrayList<Long>();
        Org org = (Org)this.orgCrudService.findBySid(sid);
        if (org == null) {
            return orgSids;
        }
        this.queryParentOrgSids(org.getParentSid(), orgSids);
        return orgSids;
    }

    private void queryParentOrgSids(long sid, List<Long> orgSids) {
        Org org = (Org)this.orgCrudService.findBySid(sid);
        if (org != null) {
            orgSids.add(org.getSid());
            long parentSid = org.getParentSid();
            this.queryParentOrgSids(parentSid, orgSids);
        }
    }

    private void queryChildrenOrgSids(long sid, List<Long> childrenOrgSids) {
        List<Long> childrenSids = this.orgRepository.findOrgSidsByParentSid(sid);
        if (childrenSids != null && childrenSids.size() > 0) {
            childrenOrgSids.addAll(childrenSids);
            for (Long orgSid : childrenSids) {
                this.queryChildrenOrgSids(orgSid, childrenOrgSids);
            }
        }
    }

    @Override
    public OrgResultVO getOrg(long sid) {
        if (sid == 0L) {
            throw new IllegalArgumentException("sid is 0");
        }
        OrgResultVO orgResultVO = this.orgMapper.findByOrgSid(sid);
        if (orgResultVO == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NOT_EXIST, new Object[]{sid});
        }
        OrgType orgType = this.orgTypeCrudService.findByTenantSidAndSid(orgResultVO.getTenantSid(), orgResultVO.getTypeSid());
        orgResultVO.setTypeUri(orgType.getUri());
        orgResultVO.setTypeName(orgType.getName());
        return orgResultVO;
    }

    @Override
    public List<OrgResultVO> listOrg(Long tenantSid, List<Long> sids) {
        if (CollectionUtils.isEmpty(sids)) {
            return Collections.emptyList();
        }
        return this.orgMapper.findByOrgSids(tenantSid, sids);
    }

    @Override
    public Long getOrgSidByUri(long tenantSid, String uri) {
        String[] orgIds = this.getOrgIds(uri);
        String orgCatalogId = orgIds[0];
        String orgAspectId = orgIds[1];
        String orgId = orgIds[2];
        OrgCatalog orgCatalog = (OrgCatalog)this.orgCatalogCrudService.findByTenantSidAndId(tenantSid, orgCatalogId);
        if (orgCatalog == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NO_CATALOG, new Object[]{orgCatalogId});
        }
        OrgAspect orgAspect = (OrgAspect)this.orgAspectCrudService.findByUnionKey(new Object[]{tenantSid, orgCatalog.getSid(), orgAspectId});
        if (orgAspect == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_ASPECT_NOT_EXISTED, new Object[]{orgAspectId});
        }
        Org parentOrg = (Org)this.orgCrudService.findByUnionKey(new Object[]{tenantSid, orgAspect.getSid(), orgId, 0});
        if (parentOrg == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NOT_EXIST, new Object[]{orgId});
        }
        long parentSid = parentOrg.getSid();
        for (int i = 3; i < orgIds.length; ++i) {
            Org childrenOrg = (Org)this.orgCrudService.findByUnionKey(new Object[]{tenantSid, orgAspect.getSid(), orgIds[i], parentSid});
            if (childrenOrg == null) {
                throw new BusinessException((ErrorHandler)I18nError.ORG_NOT_EXIST, new Object[]{orgIds[i]});
            }
            parentSid = childrenOrg.getSid();
        }
        return parentSid;
    }

    private String[] getOrgIds(String uri) {
        if (StringUtils.isEmpty((Object)uri)) {
            throw new IllegalArgumentException("uri is null");
        }
        if (!uri.startsWith("drn:iam:org:")) {
            throw new IllegalArgumentException("\u6b64uri\u4e0d\u7b26\u5408\u89c4\u8303");
        }
        int prefixLength = "drn:iam:org:".length();
        String[] ids = (uri = uri.substring(prefixLength, uri.length())).split(":");
        if (ids.length < 2) {
            throw new IllegalArgumentException("\u6b64uri\u4e0d\u7b26\u5408\u89c4\u8303");
        }
        return ids;
    }

    @Override
    public OrgAncestor getOrgAncestor(long orgSid) {
        OrgAspect orgAspect;
        if (orgSid == 0L) {
            throw new IllegalArgumentException("orgSid is 0");
        }
        OrgAncestor orgAncestor = new OrgAncestor();
        OrgResultVO orgResultVO = this.getOrg(orgSid);
        if (orgResultVO == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NOT_EXIST, new Object[]{orgSid});
        }
        orgAncestor.setTarget(orgResultVO);
        List<Long> parentOrgSids = this.getParentOrgSids(orgSid);
        if (parentOrgSids != null && parentOrgSids.size() > 0) {
            ArrayList<OrgResultVO> parentOrgResultVOS = new ArrayList<OrgResultVO>();
            for (Long parentOrgSid : parentOrgSids) {
                OrgResultVO parentOrgResultVO = this.getOrg(parentOrgSid);
                if (parentOrgResultVO == null) {
                    throw new BusinessException((ErrorHandler)I18nError.ORG_NOT_EXIST, new Object[]{parentOrgSid});
                }
                parentOrgResultVOS.add(parentOrgResultVO);
            }
            orgAncestor.setAncestor(parentOrgResultVOS);
        }
        if ((orgAspect = (OrgAspect)this.orgAspectCrudService.findBySid(orgResultVO.getOrgAspectSid())) == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_ASPECT_NOT_EXISTED, new Object[]{orgResultVO.getOrgAspectSid()});
        }
        orgAncestor.setOrgAspect(orgAspect);
        OrgCatalog orgCatalog = (OrgCatalog)this.orgCatalogCrudService.findBySid(orgAspect.getOrgCatalogSid());
        if (orgCatalog == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NO_CATALOG, new Object[]{orgAspect.getOrgCatalogSid()});
        }
        orgAncestor.setOrgCatalog(orgCatalog);
        return orgAncestor;
    }

    @Override
    public List<OrgResultVO> getAspect(Long tenantSid, long orgAspectSid) {
        List<OrgResultVO> orgResultVOS = this.orgMapper.findByOrgAspectSid(tenantSid, orgAspectSid);
        return orgResultVOS;
    }

    @Override
    public List<OrgResultVO> getDisOrg(long tenantSid) {
        if (tenantSid == 0L) {
            throw new IllegalArgumentException("tenantSid is 0");
        }
        List<Long> disOrgSids = this.orgRepository.findDisOrgSidsByTenantSid(tenantSid);
        ArrayList<OrgResultVO> orgResultVOS = new ArrayList<OrgResultVO>();
        if (disOrgSids.size() > 0) {
            for (Long disOrgSid : disOrgSids) {
                OrgResultVO orgResultVO = this.getOrg(disOrgSid);
                orgResultVOS.add(orgResultVO);
            }
        }
        return orgResultVOS;
    }

    @Override
    public OrgCascadeResultVO getOrgCascade(OrgBean orgBean, long tenantSid) {
        if (tenantSid == 0L) {
            throw new IllegalArgumentException("tenantSid is 0");
        }
        if (orgBean.getSid() == 0L) {
            throw new IllegalArgumentException("sid is 0");
        }
        OrgCascadeResultVO orgCascadeResultVO = new OrgCascadeResultVO();
        OrgResultVO orgResultVO = this.getOrg(orgBean.getSid());
        String uri = orgResultVO.getUri();
        String[] orgIds = this.getOrgIds(uri);
        orgCascadeResultVO.setTarget(orgResultVO);
        OrgQueryParameter orgQueryParameter = orgBean.getQueryParameter();
        if (orgQueryParameter != null) {
            String orgCatalogId = orgIds[0];
            OrgCatalog orgCatalog = (OrgCatalog)this.orgCatalogCrudService.findByTenantSidAndId(tenantSid, orgCatalogId);
            if (orgCatalog == null) {
                throw new BusinessException((ErrorHandler)I18nError.ORG_NO_CATALOG, new Object[]{orgCatalogId});
            }
            String orgTypeId = orgQueryParameter.getOrgType();
            boolean isTypeCascade = orgQueryParameter.getIsTypeCascade();
            List<Long> orgChildrenSids = this.getChildrenOrgSids(orgResultVO.getSid());
            ArrayList<OrgResultVO> orgResultVOS = new ArrayList<OrgResultVO>();
            if (orgChildrenSids != null && orgChildrenSids.size() > 0) {
                long orgTypeSid = 0L;
                if (orgTypeId != null && (orgTypeSid = this.orgTypeCrudService.getSidByUnionKey(tenantSid, orgCatalog.getSid(), orgQueryParameter.getOrgType())) == 0L) {
                    throw new BusinessException((ErrorHandler)I18nError.ORG_TYPE_NOT_EXISTED);
                }
                for (long orgChildrenSid : orgChildrenSids) {
                    OrgResultVO orgChildren = this.getOrg(orgChildrenSid);
                    if (isTypeCascade) {
                        orgResultVOS.add(orgChildren);
                        continue;
                    }
                    if (orgChildren.getTypeSid() != orgTypeSid) continue;
                    orgResultVOS.add(orgChildren);
                }
                orgCascadeResultVO.setCascade(orgResultVOS);
            }
        } else {
            List<Long> orgChildrenSids = this.getChildrenOrgSids(orgResultVO.getSid());
            ArrayList<OrgResultVO> orgResultVOS = new ArrayList<OrgResultVO>();
            if (orgChildrenSids != null && orgChildrenSids.size() > 0) {
                for (long orgChildrenSid : orgChildrenSids) {
                    OrgResultVO orgChildren = this.getOrg(orgChildrenSid);
                    orgResultVOS.add(orgChildren);
                }
                orgCascadeResultVO.setCascade(orgResultVOS);
            }
        }
        return orgCascadeResultVO;
    }

    @Override
    public Map<String, List<OrgRoleTreeNode>> findOrgRoleTreeByTenantSid(long tenantSid) {
        List<OrgRoleTreeNode> roleNodes = this.roleMapper.findRoleNodeByTenantSid(tenantSid);
        List<OrgAspect> orgAspectList = this.orgAspectCrudService.findByTenantSid(tenantSid);
        HashMap<String, List<OrgRoleTreeNode>> orgRoleTrees = new HashMap<String, List<OrgRoleTreeNode>>(orgAspectList.size());
        orgAspectList.forEach(orgAspect -> {
            List<OrgRoleTreeNode> orgNodes = this.orgMapper.findOrgNodeByAspectSid(orgAspect.getSid());
            orgNodes.addAll(roleNodes);
            ArrayList orgRoleTree = new ArrayList();
            orgNodes.forEach(data -> {
                if (data.getParentSid() == 0L) {
                    orgRoleTree.add(this.findChild((OrgRoleTreeNode)data, orgNodes));
                }
            });
            orgRoleTrees.put(orgAspect.getId(), orgRoleTree);
        });
        return orgRoleTrees;
    }

    private OrgRoleTreeNode findChild(OrgRoleTreeNode orgRoleTreeNode, List<OrgRoleTreeNode> orgRoleTree) {
        orgRoleTree.forEach(data -> {
            if (data.getParentSid() == orgRoleTreeNode.getKey()) {
                if (orgRoleTreeNode.getChildren() == null) {
                    orgRoleTreeNode.setChildren(new ArrayList<OrgRoleTreeNode>());
                }
                orgRoleTreeNode.getChildren().add(this.findChild((OrgRoleTreeNode)data, orgRoleTree));
            }
        });
        return orgRoleTreeNode;
    }

    @Override
    public PageSerializable<QueryUserInOrgResultVO> getUserNotInOrg(QueryUserOrgPageVO body) {
        PageMethod.startPage((int)body.getPageNum(), (int)body.getPageSize());
        List<QueryUserInOrgResultVO> result = this.orgMapper.queryUserNotInOrg(body);
        return new PageSerializable(result);
    }

    @Override
    public long getCatalogSid(String orgCatalogId, long tenantSid) {
        long sid = 0L;
        if (orgCatalogId != null) {
            if (!StringUtil.checkId(orgCatalogId)) {
                throw new OperateException("catalogId\u586b\u5199\u9519\u8bef");
            }
            OrgCatalog catalog = (OrgCatalog)this.orgCatalogCrudService.findByTenantSidAndId(tenantSid, orgCatalogId);
            if (catalog != null) {
                sid = catalog.getSid();
            } else {
                throw new OperateException("\u6ca1\u6709" + orgCatalogId + "\u7ec4\u7ec7\u5206\u7c7b");
            }
        }
        return sid;
    }

    @Override
    public long getAspectSid(long tenantSid, long orgCatalogSid, String orgAspectId) {
        long sid = 0L;
        if (orgAspectId != null) {
            if (!StringUtil.checkId(orgAspectId)) {
                throw new OperateException("catalogId\u586b\u5199\u9519\u8bef");
            }
            OrgAspect orgAspect = (OrgAspect)this.orgAspectCrudService.findByUnionKey(new Object[]{tenantSid, orgCatalogSid, orgAspectId});
            if (orgAspect != null) {
                sid = orgAspect.getSid();
            } else {
                throw new OperateException("\u6ca1\u6709" + orgAspectId + "\u7ec4\u7ec7\u6811");
            }
        }
        return sid;
    }
}

