/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.org.impl;

import com.digiwin.dap.middleware.iam.entity.OrgType;
import com.digiwin.dap.middleware.iam.repository.OrgTypeRepository;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityWithPartitionManagerService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgTypeCrudServiceImpl
extends BaseEntityWithPartitionManagerService<OrgType>
implements OrgTypeCrudService {
    @Autowired
    private OrgTypeRepository orgTypeRepository;

    protected OrgTypeRepository getRepository() {
        return this.orgTypeRepository;
    }

    @Override
    public OrgType findByTenantSidAndSid(Long tenantSid, long sid) {
        return this.orgTypeRepository.findByTenantSidAndSid(tenantSid, sid);
    }

    @Override
    public OrgType findByUnionKey(long tenantSid, long orgCatalogSid, String id) {
        return this.orgTypeRepository.findByTenantSidAndOrgCatalogSidAndId(tenantSid, orgCatalogSid, id);
    }

    @Override
    public long getSidByUnionKey(long tenantSid, long orgCatalogSid, String id) {
        OrgType orgType = this.orgTypeRepository.findByTenantSidAndOrgCatalogSidAndId(tenantSid, orgCatalogSid, id);
        return orgType == null ? 0L : orgType.getSid();
    }

    @Override
    public List<Long> getChildrenOrgTypeSids(Long tenantSid, long sid) {
        if (sid == 0L) {
            throw new IllegalArgumentException("sid is 0");
        }
        ArrayList<Long> childrenSids = new ArrayList<Long>();
        this.queryChildrenOrgTypeSids(tenantSid, sid, childrenSids);
        return childrenSids;
    }

    private void queryChildrenOrgTypeSids(Long tenantSid, long sid, List<Long> childrenOrgTypeSids) {
        List<Long> childrenSids;
        if (sid != 0L && (childrenSids = this.orgTypeRepository.findOrgTypeSidsByTenantSidAndParentSid(tenantSid, sid)) != null && childrenSids.size() > 0) {
            childrenOrgTypeSids.addAll(childrenSids);
            for (Long orgTypeSid : childrenSids) {
                this.queryChildrenOrgTypeSids(tenantSid, orgTypeSid, childrenOrgTypeSids);
            }
        }
    }
}

