/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.org.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.org.OrgTypePath;
import com.digiwin.dap.middleware.iam.entity.OrgCatalog;
import com.digiwin.dap.middleware.iam.entity.OrgType;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypePathService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgTypePathServiceImpl
implements OrgTypePathService {
    @Autowired
    private OrgTypeCrudService orgTypeCrudService;
    @Autowired
    private OrgCatalogCrudService orgCatalogCrudService;

    @Override
    public OrgTypePath getOrgTypePath(Long tenantSid, long sid) {
        OrgTypePath orgTypePath = new OrgTypePath();
        OrgType orgType = this.orgTypeCrudService.findByTenantSidAndSid(tenantSid, sid);
        if (orgType == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_TYPE_NOT_EXISTED, new Object[]{sid});
        }
        OrgCatalog orgCatalog = (OrgCatalog)this.orgCatalogCrudService.findBySid(orgType.getOrgCatalogSid());
        if (orgCatalog == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NO_CATALOG, new Object[]{orgType.getOrgCatalogSid()});
        }
        StringBuffer uriBuffer = new StringBuffer();
        uriBuffer.append(orgType.getId());
        StringBuffer urnBuffer = new StringBuffer();
        urnBuffer.append(orgType.getName());
        if (orgType.getParentSid() != 0L) {
            this.buildParentOrgType(tenantSid, orgType.getParentSid(), uriBuffer, urnBuffer);
        }
        uriBuffer.insert(0, "drn:iam:orgtype:" + orgCatalog.getId() + ":");
        urnBuffer.insert(0, orgCatalog.getName() + ":");
        orgTypePath.setOrgTypeUri(uriBuffer.toString());
        orgTypePath.setOrgTypeUrn(urnBuffer.toString());
        return orgTypePath;
    }

    @Override
    public OrgTypePath getOrgTypePath(Long tenantSid, long parentSid, long orgCatalogSid, String currentId, String currentName) {
        if (parentSid == 0L) {
            OrgCatalog orgCatalog = (OrgCatalog)this.orgCatalogCrudService.findBySid(orgCatalogSid);
            if (orgCatalog == null) {
                throw new BusinessException((ErrorHandler)I18nError.ORG_NO_CATALOG, new Object[]{orgCatalogSid});
            }
            String uri = "drn:iam:orgtype:" + orgCatalog.getId() + ":" + currentId;
            OrgTypePath orgTypePath = new OrgTypePath();
            orgTypePath.setOrgTypeUri(uri);
            orgTypePath.setOrgTypeUrn(orgCatalog.getName() + ":" + currentName);
            return orgTypePath;
        }
        OrgTypePath orgTypePath = this.getOrgTypePath(tenantSid, parentSid);
        orgTypePath.setOrgTypeUri(orgTypePath.getOrgTypeUri() + ":" + currentId);
        orgTypePath.setOrgTypeUrn(orgTypePath.getOrgTypeUrn() + ":" + currentName);
        return orgTypePath;
    }

    private void buildParentOrgType(Long tenantSid, long sid, StringBuffer uriBuffer, StringBuffer urnBuffer) {
        OrgType orgType;
        if (sid != 0L && (orgType = this.orgTypeCrudService.findByTenantSidAndSid(tenantSid, sid)) != null) {
            uriBuffer.insert(0, orgType.getId() + ":");
            urnBuffer.insert(0, orgType.getName() + ":");
            long parentSid = orgType.getParentSid();
            this.buildParentOrgType(tenantSid, parentSid, uriBuffer, urnBuffer);
        }
    }
}

