/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.org.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.org.OrgTypeCascade;
import com.digiwin.dap.middleware.iam.domain.org.OrgTypeResultVO;
import com.digiwin.dap.middleware.iam.entity.OrgCatalog;
import com.digiwin.dap.middleware.iam.mapper.OrgTypeMapper;
import com.digiwin.dap.middleware.iam.repository.OrgTypeRepository;
import com.digiwin.dap.middleware.iam.repository.SysRepository;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgTypeQueryServiceImpl
implements OrgTypeQueryService {
    @Autowired
    SysRepository sysRepository;
    @Autowired
    UserCrudService userCrudService;
    @Autowired
    OrgCatalogCrudService orgCatalogCrudService;
    @Autowired
    OrgTypeCrudService orgTypeCrudService;
    @Autowired
    OrgTypeRepository orgTypeRepository;
    @Autowired
    OrgTypeMapper orgTypeMapper;

    @Override
    public List<OrgTypeResultVO> findOrgTypeInOrgCatalog(long orgCatalogSid) {
        OrgCatalog orgCatalog = (OrgCatalog)this.orgCatalogCrudService.findBySid(orgCatalogSid);
        if (orgCatalog == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NO_CATALOG, new Object[]{orgCatalogSid});
        }
        Long tenantSid = orgCatalog.getTenantSid();
        List<Long> orgTypeSids = this.orgTypeRepository.findOrgTypeSidsByTenantSidAndOrgcatalogSid(tenantSid, orgCatalogSid);
        ArrayList<OrgTypeResultVO> orgTypeResultVOS = new ArrayList<OrgTypeResultVO>();
        if (orgTypeSids.size() > 0) {
            this.bulidOrgType(tenantSid, orgTypeSids, orgTypeResultVOS);
        }
        return orgTypeResultVOS;
    }

    @Override
    public OrgTypeCascade getCascadeType(long catalogSid, long orgTypeSid) {
        OrgTypeCascade orgTypeCascade = new OrgTypeCascade();
        OrgCatalog orgCatalog = (OrgCatalog)this.orgCatalogCrudService.findBySid(catalogSid);
        if (orgCatalog == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NO_CATALOG, new Object[]{catalogSid});
        }
        Long tenantSid = orgCatalog.getTenantSid();
        OrgTypeResultVO targetOrgTypeResultVO = this.orgTypeMapper.findByTenantSidAndSid(tenantSid, orgTypeSid);
        if (targetOrgTypeResultVO == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_TYPE_NOT_EXISTED, new Object[]{orgTypeSid});
        }
        orgTypeCascade.setTarget(targetOrgTypeResultVO);
        List<Long> childrenOrgTypeSids = this.orgTypeCrudService.getChildrenOrgTypeSids(tenantSid, orgTypeSid);
        if (childrenOrgTypeSids != null && childrenOrgTypeSids.size() > 0) {
            ArrayList<OrgTypeResultVO> childrenOrgTypeResultVOS = new ArrayList<OrgTypeResultVO>();
            this.bulidOrgType(tenantSid, childrenOrgTypeSids, childrenOrgTypeResultVOS);
            orgTypeCascade.setChildren(childrenOrgTypeResultVOS);
        }
        return orgTypeCascade;
    }

    private void bulidOrgType(Long tenantSid, List<Long> orgTypeSids, List<OrgTypeResultVO> orgTypeResultVOS) {
        for (Long orgTypeSid : orgTypeSids) {
            OrgTypeResultVO orgTypeResultVO = this.orgTypeMapper.findByTenantSidAndSid(tenantSid, orgTypeSid);
            if (orgTypeResultVO == null) {
                throw new BusinessException((ErrorHandler)I18nError.ORG_TYPE_NOT_EXISTED, new Object[]{orgTypeSid});
            }
            orgTypeResultVOS.add(orgTypeResultVO);
        }
    }
}

