/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.permission.impl;

import com.digiwin.dap.middleware.iam.constant.enums.ConditionValueEnum;
import com.digiwin.dap.middleware.iam.domain.permission.CalcUser;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionUserOrg;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionUserRole;
import com.digiwin.dap.middleware.iam.domain.permission.v2.MenuEffect;
import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetAction;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetChain;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetCondition;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.mapper.PolicyMapper;
import com.digiwin.dap.middleware.iam.service.permission.AuthCalcService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAuthCalcService
implements AuthCalcService {
    @Autowired
    private PolicyMapper policyMapper;
    @Autowired
    private RoleCrudService roleCrudService;

    @Override
    public Map<Long, TargetAction> getTargetAction(long tenantSid, long sysSid, long targetSid, TargetType targetType) {
        List<Long> actionSids = this.getSysActions(tenantSid, sysSid);
        List<TargetAction> targetActions = this.doFunctionMerge(tenantSid, sysSid, targetSid, targetType, actionSids, null, null);
        return targetActions.stream().collect(Collectors.toMap(TargetAction::getActionSid, a -> a, (k1, k2) -> k1));
    }

    @Override
    public Map<Long, TargetAction> getUserAction(CalcUser calcUser, List<Long> actionSids, List<PermissionUserRole> roleInfos, List<PermissionUserOrg> orgInfos) {
        List<TargetAction> targetActions = this.doFunctionMerge(calcUser.getTenantSid(), calcUser.getAppSid(), calcUser.getUserSid(), TargetType.user, actionSids, roleInfos, orgInfos);
        return targetActions.stream().collect(Collectors.toMap(TargetAction::getActionSid, a -> a, (k1, k2) -> k1));
    }

    private List<TargetAction> doFunctionMerge(long tenantSid, long sysSid, long targetSid, TargetType targetType, List<Long> actionSids, List<PermissionUserRole> roleInfos, List<PermissionUserOrg> orgInfos) {
        List<TargetAction> policyActions = this.findPolicyAction(tenantSid, sysSid, targetSid, targetType, roleInfos, orgInfos);
        List<TargetAction> allowPolicyActions = this.mergePolicyAction(actionSids, policyActions, tenantSid, targetSid, targetType);
        return this.mergePolicyActionCondition(sysSid, allowPolicyActions);
    }

    protected List<Long> getSysActions(long tenantSid, long sysSid) {
        List<Long> moduleSids = this.policyMapper.getModules(sysSid);
        List<Long> actionSids = this.policyMapper.getActions(tenantSid, sysSid);
        actionSids.addAll(moduleSids);
        return actionSids;
    }

    protected abstract List<TargetAction> findPolicyAction(long var1, long var3, long var5, TargetType var7, List<PermissionUserRole> var8, List<PermissionUserOrg> var9);

    protected List<TargetAction> mergePolicyAction(List<Long> actions, List<TargetAction> policyActions, long tenantSid, long targetSid, TargetType targetType) {
        List<TargetChain> targetChains = new ArrayList<TargetChain>();
        if (TargetType.user == targetType) {
            targetChains.add(new TargetChain(targetSid, ""));
            this.singleChain(actions, targetChains, policyActions);
            this.parallelChain(tenantSid, targetSid, actions, policyActions);
        } else if (TargetType.role == targetType) {
            Role role = this.roleCrudService.findByTenantSidAndSid(tenantSid, targetSid);
            if (null != role) {
                if (role.getOrgSid() > 0L) {
                    targetChains = this.policyMapper.getOrgChains(role.getOrgSid(), tenantSid);
                    targetChains.add(new TargetChain(role.getSid(), role.getUri()));
                    this.singleChain(actions, targetChains, policyActions);
                } else {
                    targetChains.add(new TargetChain(role.getSid(), ""));
                    this.singleChain(actions, targetChains, policyActions);
                }
            }
        } else if (TargetType.org == targetType) {
            targetChains = this.policyMapper.getOrgChains(targetSid, tenantSid);
            this.singleChain(actions, targetChains, policyActions);
        }
        return policyActions.stream().filter(o -> o.getTick() == 1).collect(Collectors.toList());
    }

    protected List<TargetAction> mergePolicyActionCondition(long sysSid, List<TargetAction> policyActions) {
        Map<Long, List<TargetAction>> targetActionMap = policyActions.stream().collect(Collectors.groupingBy(TargetAction::getActionSid));
        ArrayList<TargetAction> targetActions = new ArrayList<TargetAction>();
        for (Map.Entry<Long, List<TargetAction>> entry : targetActionMap.entrySet()) {
            if (entry.getValue().size() == 1) {
                targetActions.add(entry.getValue().get(0));
                continue;
            }
            List validActions = entry.getValue().stream().filter(o -> !o.getConditions().isEmpty()).collect(Collectors.toList());
            if (validActions.isEmpty()) {
                targetActions.add(entry.getValue().get(0));
                continue;
            }
            if (validActions.size() == 1) {
                targetActions.add((TargetAction)validActions.get(0));
                continue;
            }
            Map actionConditionMap = validActions.stream().map(TargetAction::getConditions).flatMap(Collection::stream).collect(Collectors.toMap(TargetCondition::getKey, Function.identity(), (c1, c2) -> ConditionValueEnum.max(c1.getValue(), c2.getValue()) ? c1 : c2));
            TargetAction oldAction = (TargetAction)validActions.get(0);
            oldAction.setConditions(new ArrayList<TargetCondition>(actionConditionMap.values()));
            targetActions.add(oldAction);
        }
        return targetActions;
    }

    private void parallelChain(long tenantSid, long userSid, List<Long> actions, List<TargetAction> policyActions) {
        List<TargetChain> roles = this.policyMapper.getUserRole(tenantSid, userSid);
        roles.forEach(o -> {
            if (o.getOrgSid() > 0L) {
                List<TargetChain> targetChains = this.policyMapper.getOrgChains(o.getOrgSid(), tenantSid);
                targetChains.add(new TargetChain(o.getSid(), o.getUri()));
                this.singleChain(new ArrayList<Long>(actions), targetChains, policyActions);
            } else {
                ArrayList<TargetChain> targetChains = new ArrayList<TargetChain>();
                targetChains.add(new TargetChain(o.getSid(), ""));
                this.singleChain(new ArrayList<Long>(actions), targetChains, policyActions);
                o.setUri(null);
            }
        });
        List<TargetChain> orgs = this.policyMapper.getUserOrg(tenantSid, userSid);
        roles.removeIf(o -> null == o.getUri());
        roles.forEach(role -> orgs.removeIf(o -> role.getUri().contains(o.getUri())));
        ArrayList validUris = new ArrayList();
        orgs.forEach(o -> {
            validUris.removeIf(r -> o.getUri().contains((CharSequence)r));
            validUris.add(o.getUri());
        });
        orgs.removeIf(o -> !validUris.contains(o.getUri()));
        orgs.forEach(o -> {
            List<TargetChain> targetChains = this.policyMapper.getOrgChains(o.getSid(), tenantSid);
            this.singleChain(new ArrayList<Long>(actions), targetChains, policyActions);
        });
    }

    private void singleChain(List<Long> actions, List<TargetChain> targetChains, List<TargetAction> policyActions) {
        targetChains.sort(Comparator.comparing(TargetChain::getUri).reversed());
        for (TargetChain target : targetChains) {
            List actualAllows = policyActions.stream().filter(o -> target.getSid() == o.getTargetSid() && MenuEffect.allow.name().equals(o.getEffect())).map(TargetAction::getActionSid).collect(Collectors.toList());
            List actualDenys = policyActions.stream().filter(o -> target.getSid() == o.getTargetSid() && MenuEffect.deny.name().equals(o.getEffect())).map(TargetAction::getActionSid).collect(Collectors.toList());
            List validAllows = actualAllows.stream().filter(actions::contains).collect(Collectors.toList());
            List validDenys = actualDenys.stream().filter(actions::contains).collect(Collectors.toList());
            policyActions.forEach(o -> {
                if (target.getSid() == o.getTargetSid()) {
                    if (validAllows.contains(o.getActionSid())) {
                        o.setTick(1);
                    }
                    if (validDenys.contains(o.getActionSid())) {
                        o.setTick(2);
                    }
                }
            });
            actions.removeAll(actualAllows);
            actions.removeAll(actualDenys);
        }
    }
}

