/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.permission.impl;

import com.digiwin.dap.middleware.entity.UnionKey;
import com.digiwin.dap.middleware.iam.domain.permission.ApiPermissionQueryResultVO;
import com.digiwin.dap.middleware.iam.entity.ApiPermission;
import com.digiwin.dap.middleware.iam.repository.ApiPermissionRepository;
import com.digiwin.dap.middleware.iam.service.permission.ApiPermissionCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityWithUnionKeyManagerService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiPermissionCrudServiceImpl
extends BaseEntityWithUnionKeyManagerService<ApiPermission>
implements ApiPermissionCrudService {
    @Autowired
    private ApiPermissionRepository apiPermissionRepository;

    protected UnionKey createUnionKey() {
        return UnionKey.create().apply(ApiPermission.class).add("user_id").add("tenant_id").add("appId").add("api");
    }

    protected ApiPermissionRepository getRepository() {
        return this.apiPermissionRepository;
    }

    @Override
    public List<ApiPermissionQueryResultVO> getApiPermissionsByUserIdAndTenantIdAndAppId(String userId, String tenantId, String appId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{userId, tenantId, appId})) {
            throw new IllegalArgumentException("parameters have null");
        }
        List<Object[]> objList = this.apiPermissionRepository.findDataPermissionsByUserIdAndTenantIdAndAppId(userId, tenantId, appId);
        ArrayList<ApiPermissionQueryResultVO> result = new ArrayList<ApiPermissionQueryResultVO>();
        if (objList != null && objList.size() > 0) {
            for (Object[] rowOjb : objList) {
                ApiPermissionQueryResultVO apiVO = new ApiPermissionQueryResultVO();
                apiVO.setSid((Long)rowOjb[0]);
                apiVO.setApi((String)rowOjb[1]);
                apiVO.setRowPermission((String)rowOjb[2]);
                apiVO.setColPermission((String)rowOjb[3]);
                result.add(apiVO);
            }
        }
        return result;
    }

    @Override
    public void deleteApiPermissionsByUserIdAndTenantIdAndAppId(String userId, String tenantId, String appId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{userId, tenantId, appId})) {
            throw new IllegalArgumentException("parameters have null");
        }
        this.apiPermissionRepository.deleteByUserIdAndTenantIdAndAppId(userId, tenantId, appId);
    }
}

