/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.permission.impl;

import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.permission.ApiPermissionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.permission.ApiPermissionQueryVO;
import com.digiwin.dap.middleware.iam.domain.permission.ApiPermissionVO;
import com.digiwin.dap.middleware.iam.entity.ApiPermission;
import com.digiwin.dap.middleware.iam.service.permission.ApiPermissionCrudService;
import com.digiwin.dap.middleware.iam.service.permission.ApiPermissionService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiPermissionServiceImpl
implements ApiPermissionService {
    private static final Logger logger = LoggerFactory.getLogger(ApiPermissionServiceImpl.class);
    @Autowired
    private ApiPermissionCrudService apiPermissionCrudService;

    @Override
    public List<Long> addApiPermission(ApiPermissionVO apiPermissionVO) {
        String userId = apiPermissionVO.getUserId();
        String tenantId = apiPermissionVO.getTenantId();
        String appId = apiPermissionVO.getAppId();
        List dataPermissions = apiPermissionVO.getDataPermissions();
        String apiPath = "";
        String rowPerm = "";
        String colPerm = "";
        ArrayList<Long> result = new ArrayList<Long>();
        for (Object obj : dataPermissions) {
            Map apiMap = (Map)obj;
            apiPath = (String)apiMap.get("api");
            rowPerm = apiMap.getOrDefault("rowPermission", null);
            colPerm = apiMap.getOrDefault("colPermission", null);
            ApiPermission apiPermission = new ApiPermission(userId, tenantId, appId, apiPath, rowPerm, colPerm);
            long apiSid = this.apiPermissionCrudService.create(apiPermission);
            result.add(apiSid);
        }
        return result;
    }

    @Override
    public List<ApiPermissionQueryResultVO> getApiPermission(ApiPermissionQueryVO apiPermissionQueryVO) {
        String userId = apiPermissionQueryVO.getUserId();
        String tenantId = apiPermissionQueryVO.getTenantId();
        String appId = apiPermissionQueryVO.getAppId();
        List<ApiPermissionQueryResultVO> result = this.apiPermissionCrudService.getApiPermissionsByUserIdAndTenantIdAndAppId(userId, tenantId, appId);
        return result;
    }

    @Override
    public void deleteApiPermission(ApiPermissionQueryVO apiPermissionQueryVO) {
        String userId = apiPermissionQueryVO.getUserId();
        String tenantId = apiPermissionQueryVO.getTenantId();
        String appId = apiPermissionQueryVO.getAppId();
        this.apiPermissionCrudService.deleteApiPermissionsByUserIdAndTenantIdAndAppId(userId, tenantId, appId);
    }

    @Override
    public ApiPermissionQueryVO getApiPermissionQueryVOByUser(LoginUser user) {
        String userId = user.getUserId();
        String tenantId = user.getTenantId();
        String appId = user.getApp().getId();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{userId, tenantId, appId})) {
            throw new IllegalArgumentException("parameters' values have null");
        }
        ApiPermissionQueryVO apiPermsissionVO = new ApiPermissionQueryVO(userId, tenantId, appId);
        return apiPermsissionVO;
    }
}

