/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.permission.impl;

import com.digiwin.dap.middleware.iam.constant.enums.ConditionValueEnum;
import com.digiwin.dap.middleware.iam.domain.app.ActionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.ModuleQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.SysQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.permission.CalcUser;
import com.digiwin.dap.middleware.iam.domain.permission.ModulePolicy;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionPolicy;
import com.digiwin.dap.middleware.iam.domain.permission.v2.CacAuthData;
import com.digiwin.dap.middleware.iam.domain.permission.v2.CacAuthResult;
import com.digiwin.dap.middleware.iam.domain.permission.v2.MenuEffect;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetAction;
import com.digiwin.dap.middleware.iam.domain.sys.tree.ActionNode;
import com.digiwin.dap.middleware.iam.domain.sys.tree.BaseNode;
import com.digiwin.dap.middleware.iam.domain.sys.tree.ModuleNode;
import com.digiwin.dap.middleware.iam.domain.sys.tree.SysNode;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.app.ActionService;
import com.digiwin.dap.middleware.iam.service.permission.AuthActionService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationVO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AuthActionServiceImpl
implements AuthActionService {
    @Autowired
    private CacService cacService;
    @Autowired
    private ActionService actionService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private CommonCacheService commonCacheService;

    private static PermissionPolicy constructAction(ActionNode action, TargetAction targetAction, boolean admin) {
        PermissionPolicy permissionPolicy = new PermissionPolicy();
        permissionPolicy.setSid(action.getSid());
        permissionPolicy.setId(action.getId());
        Map<Object, Object> policyConditionMap = targetAction == null ? new HashMap() : targetAction.getConditionMap();
        Map<String, String> defaultConditionMap = action.getCondition();
        defaultConditionMap.putAll(policyConditionMap);
        if (admin) {
            defaultConditionMap.replaceAll((k, v) -> ConditionValueEnum.max(v));
        }
        permissionPolicy.setCondition(defaultConditionMap);
        return permissionPolicy;
    }

    @Override
    public SysNode getSysData(CalcUser calcUser) {
        SysNode sysNode = this.commonCacheService.getSysTree(calcUser.getAppSid());
        List<ActionNode> actions = sysNode.getActions();
        List<ActionNode> tenantActions = this.commonCacheService.getSysTree(calcUser.getAppSid(), calcUser.getTenantSid());
        actions.addAll(tenantActions);
        this.actionService.filterByTenantActionRelation(sysNode.getSid(), actions, calcUser.getTenantSid());
        if (!calcUser.isDealer()) {
            actions.removeIf(action -> "djc-mang-deal".equals(action.getId()));
        }
        if (!calcUser.isEoc()) {
            actions.removeIf(action -> "djc-mang-business-operations".equals(action.getId()));
        }
        if (!calcUser.isCorpWechat()) {
            actions.removeIf(action -> "djc-mang-enterprise-wechat".equals(action.getId()));
        }
        if (!calcUser.isAuthLandingConsole()) {
            actions.removeIf(action -> "djc-apply-own-app".equals(action.getId()));
        }
        return sysNode;
    }

    @Override
    public List<PermissionPolicy> getActionPermissions(CalcUser calcUser, boolean admin, Map<Long, TargetAction> allowActionMap, List<ActionNode> actions) {
        return actions.stream().filter(action -> admin || allowActionMap.containsKey(action.getSid())).map(action -> AuthActionServiceImpl.constructAction(action, (TargetAction)allowActionMap.get(action.getSid()), admin)).collect(Collectors.toList());
    }

    @Override
    public List<ModulePolicy> getModulePermissions(CalcUser calcUser, boolean admin, Set<Long> moduleSids, List<ModuleNode> modules) {
        return modules.stream().filter(module -> admin || moduleSids.contains(module.getSid())).map(module -> new ModulePolicy((ModuleNode)module, MenuEffect.allow)).collect(Collectors.toList());
    }

    @Override
    public CacAuthResult filterByAuth(CalcUser calcUser, SysNode sysData) {
        CacAuthResult cacAuthResult = new CacAuthResult();
        CacAuthData cacAuthData = this.prepareCacAuthData(calcUser, sysData);
        cacAuthResult.setCacAuthData(cacAuthData);
        if (calcUser.isInside()) {
            cacAuthResult.setModules(sysData.getModules());
            cacAuthResult.setActions(sysData.getActions());
        } else {
            cacAuthResult.setModules(sysData.getModules().stream().filter(o -> cacAuthData.getValidModuleIds().contains(o.getId())).collect(Collectors.toList()));
            cacAuthResult.setActions(sysData.getActions().stream().filter(o -> cacAuthData.getValidModuleIds().contains(o.getModuleId())).filter(a -> a.getTenantSid() > 0L || cacAuthData.validAction(a.getModuleId(), a.getId())).collect(Collectors.toList()));
        }
        return cacAuthResult;
    }

    private CacAuthData prepareCacAuthData(CalcUser calcUser, SysNode sysData) {
        CacAuthData cacAuthData = new CacAuthData();
        if (calcUser.isInside()) {
            cacAuthData.setValidModuleIds(sysData.getModules().stream().map(BaseNode::getId).collect(Collectors.toSet()));
        } else {
            AuthorizationVO authorization = this.cacService.getModuleIds(calcUser.getTenantId(), calcUser.getAppId());
            if (authorization == null || CollectionUtils.isEmpty(authorization.getEnabledModules())) {
                cacAuthData.setValidModuleIds(sysData.getModules().stream().map(BaseNode::getId).collect(Collectors.toSet()));
            } else {
                List<AuthorizationModuleVO> authedModules = authorization.getEnabledModules();
                cacAuthData.setValidModuleIds(authedModules.stream().filter(o -> LocalDateTime.now().isBefore(o.getExpiredTime())).map(AuthorizationModuleVO::getId).collect(Collectors.toSet()));
                cacAuthData.setExpiredModuleIds(authedModules.stream().filter(o -> LocalDateTime.now().isAfter(o.getExpiredTime())).map(AuthorizationModuleVO::getId).collect(Collectors.toSet()));
                this.extractActionIdsFromModules(authedModules, cacAuthData.getValidActions(), AuthState.VALID);
                this.extractActionIdsFromModules(authedModules, cacAuthData.getExpiredActions(), AuthState.EXPIRED);
            }
        }
        return cacAuthData;
    }

    @Override
    public void filterByAuth(long tenantSid, SysQueryResultVO app, List<ModuleQueryResultVO> modules, List<ActionQueryResultVO> actions) {
        AuthorizationResultVO authorization;
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        this.actionService.filterByTenantActionRelation(app.getSid(), actions, tenantSid);
        if (!tenant.isDealer()) {
            actions.removeIf(action -> "djc-mang-deal".equals(action.getId()));
        }
        if (!tenant.isEoc()) {
            actions.removeIf(action -> "djc-mang-business-operations".equals(action.getId()));
        }
        if (!tenant.isCorpWechat()) {
            actions.removeIf(action -> "djc-mang-enterprise-wechat".equals(action.getId()));
        }
        ArrayList enabledModules = new ArrayList();
        HashMap<String, Set<String>> enabledActions = new HashMap<String, Set<String>>();
        if (!(app.isInside() || "dev".equals(app.getId()) || "ISV".equals(app.getId()) || (authorization = this.cacService.queryAllAuthorization(tenant.getId(), app.getId())) == null || CollectionUtils.isEmpty(authorization.getEnabledModules()))) {
            enabledModules.addAll(authorization.getEnabledModules().stream().map(AuthorizationModuleVO::getId).collect(Collectors.toList()));
            this.extractActionIdsFromModules(authorization.getEnabledModules(), enabledActions, AuthState.ALL);
        }
        modules.removeIf(m -> !enabledModules.isEmpty() && !enabledModules.contains(m.getId()));
        actions.removeIf(a -> a.getTenantSid() == 0L && enabledActions.containsKey(a.getModuleId()) && !((Set)enabledActions.get(a.getModuleId())).contains(a.getId()) && Boolean.FALSE.equals(a.getRegardlessAuth()));
    }

    private void extractActionIdsFromModules(List<AuthorizationModuleVO> cacModules, Map<String, Set<String>> enabledActionIds, AuthState authState) {
        HashMap<String, List<AuthorizationModuleVO>> enabledActions = new HashMap<String, List<AuthorizationModuleVO>>();
        this.extractActionsFromModules(cacModules, enabledActions, authState);
        enabledActionIds.putAll(enabledActions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(AuthorizationModuleVO::getId).collect(Collectors.toSet()), (k1, k2) -> k1)));
    }

    private void extractActionsFromModules(List<AuthorizationModuleVO> cacModules, Map<String, List<AuthorizationModuleVO>> enabledActions, AuthState authState) {
        if (CollectionUtils.isEmpty(cacModules)) {
            return;
        }
        for (AuthorizationModuleVO enabledModule : cacModules) {
            if (CollectionUtils.isEmpty(enabledModule.getActions())) continue;
            ArrayList<AuthorizationModuleVO> purchasedActions = new ArrayList<AuthorizationModuleVO>();
            enabledActions.put(enabledModule.getId(), purchasedActions);
            this.recursiveExtractEnabledActions(enabledModule.getActions(), purchasedActions, authState);
        }
    }

    private void recursiveExtractEnabledActions(List<AuthorizationModuleVO> current, List<AuthorizationModuleVO> purchasedActions, AuthState authState) {
        if (CollectionUtils.isEmpty(current)) {
            return;
        }
        if (authState == AuthState.ALL) {
            purchasedActions.addAll(current);
        } else if (authState == AuthState.VALID) {
            purchasedActions.addAll(current.stream().filter(a -> a.getExpiredTime() == null || LocalDateTime.now().isBefore(a.getExpiredTime())).collect(Collectors.toList()));
        } else if (authState == AuthState.EXPIRED) {
            purchasedActions.addAll(current.stream().filter(a -> a.getExpiredTime() != null && LocalDateTime.now().isAfter(a.getExpiredTime())).collect(Collectors.toList()));
        }
        for (AuthorizationModuleVO enabledModule : current) {
            List<AuthorizationModuleVO> actions = enabledModule.getActions();
            if (CollectionUtils.isEmpty(actions)) continue;
            this.recursiveExtractEnabledActions(actions, purchasedActions, authState);
        }
    }

    private static enum AuthState {
        ALL,
        VALID,
        EXPIRED;

    }
}

