/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.permission.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionUserOrg;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionUserRole;
import com.digiwin.dap.middleware.iam.domain.permission.v2.StatementInfo;
import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyCondition;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetAction;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetCondition;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Policy;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.mapper.AuthMapper;
import com.digiwin.dap.middleware.iam.mapper.OrgMapper;
import com.digiwin.dap.middleware.iam.mapper.PermissionMapper;
import com.digiwin.dap.middleware.iam.service.permission.impl.AbstractAuthCalcService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyConditionValueCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Primary
@Service
public class AuthCalcServiceImpl
extends AbstractAuthCalcService {
    @Autowired
    private OrgMapper orgMapper;
    @Autowired
    private AuthMapper authMapper;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private PermissionMapper permissionMapper;
    @Autowired
    private PolicyCrudService policyCrudService;
    @Autowired
    private PolicyConditionValueCrudService conditionValueCrudService;

    @Override
    public List<TargetAction> getActionCondition(long tenantSid, long sysSid, String type, long targetSid, long actionSid) {
        List<Org> tenantOrgs = this.orgMapper.getOrgsByTenantSid(tenantSid);
        List<Long> actionSids = this.getSysActions(tenantSid, sysSid);
        List<TargetAction> policyActions = new ArrayList<TargetAction>();
        Map<Long, Org> orgMap = tenantOrgs.stream().collect(Collectors.toMap(BaseEntity::getSid, a -> a, (k1, k2) -> k1));
        HashSet<Long> orgSids = new HashSet<Long>();
        if (TargetType.user.name().equals(type)) {
            List<PermissionUserRole> roleInfos = this.permissionMapper.findUserRoles(tenantSid, targetSid);
            List<PermissionUserOrg> orgInfos = this.permissionMapper.findUserOrgs(tenantSid, targetSid);
            policyActions.addAll(this.getPolicyAction(tenantSid, sysSid, targetSid, TargetType.user));
            if (!CollectionUtils.isEmpty(roleInfos)) {
                policyActions.addAll(this.getPolicyAction(tenantSid, sysSid, roleInfos.stream().map(PermissionUserRole::getSid).collect(Collectors.toList()), TargetType.role));
                roleInfos.stream().filter(role -> role.getOrgSid() > 0L).forEach(role -> this.getParentOrg(role.getOrgSid(), orgSids, orgMap));
            }
            if (!CollectionUtils.isEmpty(orgInfos)) {
                orgSids.addAll(orgInfos.stream().map(PermissionUserOrg::getSid).collect(Collectors.toList()));
            }
            policyActions.addAll(this.getPolicyAction(tenantSid, sysSid, new ArrayList<Long>(orgSids), TargetType.org));
        } else if (TargetType.role.name().equals(type)) {
            Role role2 = this.roleCrudService.findByTenantSidAndSid(tenantSid, targetSid);
            if (null != role2) {
                policyActions.addAll(this.getPolicyAction(tenantSid, sysSid, targetSid, TargetType.role));
                this.getParentOrg(role2.getOrgSid(), orgSids, orgMap);
                policyActions.addAll(this.getPolicyAction(tenantSid, sysSid, new ArrayList<Long>(orgSids), TargetType.org));
            }
        } else if (TargetType.org.name().equals(type)) {
            this.getParentOrg(targetSid, orgSids, orgMap);
            policyActions = this.getPolicyAction(tenantSid, sysSid, new ArrayList<Long>(orgSids), TargetType.org);
        }
        policyActions.removeIf(p -> actionSid != p.getActionSid());
        List<TargetAction> allowPolicyActions = this.mergePolicyAction(actionSids, policyActions, tenantSid, targetSid, TargetType.valueOf(type));
        List<TargetAction> allowWithCondition = this.mergePolicyActionCondition(sysSid, allowPolicyActions);
        return allowWithCondition;
    }

    @Override
    public void bindPolicyActionCondition(long sysSid, List<TargetAction> policyActions) {
        List<Long> policySids = policyActions.stream().map(TargetAction::getPolicySid).distinct().collect(Collectors.toList());
        Map<String, List> policyConditionMap = this.conditionValueCrudService.findByPolicySids(policySids).stream().collect(Collectors.toMap(k -> k.getPolicySid() + "-" + k.getActionSid(), c -> TargetCondition.parse(c.getConditionValue())));
        Map actionConditionMap = this.authMapper.findPolicyCondition(sysSid).stream().collect(Collectors.groupingBy(PolicyCondition::getActionSid, Collectors.mapping(PolicyCondition::getKey, Collectors.toList())));
        policyActions.forEach(policyAction -> {
            List policyConditions = (List)policyConditionMap.get(policyAction.getPolicySid() + "-" + policyAction.getActionSid());
            List actionConditions = (List)actionConditionMap.get(policyAction.getActionSid());
            if (policyConditions != null && actionConditions != null) {
                policyAction.setConditions(policyConditions.stream().filter(c -> actionConditions.contains(c.getKey())).collect(Collectors.toList()));
            }
        });
    }

    @Override
    protected List<TargetAction> findPolicyAction(long tenantSid, long sysSid, long targetSid, TargetType targetType, List<PermissionUserRole> roleInfos, List<PermissionUserOrg> orgInfos) {
        List<Org> tenantOrgList = this.orgMapper.getOrgsByTenantSid(tenantSid);
        Map<Long, Org> orgMap = tenantOrgList.stream().collect(Collectors.toMap(BaseEntity::getSid, a -> a, (k1, k2) -> k1));
        HashSet<Long> orgSids = new HashSet<Long>();
        if (TargetType.user == targetType) {
            if (roleInfos == null) {
                roleInfos = this.permissionMapper.findUserRoles(tenantSid, targetSid);
            }
            if (orgInfos == null) {
                orgInfos = this.permissionMapper.findUserOrgs(tenantSid, targetSid);
            }
            List<TargetAction> userActions = this.getPolicyAction(tenantSid, sysSid, targetSid, TargetType.user);
            List<Long> roleSids = roleInfos.stream().map(PermissionUserRole::getSid).collect(Collectors.toList());
            List<TargetAction> roleActions = this.getPolicyAction(tenantSid, sysSid, roleSids, TargetType.role);
            roleInfos.stream().filter(role -> role.getOrgSid() > 0L).forEach(role -> this.getParentOrg(role.getOrgSid(), orgSids, orgMap));
            for (PermissionUserOrg orgInfo : orgInfos) {
                this.getParentOrg(orgInfo.getSid(), orgSids, orgMap);
            }
            List<TargetAction> orgActions = this.getPolicyAction(tenantSid, sysSid, new ArrayList<Long>(orgSids), TargetType.org);
            return Stream.of(userActions, roleActions, orgActions).flatMap(Collection::stream).collect(Collectors.toList());
        }
        if (TargetType.role == targetType) {
            List<TargetAction> roleActions = this.getPolicyAction(tenantSid, sysSid, targetSid, TargetType.role);
            Role role2 = this.roleCrudService.findByTenantSidAndSid(tenantSid, targetSid);
            if (role2 != null) {
                this.getParentOrg(role2.getOrgSid(), orgSids, orgMap);
            }
            List<TargetAction> orgActions = this.getPolicyAction(tenantSid, sysSid, new ArrayList<Long>(orgSids), TargetType.org);
            return Stream.of(roleActions, orgActions).flatMap(Collection::stream).collect(Collectors.toList());
        }
        if (TargetType.org == targetType) {
            this.getParentOrg(targetSid, orgSids, orgMap);
            return this.getPolicyAction(tenantSid, sysSid, new ArrayList<Long>(orgSids), TargetType.org);
        }
        return Collections.emptyList();
    }

    @Override
    protected List<TargetAction> mergePolicyActionCondition(long sysSid, List<TargetAction> policyActions) {
        this.bindPolicyActionCondition(sysSid, policyActions);
        return super.mergePolicyActionCondition(sysSid, policyActions);
    }

    private void getParentOrg(long orgSid, Set<Long> targetOrgSids, Map<Long, Org> orgMap) {
        if (orgSid > 0L) {
            targetOrgSids.add(orgSid);
            Org org = orgMap.get(orgSid);
            if (org != null) {
                this.getParentOrg(org.getParentSid(), targetOrgSids, orgMap);
            }
        }
    }

    private List<TargetAction> getPolicyAction(long tenantSid, long sysSid, long targetSid, TargetType targetType) {
        return this.getPolicyAction(tenantSid, sysSid, Collections.singletonList(targetSid), targetType);
    }

    private List<TargetAction> getPolicyAction(long tenantSid, long sysSid, List<Long> targetSids, TargetType targetType) {
        List<Policy> policies = this.policyCrudService.findPolicy(tenantSid, sysSid, targetSids, targetType.name());
        return StatementInfo.getPolicyStatement(policies);
    }
}

