/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.permission.impl;

import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DataTargetVO;
import com.digiwin.dap.middleware.iam.domain.datapolicy.RowFilter;
import com.digiwin.dap.middleware.iam.domain.permission.CalcUser;
import com.digiwin.dap.middleware.iam.domain.permission.ColPermission;
import com.digiwin.dap.middleware.iam.domain.permission.DataPermission;
import com.digiwin.dap.middleware.iam.domain.permission.ModulePolicy;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionPolicy;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionUserOrg;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionUserRole;
import com.digiwin.dap.middleware.iam.domain.permission.UserFunPermission;
import com.digiwin.dap.middleware.iam.domain.permission.UserPermissionResult;
import com.digiwin.dap.middleware.iam.domain.permission.v2.CacAuthResult;
import com.digiwin.dap.middleware.iam.domain.permission.v2.MenuEffect;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetAction;
import com.digiwin.dap.middleware.iam.domain.sys.tree.ActionNode;
import com.digiwin.dap.middleware.iam.domain.sys.tree.BaseNode;
import com.digiwin.dap.middleware.iam.domain.sys.tree.ModuleNode;
import com.digiwin.dap.middleware.iam.domain.sys.tree.SysNode;
import com.digiwin.dap.middleware.iam.entity.DevSys;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.AuthMapper;
import com.digiwin.dap.middleware.iam.mapper.DataPermissionMapper;
import com.digiwin.dap.middleware.iam.mapper.PermissionMapper;
import com.digiwin.dap.middleware.iam.repository.DevSysRepository;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyService;
import com.digiwin.dap.middleware.iam.service.dev.sys.DevSysCrudService;
import com.digiwin.dap.middleware.iam.service.permission.AuthActionService;
import com.digiwin.dap.middleware.iam.service.permission.AuthCalcService;
import com.digiwin.dap.middleware.iam.service.permission.AuthService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyTargetService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@CacheConfig(cacheNames={"default"}, cacheManager="cacheManager")
@Service
public class AuthServiceImpl
implements AuthService {
    private static final Logger logger = LoggerFactory.getLogger(AuthServiceImpl.class);
    @Autowired
    private AuthMapper authMapper;
    @Autowired
    private AuthCalcService authCalcService;
    @Autowired
    private PermissionMapper permissionMapper;
    @Autowired
    private DataPolicyService dataPolicyService;
    @Autowired
    private PolicyTargetService policyTargetService;
    @Autowired
    private DevSysCrudService devSysCrudService;
    @Autowired
    private DataPermissionMapper dataPermissionMapper;
    @Autowired
    private DevSysRepository devSysRepository;
    @Autowired
    private AuthService authService;
    @Autowired
    private AuthActionService authActionService;

    @Override
    @Cacheable(key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).PERMISSION_ACTION_PREFIX + #calcUser.userId + '::' + #calcUser.tenantId + '::' + #calcUser.appId")
    public UserPermissionResult getUserPermission(CalcUser calcUser, SysNode sysData) {
        List<PermissionUserRole> roleInfos = this.permissionMapper.findUserRoles(calcUser.getTenantSid(), calcUser.getUserSid());
        List<PermissionUserOrg> orgInfos = this.permissionMapper.findUserOrgs(calcUser.getTenantSid(), calcUser.getUserSid());
        Map<String, PermissionUserOrg> org = orgInfos.stream().collect(Collectors.toMap(PermissionUserOrg::getPriority, a -> a, (k1, k2) -> k1));
        boolean admin = roleInfos.stream().anyMatch(o -> "superadmin".equals(o.getId()));
        CacAuthResult cacAuthResult = this.authActionService.filterByAuth(calcUser, sysData);
        List<ActionNode> actions = cacAuthResult.getActions();
        List<ModuleNode> modules = cacAuthResult.getModules();
        List<Long> actionSids = actions.stream().map(BaseNode::getSid).collect(Collectors.toList());
        Map<Long, TargetAction> allowMap = this.authCalcService.getUserAction(calcUser, actionSids, roleInfos, orgInfos);
        List<PermissionPolicy> actionPermissions = this.authActionService.getActionPermissions(calcUser, admin, allowMap, actions);
        Set<Long> allowModuleSids = actions.stream().filter(o -> allowMap.containsKey(o.getSid())).map(ActionNode::getModuleSid).collect(Collectors.toSet());
        List<ModulePolicy> modulePermissions = this.authActionService.getModulePermissions(calcUser, admin, allowModuleSids, modules);
        RedisUtils.opsForSet().add((Object)calcUser.appKey(), new Object[]{calcUser.uniqueKey()});
        return new UserPermissionResult(roleInfos, org, actionPermissions, modulePermissions, cacAuthResult.getCacAuthData());
    }

    @Override
    public List<PermissionPolicy> fillAction(CalcUser calcUser, SysNode sysData, UserPermissionResult result, MenuEffect effect) {
        Map<Long, Map> allowActionMap = result.getPermissions().stream().collect(Collectors.toMap(PermissionPolicy::getSid, PermissionPolicy::getCondition, (k1, k2) -> k1));
        ArrayList<PermissionPolicy> permissions = new ArrayList<PermissionPolicy>();
        sysData.getActions().forEach(action -> {
            if (Boolean.TRUE.equals(action.getRegardlessAuth()) && effect != MenuEffect.deny) {
                PermissionPolicy allowAction = new PermissionPolicy((ActionNode)action, action.getCondition(), MenuEffect.allow);
                permissions.add(allowAction);
            } else {
                Map condition = (Map)allowActionMap.get(action.getSid());
                if (condition != null && effect != MenuEffect.deny) {
                    PermissionPolicy allowAction = new PermissionPolicy((ActionNode)action, condition, MenuEffect.allow);
                    permissions.add(allowAction);
                } else if (condition == null && effect != MenuEffect.allow) {
                    PermissionPolicy denyAction = new PermissionPolicy((ActionNode)action, action.getCondition(), MenuEffect.deny);
                    Optional.ofNullable(result.getCacAuthData()).ifPresent(a -> a.determineDenyReason(denyAction));
                    permissions.add(denyAction);
                }
            }
        });
        return permissions;
    }

    @Override
    public UserFunPermission fillActionModule(CalcUser calcUser, SysNode sysData, UserPermissionResult result, MenuEffect effect) {
        List<PermissionPolicy> actionPermissions = this.fillAction(calcUser, sysData, result, effect);
        Map<Long, ModulePolicy> allowModuleMap = result.getModules().stream().collect(Collectors.toMap(ModulePolicy::getSid, a -> a, (k1, k2) -> k1));
        ArrayList<ModulePolicy> modulePermissions = new ArrayList<ModulePolicy>();
        sysData.getModules().forEach(module -> {
            boolean isAllowed = allowModuleMap.containsKey(module.getSid());
            if (isAllowed && effect != MenuEffect.deny) {
                modulePermissions.add(new ModulePolicy((ModuleNode)module, MenuEffect.allow));
            } else if (!isAllowed && effect != MenuEffect.allow) {
                modulePermissions.add(new ModulePolicy((ModuleNode)module, MenuEffect.deny));
            }
        });
        return UserFunPermission.of(actionPermissions, modulePermissions);
    }

    @Override
    public List<UserFunPermission> getUserPermissionBatch(List<String> userIds, List<String> sysIds, MenuEffect effect, IamAuthoredUser authoredUser) {
        List<CalcUser> calcUsers = this.combineCalcUser(userIds, sysIds, authoredUser);
        ArrayList<UserFunPermission> results = new ArrayList<UserFunPermission>(calcUsers.size());
        HashMap sysDataMap = new HashMap();
        calcUsers.forEach(calcUser -> {
            if (!sysDataMap.containsKey(calcUser.getAppId())) {
                sysDataMap.put(calcUser.getAppId(), this.authActionService.getSysData((CalcUser)calcUser));
            }
            SysNode sysData = (SysNode)sysDataMap.get(calcUser.getAppId());
            UserPermissionResult userPermission = this.authService.getUserPermission((CalcUser)calcUser, sysData);
            List<PermissionPolicy> permissions = this.fillAction((CalcUser)calcUser, sysData, userPermission, effect);
            results.add(UserFunPermission.of(calcUser.getUserId(), calcUser.getAppId(), permissions));
        });
        return results;
    }

    @Override
    public List<CalcUser> combineCalcUser(List<String> userIds, List<String> sysIds, IamAuthoredUser authoredUser) {
        List<User> users = this.authMapper.findByTenantSidInUserIds(authoredUser.getTenantSid(), userIds);
        List<Sys> sysList = this.authMapper.findByTenantSidInSysIds(authoredUser.getTenantSid(), sysIds);
        ArrayList<CalcUser> calcUsers = new ArrayList<CalcUser>();
        HashSet errorUserIds = new HashSet();
        HashSet errorSysIds = new HashSet();
        userIds.forEach(userId -> {
            User user = users.stream().filter(u -> u.getId().equals(userId)).findFirst().orElse(null);
            if (user == null) {
                errorUserIds.add(userId);
            } else {
                sysIds.forEach(sysId -> {
                    Sys sys = sysList.stream().filter(a -> a.getId().equals(sysId)).findFirst().orElse(null);
                    if (sys == null) {
                        errorSysIds.add(sysId);
                    } else {
                        CalcUser calcUser = new CalcUser();
                        calcUser.setUserSid(user.getSid());
                        calcUser.setUserId((String)userId);
                        calcUser.setUserName(user.getName());
                        calcUser.setTenantSid(authoredUser.getTenantSid());
                        calcUser.setTenantId(authoredUser.getTenantId());
                        calcUser.setDealer(authoredUser.isDealer());
                        calcUser.setEoc(authoredUser.isEoc());
                        calcUser.setCorpWechat(authoredUser.isCorpWechat());
                        calcUser.setAppSid(sys.getSid());
                        calcUser.setAppId(sys.getId());
                        calcUser.setInside(sys.isInside());
                        calcUsers.add(calcUser);
                    }
                });
            }
        });
        if (!errorUserIds.isEmpty()) {
            logger.error("\u7528\u6237{}\u4e0d\u5b58\u5728\u6216\u4e0d\u5728{}\u79df\u6237\u4e0b", (Object)String.join((CharSequence)",", errorUserIds), (Object)authoredUser.getTenantId());
        }
        if (!errorSysIds.isEmpty()) {
            logger.error("\u7528\u6237{}\u4e0d\u5b58\u5728\u6216\u79df\u6237{}\u6ca1\u6709\u8d2d\u4e70", (Object)String.join((CharSequence)",", errorSysIds), (Object)authoredUser.getTenantId());
        }
        return calcUsers;
    }

    @Override
    public DataPermission getDataPermission(DataTargetVO input) {
        boolean admin = this.policyTargetService.isSuperAdmin(input.getTenantSid(), input.getUserSid(), "user");
        if (admin) {
            return DataPermission.superadmin();
        }
        String tableName = input.getTableName();
        DataPermission result = this.dataPolicyService.getDataPolicy(input.getTenantSid(), "user", input.getUserSid(), input.getSysSid(), input.getActionSid(), true);
        result.setSuperadmin(false);
        this.filterRow(result, tableName);
        result.setRowPermissions(null);
        this.filterCol(result, tableName);
        return result;
    }

    private void filterRow(DataPermission result, String tableName) {
        List<RowFilter> rowPermissions = result.getRowPermissions();
        if (!CollectionUtils.isEmpty(rowPermissions)) {
            if (rowPermissions.size() == 1) {
                RowFilter rowFilter = rowPermissions.get(0);
                result.setRowPermission(new RowFilter());
                if (ObjectUtils.isEmpty((Object)tableName) || RowFilter.extractName(rowFilter).contains(tableName)) {
                    result.setRowPermission(rowFilter);
                }
            } else {
                RowFilter groupRowFilter = RowFilter.buildRowFilter4Group(rowPermissions);
                if (ObjectUtils.isEmpty((Object)tableName)) {
                    result.setRowPermission(groupRowFilter);
                } else {
                    HashMap tables = (HashMap)groupRowFilter.getFilterValue();
                    result.setRowPermission((RowFilter)tables.get(tableName));
                }
            }
        }
    }

    private void filterCol(DataPermission result, String tableName) {
        List<ColPermission> colPermissions = result.getColPermission();
        if (colPermissions != null && StringUtils.hasLength((String)tableName)) {
            colPermissions.removeIf(col -> !tableName.equals(col.getTable()));
        }
    }

    @Override
    public DataPermission getDataPermission(long tenantSid, long userSid, long sysSid, long actionSid) {
        boolean admin = this.policyTargetService.isSuperAdmin(tenantSid, userSid, "user");
        if (admin) {
            return DataPermission.superadmin();
        }
        DataPermission dataMap = this.dataPolicyService.getDataPolicy(tenantSid, "user", userSid, sysSid, actionSid, true);
        dataMap.setSuperadmin(false);
        return dataMap;
    }

    @Override
    public List<Map> getDataPermissionRow(DataTargetVO input) {
        DataPermission dataPermission = this.getDataPermission(input);
        ArrayList<Map> dataValues = new ArrayList<Map>();
        if (Boolean.TRUE.equals(dataPermission.getSuperadmin())) {
            List<DevSys> devSysList = this.devSysRepository.findDevSysByTenantSidOrTenantId(input.getTenantSid(), input.getTenantId());
            devSysList.forEach(a -> {
                HashMap<String, String> dataValue = new HashMap<String, String>();
                dataValue.put("idv ", a.getId());
                dataValue.put("name", a.getNameCN());
                dataValues.add(dataValue);
            });
        } else if (dataPermission.getRowPermission() != null) {
            RowFilter rowPermission = dataPermission.getRowPermission();
            if ("in".equals(rowPermission.getFilterType())) {
                dataValues.addAll(this.fillAppInfo((List)rowPermission.getFilterValue(), rowPermission.getFilterValueName()));
            } else if ("or".equals(rowPermission.getFilterType()) || "and".equalsIgnoreCase(rowPermission.getFilterType())) {
                dataValues.addAll(this.fillAppInfo(rowPermission.fetchAllValues(), rowPermission.fetchAllNames()));
            }
        }
        return dataValues;
    }

    private List<Map> fillAppInfo(List<String> values, List<String> names) {
        ArrayList<Map> dataValues = new ArrayList<Map>();
        for (int i = 0; i < values.size(); ++i) {
            HashMap<String, String> dataValue = new HashMap<String, String>();
            String id = values.get(i);
            dataValue.put("id", id);
            if (names != null && names.size() > i) {
                dataValue.put("name", names.get(i));
            } else {
                DevSys devSys = (DevSys)this.devSysCrudService.findById(id);
                if (devSys != null) {
                    dataValue.put("name", devSys.getNameCN());
                }
            }
            if (dataValues.stream().anyMatch(d -> id.equals(d.get("id")))) continue;
            dataValues.add(dataValue);
        }
        return dataValues;
    }

    @Override
    public List<PermissionUserRole> getDataPermissionRoles(DataTargetVO input) {
        List<PermissionUserRole> roleInfos = this.dataPermissionMapper.findRolesByRowFilterValue(input.getTenantSid(), input.getActionSid(), input.getDevAppId());
        return roleInfos;
    }
}

