/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.permission.impl;

import com.digiwin.dap.middleware.iam.domain.permission.v2.StatementInfo;
import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetAction;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetCondition;
import com.digiwin.dap.middleware.iam.entity.Policy;
import com.digiwin.dap.middleware.iam.mapper.AuthUserMapper;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ModuleCrudService;
import com.digiwin.dap.middleware.iam.service.permission.AuthCalcService;
import com.digiwin.dap.middleware.iam.service.permission.AuthUserService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthUserServiceImpl
implements AuthUserService {
    private static final String POLICY_SYS = "DigiwinCloud";
    private static final String POLICY_MODULE = "djc-cloud-management";
    private static final String POLICY_ACTION = "djc-mang-user";
    private static final String POLICY_CONDITION = "action_approveRecord";
    private static final String ALLOW = "allow";
    @Autowired
    private AuthUserMapper authUserMapper;
    @Autowired
    private AuthCalcService authCalcService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private ModuleCrudService moduleCrudService;
    @Autowired
    private ActionCrudService actionCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private PolicyCrudService policyCrudService;

    @Override
    public List<String> getUsersEmail(String tenantId) {
        long tenantSid = this.tenantCrudService.getSidById(tenantId);
        long sysSid = this.sysCrudService.getSidById(POLICY_SYS);
        long moduleSid = this.moduleCrudService.getSidByUnionKey(new Object[]{POLICY_MODULE, sysSid});
        long actionSid = this.actionCrudService.getSidByUnionKey(new Object[]{POLICY_ACTION, moduleSid, 0});
        ArrayList<Long> allowUserSids = new ArrayList<Long>();
        ArrayList<Long> allowRoleSids = new ArrayList<Long>();
        ArrayList<Long> allowOrgSids = new ArrayList<Long>();
        ArrayList denyUserSids = new ArrayList();
        ArrayList<Long> denyRoleSids = new ArrayList<Long>();
        ArrayList<Long> denyOrgSids = new ArrayList<Long>();
        List<Policy> policies = this.policyCrudService.findPolicy(tenantSid, sysSid);
        List<TargetAction> policyActions = StatementInfo.getPolicyStatement(policies).stream().filter(p -> p.getActionSid() == actionSid).collect(Collectors.toList());
        this.authCalcService.bindPolicyActionCondition(sysSid, policyActions);
        policyActions.forEach(o -> {
            switch (o.getTargetType()) {
                case "user": {
                    if (ALLOW.equals(o.getEffect())) {
                        if (this.notAllow(o.getConditions())) {
                            denyUserSids.add(o.getTargetSid());
                            break;
                        }
                        allowUserSids.add(o.getTargetSid());
                        break;
                    }
                    denyUserSids.add(o.getTargetSid());
                    break;
                }
                case "role": {
                    if (!ALLOW.equals(o.getEffect())) break;
                    if (this.notAllow(o.getConditions())) {
                        denyRoleSids.add(o.getTargetSid());
                        break;
                    }
                    allowRoleSids.add(o.getTargetSid());
                    break;
                }
                case "org": {
                    if (!ALLOW.equals(o.getEffect())) break;
                    if (this.notAllow(o.getConditions())) {
                        denyOrgSids.add(o.getTargetSid());
                        break;
                    }
                    allowOrgSids.add(o.getTargetSid());
                }
            }
        });
        ArrayList<Long> tempDenys = new ArrayList<Long>();
        if (!denyRoleSids.isEmpty()) {
            tempDenys.addAll(this.authUserMapper.findUserSidsByRoleSids(tenantSid, denyRoleSids));
        }
        if (!denyOrgSids.isEmpty()) {
            tempDenys.addAll(this.authUserMapper.findUserSidsByOrgSids(denyOrgSids));
        }
        Long superAdmin = this.authUserMapper.findSuperadmin(tenantSid);
        List<Long> superAdmins = this.authUserMapper.findUserSidsByRoleSids(tenantSid, Collections.singletonList(superAdmin));
        denyUserSids.removeAll(superAdmins);
        tempDenys.removeAll(denyUserSids);
        tempDenys.forEach(userSid -> {
            Map<Long, TargetAction> targetActionMap = this.authCalcService.getTargetAction(tenantSid, sysSid, (long)userSid, TargetType.user);
            boolean b = targetActionMap.entrySet().stream().anyMatch(entry -> actionSid == (Long)entry.getKey() && this.notAllow(((TargetAction)entry.getValue()).getConditions()));
            if (b) {
                denyUserSids.add(userSid);
            }
        });
        allowUserSids.addAll(superAdmins);
        if (!allowRoleSids.isEmpty()) {
            allowUserSids.addAll(this.authUserMapper.findUserSidsByRoleSids(tenantSid, allowRoleSids));
        }
        if (!allowOrgSids.isEmpty()) {
            allowUserSids.addAll(this.authUserMapper.findUserSidsByOrgSids(allowOrgSids));
        }
        allowUserSids.removeAll(denyUserSids);
        if (allowUserSids.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> emails = this.authUserMapper.findUsersEmail(allowUserSids);
        return emails.stream().filter(o -> o.contains("@")).collect(Collectors.toList());
    }

    private boolean notAllow(List<TargetCondition> conditionValues) {
        return conditionValues.stream().anyMatch(o -> POLICY_CONDITION.equals(o.getKey()) && !o.getValue().contains(ALLOW));
    }
}

