/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.permission.impl;

import com.digiwin.dap.middleware.iam.domain.permission.PermissionUserOrg;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionUserRole;
import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetAction;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.mapper.DataPolicyMapper;
import com.digiwin.dap.middleware.iam.mapper.OrgMapper;
import com.digiwin.dap.middleware.iam.mapper.PermissionMapper;
import com.digiwin.dap.middleware.iam.service.permission.DataPolicyCalcService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DataPolicyCalcServiceImpl
implements DataPolicyCalcService {
    @Resource
    private DataPolicyMapper dataPolicyMapper;
    @Resource
    private OrgMapper orgMapper;
    @Resource
    private RoleCrudService roleCrudService;
    @Resource
    private PermissionMapper permissionMapper;

    @Override
    public List<TargetAction> getDataPolicy(long tenantSid, String type, long targetSid, long sysSid, long actionSid) {
        if (TargetType.org.name().equals(type)) {
            return this.getOrgTargetActions(tenantSid, Collections.singletonList(targetSid), sysSid, actionSid);
        }
        if (TargetType.role.name().equals(type)) {
            return this.getRoleTargetActions(tenantSid, targetSid, sysSid, actionSid);
        }
        if (TargetType.user.name().equals(type)) {
            return this.getUserTargetActions(tenantSid, targetSid, sysSid, actionSid);
        }
        return new ArrayList<TargetAction>();
    }

    private List<TargetAction> getUserTargetActions(long tenantSid, long targetSid, long sysSid, long actionSid) {
        List<TargetAction> dataPolicy = this.dataPolicyMapper.findDataPolicyStatementOnUser(tenantSid, sysSid, actionSid, targetSid);
        if (CollectionUtils.isEmpty(dataPolicy)) {
            List<PermissionUserRole> roleInfos = this.permissionMapper.findUserRoles(tenantSid, targetSid);
            List<PermissionUserOrg> orgInfos = this.permissionMapper.findUserOrgs(tenantSid, targetSid);
            ArrayList<TargetAction> result = new ArrayList<TargetAction>(this.getOrgTargetActions(tenantSid, orgInfos.stream().map(PermissionUserOrg::getSid).collect(Collectors.toList()), sysSid, actionSid));
            for (PermissionUserRole roleInfo : roleInfos) {
                result.addAll(this.getRoleTargetActions(tenantSid, roleInfo.getSid(), sysSid, actionSid));
            }
            return new ArrayList<TargetAction>(result.stream().collect(Collectors.toMap(TargetAction::getSid, a -> a, (a1, a2) -> a1)).values());
        }
        return dataPolicy;
    }

    private List<TargetAction> getRoleTargetActions(long tenantSid, long targetSid, long sysSid, long actionSid) {
        Role role;
        List<TargetAction> dataPolicy = this.dataPolicyMapper.findDataPolicyStatementOnRole(tenantSid, sysSid, actionSid, targetSid);
        if (CollectionUtils.isEmpty(dataPolicy) && (role = this.roleCrudService.findByTenantSidAndSid(tenantSid, targetSid)) != null && role.getOrgSid() > 0L) {
            return this.getOrgTargetActions(tenantSid, Collections.singletonList(role.getOrgSid()), sysSid, actionSid);
        }
        return dataPolicy;
    }

    private List<TargetAction> getOrgTargetActions(long tenantSid, List<Long> targetSids, long sysSid, long actionSid) {
        Object org2;
        if (CollectionUtils.isEmpty(targetSids)) {
            return new ArrayList<TargetAction>();
        }
        List<Org> tenantOrgList = this.orgMapper.getOrgsByTenantSid(tenantSid);
        HashMap<Long, Long> orgRelations = new HashMap<Long, Long>();
        for (Object org2 : tenantOrgList) {
            if (org2.getParentSid() <= 0L) continue;
            orgRelations.put(org2.getSid(), org2.getParentSid());
        }
        ArrayList<Long> orgSids = new ArrayList<Long>();
        org2 = targetSids.iterator();
        while (org2.hasNext()) {
            Long targetSid;
            Long parentSid = targetSid = (Long)org2.next();
            while (parentSid != null) {
                orgSids.add(parentSid);
                parentSid = (Long)orgRelations.get(parentSid);
            }
        }
        if (orgSids.isEmpty()) {
            return new ArrayList<TargetAction>();
        }
        List<TargetAction> dataPolicy = this.dataPolicyMapper.findDataPolicyStatementOnOrg(tenantSid, sysSid, actionSid, orgSids);
        return targetSids.stream().map(a -> this.filterFromBottom(dataPolicy, (Long)a, orgRelations)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<TargetAction> filterFromBottom(List<TargetAction> dataPolicy, Long targetSid, HashMap<Long, Long> orgRelations) {
        if (targetSid == null) {
            return new ArrayList<TargetAction>();
        }
        List<TargetAction> any = dataPolicy.stream().filter(a -> targetSid.equals(a.getTargetSid())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(any)) {
            return this.filterFromBottom(dataPolicy, orgRelations.get(targetSid), orgRelations);
        }
        return any;
    }
}

