/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.policy.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DataPolicyVO;
import com.digiwin.dap.middleware.iam.entity.DataPolicy;
import com.digiwin.dap.middleware.iam.entity.DataPolicyOnUser;
import com.digiwin.dap.middleware.iam.entity.DataStatement;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.mapper.ActionMapper;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyCrudService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyOnUserCrudService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataStatementCrudService;
import com.digiwin.dap.middleware.iam.service.policy.DefaultPolicyService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCopyService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultPolicyServiceImpl
implements DefaultPolicyService {
    @Autowired
    private ActionMapper actionMapper;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private DataPolicyService dataPolicyService;
    @Autowired
    private PolicyCopyService policyCopyService;
    @Autowired
    private DataPolicyCrudService dataPolicyCrudService;
    @Autowired
    private DataStatementCrudService dataStatementCrudService;
    @Autowired
    private DataPolicyOnUserCrudService dataPolicyOnUserCrudService;

    @Override
    public void updateRolePolicy(Role role) {
        if (role != null) {
            this.policyCopyService.copyPolicy(role.getTenantSid(), "ServiceCloud", role.getId());
            this.policyCopyService.copyPolicy(role.getTenantSid(), "DigiwinCloud", role.getId());
        }
    }

    @Override
    public void updateUserPolicy(long tenantSid, String roleId) {
        this.policyCopyService.copyPolicy(tenantSid, "DigiwinCloud", roleId);
    }

    @Override
    public void updateRolePolicy4Srobot(Role role, String appId) {
        this.policyCopyService.copyPolicy(role.getTenantSid(), appId, role.getId());
    }

    @Override
    public void updateUserDataPolicy(long tenantSid, long userSid, String sysId) {
        try {
            long digiwinCloudSysSid = this.sysCrudService.getSidById("DigiwinCloud");
            Sys sys = (Sys)this.sysCrudService.findById(sysId);
            if (null == sys) {
                throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{sysId});
            }
            DataPolicyVO dataPolicyVO = new DataPolicyVO();
            dataPolicyVO.setType("user");
            dataPolicyVO.setSysSid(digiwinCloudSysSid);
            dataPolicyVO.setTargetSid(userSid);
            Long actionSid = this.actionMapper.findActionById(digiwinCloudSysSid, "djc-cloud-management", "djc-mang-service");
            if (null == actionSid) {
                throw new BusinessException(String.format("\u5e94\u7528%s\u6a21\u7ec4%s\u4e0b\u7684\u884c\u4e3a%s\u4e0d\u5b58\u5728", "DigiwinCloud", "djc-cloud-management", "djc-mang-service"));
            }
            dataPolicyVO.setActionSid(actionSid);
            DataPolicy dataPolicy = this.dataPolicyService.getDataPolicy(tenantSid, "user", userSid, digiwinCloudSysSid);
            if (dataPolicy != null) {
                DataStatement dataStatement = (DataStatement)this.dataStatementCrudService.findByUnionKey(new Object[]{dataPolicy.getSid(), actionSid});
                if (dataStatement == null) {
                    this.createDataStatement(sys, actionSid, dataPolicy.getSid());
                } else {
                    Map filterMap = (Map)JsonUtils.createObjectMapper().readValue(dataStatement.getFilter(), Map.class);
                    List appIds = (List)filterMap.get("filterValue");
                    if (appIds != null) {
                        appIds.add(sysId);
                    }
                    filterMap.put("filterValue", appIds);
                    List appNames = (List)filterMap.get("filterValueName");
                    if (appNames != null) {
                        appNames.add(sys.getName());
                    }
                    filterMap.put("filterValueName", appNames);
                    dataStatement.setFilter(JsonUtils.createObjectMapper().writeValueAsString((Object)filterMap));
                    this.dataStatementCrudService.update(dataStatement);
                }
            } else {
                String policyId = UUID.randomUUID().toString();
                dataPolicy = new DataPolicy();
                dataPolicy.setId(policyId);
                dataPolicy.setName(policyId);
                dataPolicy.setTenantSid(tenantSid);
                dataPolicy.setSysSid(digiwinCloudSysSid);
                this.dataPolicyCrudService.create((BaseEntity)dataPolicy);
                this.createDataStatement(sys, actionSid, dataPolicy.getSid());
            }
            if (!this.dataPolicyOnUserCrudService.existsByUnionKey(new Object[]{userSid, dataPolicy.getSid()})) {
                DataPolicyOnUser dataPolicyOnUser = new DataPolicyOnUser();
                dataPolicyOnUser.setUserSid(userSid);
                dataPolicyOnUser.setPolicySid(dataPolicy.getSid());
                this.dataPolicyOnUserCrudService.create(dataPolicyOnUser);
            }
        }
        catch (Exception ex) {
            throw new BusinessException((Throwable)ex);
        }
    }

    private DataStatement createDataStatement(Sys sys, Long actionSid, Long policySid) {
        try {
            HashMap<String, Object> rowPermission = new HashMap<String, Object>();
            rowPermission.put("sid", System.currentTimeMillis());
            rowPermission.put("filterField", "appId");
            rowPermission.put("filterTable", "app");
            rowPermission.put("filterTableName", "\u5e94\u7528\u7ba1\u7406");
            rowPermission.put("filterType", "in");
            ArrayList<String> filterValues = new ArrayList<String>();
            filterValues.add(sys.getId());
            rowPermission.put("filterValue", filterValues);
            rowPermission.put("filterTypeName", "\u5c5e\u4e8e");
            ArrayList<String> filterValueNames = new ArrayList<String>();
            filterValueNames.add(sys.getName());
            rowPermission.put("filterValueName", filterValueNames);
            rowPermission.put("dataType", "string");
            rowPermission.put("fieldName", "\u5e94\u7528id");
            rowPermission.put("dataSource", 2);
            HashMap<String, HashMap<String, Object>> defaultMap = new HashMap<String, HashMap<String, Object>>();
            defaultMap.put("default", rowPermission);
            String rowPermissionStr = JsonUtils.createObjectMapper().writeValueAsString(defaultMap);
            DataStatement dataStatement = new DataStatement();
            dataStatement.setPolicySid(policySid);
            dataStatement.setActionSid(actionSid);
            dataStatement.setFilter(rowPermissionStr);
            dataStatement.setEffect("allow");
            this.dataStatementCrudService.create(dataStatement);
            return dataStatement;
        }
        catch (Exception ex) {
            throw new BusinessException((Throwable)ex);
        }
    }
}

