/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.policy.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyAction;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyCondition;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyModule;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyPermission;
import com.digiwin.dap.middleware.iam.domain.policy.PolicySys;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetAction;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.AuthMapper;
import com.digiwin.dap.middleware.iam.mapper.PolicyMapper;
import com.digiwin.dap.middleware.iam.service.permission.AuthCalcService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCalcService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyTargetService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationVO;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PolicyCalcServiceImpl
implements PolicyCalcService {
    private static final Logger logger = LoggerFactory.getLogger(PolicyCalcServiceImpl.class);
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private AuthMapper authMapper;
    @Autowired
    private CacService cacService;
    @Autowired
    private PolicyMapper policyMapper;
    @Autowired
    private AuthCalcService authCalcService;
    @Resource(name="excludeSelfAuthCalcServiceImpl")
    private AuthCalcService excludeSelfAuthCalcService;
    @Autowired
    private PolicyTargetService policyTargetService;

    @Override
    public List<Long> getPolicyAction(long tenantSid, String targetType, long targetSid, long sysSid) {
        if (this.policyTargetService.isSuperAdmin(tenantSid, targetSid, targetType)) {
            return this.policyMapper.getActions(tenantSid, sysSid);
        }
        Map<Long, TargetAction> targetActionMap = this.authCalcService.getTargetAction(tenantSid, sysSid, targetSid, TargetType.valueOf(targetType));
        return new ArrayList<Long>(targetActionMap.keySet());
    }

    @Override
    public List<Long> getPolicyActionExcluded(long tenantSid, String targetType, long targetSid, long sysSid) {
        if (this.policyTargetService.isSuperAdmin(tenantSid, targetSid, targetType)) {
            return this.policyMapper.getActions(tenantSid, sysSid);
        }
        return new ArrayList<Long>(this.excludeSelfAuthCalcService.getTargetAction(tenantSid, sysSid, targetSid, TargetType.valueOf(targetType)).keySet());
    }

    @Override
    public PolicyPermission getUserModuleActions(long tenantSid, String tenantId, String userId, String sysId) {
        User user = this.authMapper.findUserByTenantSidAndUserId(tenantSid, userId);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_EXISTED_ERROR, new Object[]{tenantId, userId});
        }
        Sys sys = this.authMapper.findSysByTenantSidAndSysId(tenantSid, sysId);
        if (sys == null) {
            throw new BusinessException((ErrorHandler)I18nError.PERMISSION_SYS_NO_TENANT, new Object[]{sysId, tenantId});
        }
        PolicyPermission policyPermission = this.getSysTree(tenantSid, sys.getSid());
        if (!sys.isInside()) {
            this.filterModule(tenantId, sysId, policyPermission);
        }
        return policyPermission;
    }

    private PolicyPermission getSysTree(long tenantSid, long sysSid) {
        PolicySys app = this.policyMapper.findPolicySys(tenantSid, sysSid);
        List<PolicyModule> modules = this.policyMapper.findPolicyModule(app.getSid());
        List<PolicyAction> actions = this.policyMapper.findPolicyAction(tenantSid, app.getSid());
        List<PolicyCondition> conditions = this.policyMapper.findPolicyCondition(app.getSid());
        this.setConditionToAction(actions, conditions);
        return new PolicyPermission(app, modules, actions);
    }

    private void setConditionToAction(List<PolicyAction> actions, List<PolicyCondition> conditions) {
        conditions.forEach(o -> {
            try {
                o.setTypeParameter((List)objectMapper.readValue(o.getTypeParam(), (TypeReference)new TypeReference<List<String>>(){}));
            }
            catch (IOException e) {
                logger.warn("condition[sid=" + o.getSid() + "]Json\u5b57\u7b26\u4e32\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            }
        });
        Map<Long, List<PolicyCondition>> map = conditions.stream().collect(Collectors.groupingBy(PolicyCondition::getActionSid));
        for (PolicyAction action : actions) {
            if (!map.containsKey(action.getSid())) continue;
            action.setCondition(map.get(action.getSid()));
        }
    }

    private void filterModule(String tenantId, String appId, PolicyPermission permission) {
        AuthorizationVO authorization = this.cacService.getModuleIds(tenantId, appId);
        if (authorization == null || authorization.getEnabledModules().isEmpty()) {
            return;
        }
        List moduleIds = authorization.getEnabledModules().stream().filter(o -> LocalDateTime.now().isBefore(o.getExpiredTime())).map(AuthorizationModuleVO::getId).collect(Collectors.toList());
        ArrayList<PolicyModule> enabledModules = new ArrayList<PolicyModule>();
        ArrayList<Long> enabledModuleSids = new ArrayList<Long>();
        for (PolicyModule module : permission.getModules()) {
            if (!moduleIds.contains(module.getId())) continue;
            enabledModules.add(module);
            enabledModuleSids.add(module.getSid());
        }
        permission.setModules(enabledModules);
        ArrayList<PolicyAction> enabledActions = new ArrayList<PolicyAction>();
        for (PolicyAction action : permission.getActions()) {
            if (!enabledModuleSids.contains(action.getModuleSid())) continue;
            enabledActions.add(action);
        }
        permission.setActions(enabledActions);
    }
}

