/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.policy.impl;

import com.digiwin.dap.middleware.entity.UnionKey;
import com.digiwin.dap.middleware.iam.entity.PolicyConditionValue;
import com.digiwin.dap.middleware.iam.repository.PolicyConditionValueRepository;
import com.digiwin.dap.middleware.iam.service.policy.PolicyConditionValueCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityWithUnionKeyManagerService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PolicyConditionValueCrudServiceImpl
extends BaseEntityWithUnionKeyManagerService<PolicyConditionValue>
implements PolicyConditionValueCrudService {
    @Autowired
    private PolicyConditionValueRepository conditionValueRepository;

    protected UnionKey createUnionKey() {
        return UnionKey.create().apply(PolicyConditionValue.class).add("policySid").add("actionSid");
    }

    protected PolicyConditionValueRepository getRepository() {
        return this.conditionValueRepository;
    }

    @Override
    public PolicyConditionValue findByPolicySidAndActionSid(long policySid, long actionSid) {
        return this.conditionValueRepository.findByPolicySidAndActionSid(policySid, actionSid);
    }

    @Override
    public List<PolicyConditionValue> findByPolicySid(long policySid) {
        return this.conditionValueRepository.findByPolicySid(policySid);
    }

    @Override
    public List<PolicyConditionValue> findByPolicySids(List<Long> policySids) {
        return this.conditionValueRepository.findByPolicySidIn(policySids);
    }

    @Override
    public void deleteByPolicySid(long policySid) {
        this.conditionValueRepository.deleteByPolicySid(policySid);
        this.conditionValueRepository.flush();
    }

    @Override
    public void deleteByPolicySidAndActionSid(long policySid, long actionSid) {
        this.conditionValueRepository.deleteByPolicySidAndActionSid(policySid, actionSid);
        this.conditionValueRepository.flush();
    }
}

