/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.policy.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.domain.policy.CopyPermissionDataVO;
import com.digiwin.dap.middleware.iam.domain.policy.CopyPermissionVO;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Policy;
import com.digiwin.dap.middleware.iam.entity.PolicyConditionValue;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCalcService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyConditionValueCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCopyService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyHandleService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyTargetService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PolicyCopyServiceImpl
implements PolicyCopyService {
    private static final long TENANT_SID = 3L;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private PolicyCrudService policyCrudService;
    @Autowired
    private PolicyCalcService policyCalcService;
    @Autowired
    private PolicyTargetService policyTargetService;
    @Autowired
    private PolicyHandleService policyHandleService;
    @Autowired
    private PolicyConditionValueCrudService policyConditionValueCrudService;

    @Override
    public void copyPolicy(long tenantSid, CopyPermissionVO copyInfo) {
        ArrayList<Long> targetOrgSids = new ArrayList<Long>();
        ArrayList<Long> targetRoleSids = new ArrayList<Long>();
        for (CopyPermissionDataVO targetInfo : copyInfo.getTargets()) {
            if (TargetType.role.name().equals(targetInfo.getType())) {
                targetRoleSids.add(targetInfo.getSid());
            }
            if (!TargetType.org.name().equals(targetInfo.getType())) continue;
            targetOrgSids.add(targetInfo.getSid());
        }
        CopyPermissionDataVO sourceInfo = copyInfo.getSource();
        Long sourceTargetSid = sourceInfo.getSid();
        String sourceType = sourceInfo.getType();
        ArrayList<Policy> sourcePolicies = new ArrayList<Policy>();
        if (TargetType.role.name().equals(sourceType)) {
            targetRoleSids.remove(sourceTargetSid);
            List<Policy> sourceRolePolicies = this.policyCrudService.findPolicy(tenantSid, (long)sourceTargetSid, TargetType.role);
            sourcePolicies.addAll(sourceRolePolicies);
        } else if (TargetType.org.name().equals(sourceType)) {
            targetOrgSids.remove(sourceTargetSid);
            List<Policy> sourceOrgPolicies = this.policyCrudService.findPolicy(tenantSid, (long)sourceTargetSid, TargetType.org);
            sourcePolicies.addAll(sourceOrgPolicies);
        }
        for (Policy sourcePolicy : sourcePolicies) {
            Policy policy;
            List<Long> sourceActionSids = this.policyCalcService.getPolicyAction(tenantSid, sourceType, sourceTargetSid, sourcePolicy.getSysSid());
            for (Long targetOrgSid : targetOrgSids) {
                policy = this.policyHandleService.savePolicy(tenantSid, sourcePolicy.getSysSid(), targetOrgSid, TargetType.org.name());
                this.policyHandleService.updateStatement(policy, Collections.emptyList(), sourceActionSids, true, "");
                this.copyConditionValueFull(sourcePolicy.getSid(), policy.getSid());
            }
            for (Long targetRoleSid : targetRoleSids) {
                policy = this.policyHandleService.savePolicy(tenantSid, sourcePolicy.getSysSid(), targetRoleSid, TargetType.role.name());
                this.policyHandleService.updateStatement(policy, Collections.emptyList(), sourceActionSids, true, "");
                this.copyConditionValueFull(sourcePolicy.getSid(), policy.getSid());
            }
        }
    }

    @Override
    public void copyPolicy(long tenantSid, String sysId, String roleId) {
        long sysSid = this.sysCrudService.getSidById(sysId);
        if (sysSid == 0L) {
            return;
        }
        long sourceRoleSid = this.policyTargetService.getTargetSid(3L, roleId, TargetType.role.name());
        if (sourceRoleSid == 0L) {
            return;
        }
        long targetRoleSid = this.policyTargetService.getTargetSid(tenantSid, roleId, TargetType.role.name());
        if (targetRoleSid == 0L) {
            return;
        }
        this.copyPolicy(3L, sourceRoleSid, TargetType.role.name(), sysSid, tenantSid, targetRoleSid, TargetType.role.name());
    }

    @Override
    public void copyPolicy(long sourceTenantSid, long targetTenantSid, Map<Long, Org> orgMap, Map<Long, Role> roleMap, Map<Long, User> userMap) {
        List<Policy> sourcePolicies = this.policyCrudService.findPolicy(sourceTenantSid);
        for (Policy source : sourcePolicies) {
            Org org;
            Policy policy = new Policy();
            if (TargetType.user.name().equals(source.getType())) {
                User user = userMap.get(source.getTargetSid());
                if (user != null) {
                    policy.setTargetSid(user.getSid());
                    policy.setType(TargetType.user.name());
                }
            } else if (TargetType.role.name().equals(source.getType())) {
                Role role = roleMap.get(source.getTargetSid());
                if (role != null) {
                    policy.setTargetSid(role.getSid());
                    policy.setType(TargetType.role.name());
                }
            } else if (TargetType.org.name().equals(source.getType()) && (org = orgMap.get(source.getTargetSid())) != null) {
                policy.setTargetSid(org.getSid());
                policy.setType(TargetType.org.name());
            }
            if (policy.getTargetSid() <= 0L || !StringUtils.hasText((String)source.getStatementValue())) continue;
            policy.setTenantSid(targetTenantSid);
            policy.setId(source.getId());
            policy.setName(source.getName());
            policy.setSysSid(source.getSysSid());
            policy.setStatementValue(source.getStatementValue());
            this.policyCrudService.create((BaseEntity)policy);
            this.copyConditionValueFull(source.getSid(), policy.getSid());
        }
    }

    private void copyPolicy(long sourceTenantSid, long sourceTargetSid, String sourceTargetType, long sysSid, long targetTenantSid, long targetTargetSid, String targetTargetType) {
        Policy sourcePolicy = this.policyCrudService.findPolicy(sourceTenantSid, sysSid, sourceTargetSid, sourceTargetType);
        if (sourcePolicy != null) {
            Policy targetPolicy = this.policyHandleService.savePolicy(targetTenantSid, sysSid, targetTargetSid, targetTargetType);
            this.policyCrudService.updatePolicy(targetPolicy.getSid(), targetPolicy.getTenantSid(), sourcePolicy.getStatementValue());
            this.copyConditionValueIncr(sourcePolicy.getSid(), targetPolicy.getSid());
        }
    }

    private void copyConditionValueFull(long sourcePolicySid, long targetPolicySid) {
        this.policyConditionValueCrudService.deleteByPolicySid(targetPolicySid);
        List<PolicyConditionValue> sourceCvs = this.policyConditionValueCrudService.findByPolicySid(sourcePolicySid);
        ArrayList<PolicyConditionValue> targetCvs = new ArrayList<PolicyConditionValue>();
        for (PolicyConditionValue sourceCv : sourceCvs) {
            PolicyConditionValue targetCv = new PolicyConditionValue();
            targetCv.setPolicySid(targetPolicySid);
            targetCv.setActionSid(sourceCv.getActionSid());
            targetCv.setConditionValue(sourceCv.getConditionValue());
            targetCvs.add(targetCv);
        }
        this.policyConditionValueCrudService.insertAll(targetCvs);
    }

    private void copyConditionValueIncr(long sourcePolicySid, long targetPolicySid) {
        List<PolicyConditionValue> sourceCvs = this.policyConditionValueCrudService.findByPolicySid(sourcePolicySid);
        ArrayList<PolicyConditionValue> targetCvs = new ArrayList<PolicyConditionValue>();
        for (PolicyConditionValue sourceCv : sourceCvs) {
            if (this.policyConditionValueCrudService.existsByUnionKey(new Object[]{targetPolicySid, sourceCv.getActionSid()})) continue;
            PolicyConditionValue targetCv = new PolicyConditionValue();
            targetCv.setPolicySid(targetPolicySid);
            targetCv.setActionSid(sourceCv.getActionSid());
            targetCv.setConditionValue(sourceCv.getConditionValue());
            targetCvs.add(targetCv);
        }
        this.policyConditionValueCrudService.insertAll(targetCvs);
    }
}

