/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.policy.impl;

import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.entity.Policy;
import com.digiwin.dap.middleware.iam.repository.PolicyRepository;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityWithPartitionManagerService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PolicyCrudServiceImpl
extends BaseEntityWithPartitionManagerService<Policy>
implements PolicyCrudService {
    @Autowired
    private PolicyRepository policyRepository;

    protected PolicyRepository getRepository() {
        return this.policyRepository;
    }

    @Override
    public Policy findPolicy(long tenantSid, long sysSid, long targetSid, String targetType) {
        return this.policyRepository.findByTenantSidAndSysSidAndTargetSidAndType(tenantSid, sysSid, targetSid, targetType);
    }

    @Override
    public List<Policy> findPolicy(long tenantSid) {
        return this.policyRepository.findByTenantSid(tenantSid);
    }

    @Override
    public List<Policy> findPolicy(long tenantSid, long sysSid) {
        return this.policyRepository.findByTenantSidAndSysSid(tenantSid, sysSid);
    }

    @Override
    public List<Policy> findPolicy(long tenantSid, long sysSid, String targetType) {
        return this.policyRepository.findByTenantSidAndSysSidAndType(tenantSid, sysSid, targetType);
    }

    @Override
    public List<Policy> findPolicy(long tenantSid, long targetSid, TargetType targetType) {
        return this.policyRepository.findByTenantSidAndTargetSidAndType(tenantSid, targetSid, targetType.name());
    }

    @Override
    public List<Policy> findPolicy(long tenantSid, long sysSid, List<Long> targetSids, String targetType) {
        return this.policyRepository.findByTenantSidAndSysSidAndTargetSidInAndType(tenantSid, sysSid, targetSids, targetType);
    }

    @Override
    public void deletePolicy(long targetSid, String targetType) {
        this.policyRepository.removeByTargetSidAndType(targetSid, targetType);
    }

    @Override
    public void deletePolicy(long tenantSid, long targetSid, String targetType) {
        this.policyRepository.removeByTenantSidAndTargetSidAndType(tenantSid, targetSid, targetType);
    }

    @Override
    public void updatePolicy(long sid, long tenantSid, String statementValue) {
        this.policyRepository.updatePolicy(sid, tenantSid, statementValue);
    }

    @Override
    public void batchUpdatePolicy(List<Policy> policies) {
        for (Policy policy : policies) {
            this.policyRepository.updatePolicy(policy.getSid(), policy.getTenantSid(), policy.getStatementValue());
        }
    }
}

