/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.policy.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.permission.v2.MenuType;
import com.digiwin.dap.middleware.iam.domain.permission.v2.StatementInfo;
import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.domain.policy.AttachedVO;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyAttachedRole;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyAttachedUser;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyTargetAction;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyTargetCondition;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyTargetVO;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetCondition;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetPolicy;
import com.digiwin.dap.middleware.iam.entity.Condition;
import com.digiwin.dap.middleware.iam.entity.Policy;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ConditionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ModuleCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyHandleOldService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyHandleService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyTargetService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PolicyHandleOldServiceImpl
implements PolicyHandleOldService {
    private static final Logger logger = LoggerFactory.getLogger(PolicyHandleOldServiceImpl.class);
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private ActionCrudService actionCrudService;
    @Autowired
    private ModuleCrudService moduleCrudService;
    @Autowired
    private PolicyCrudService policyCrudService;
    @Autowired
    private PolicyTargetService policyTargetService;
    @Autowired
    private PolicyHandleService policyHandleService;
    @Autowired
    private ConditionCrudService conditionCrudService;

    @Override
    public PolicyTargetVO getPolicyBySid(long policySid) {
        Policy policy = (Policy)this.policyCrudService.findBySid(policySid);
        PolicyTargetVO policyTarget = new PolicyTargetVO();
        if (policy == null) {
            return policyTarget;
        }
        policyTarget.setSid(policy.getSid());
        policyTarget.setId(policy.getId());
        policyTarget.setTargets(this.getTargets(policy.getStatementValue()));
        policyTarget.setTenantSid(policy.getTenantSid());
        return policyTarget;
    }

    @Override
    public PolicyTargetVO getPolicyByUserId(long tenantSid, long sysSid, long userSid) {
        Policy policy = this.policyCrudService.findPolicy(tenantSid, sysSid, userSid, TargetType.user.name());
        return this.getPolicyBySid(policy == null ? 0L : policy.getSid());
    }

    @Override
    public PolicyTargetVO getPolicyByRoleId(long tenantSid, long sysSid, long roleSid) {
        Policy policy = this.policyCrudService.findPolicy(tenantSid, sysSid, roleSid, TargetType.role.name());
        return this.getPolicyBySid(policy == null ? 0L : policy.getSid());
    }

    private List<PolicyTargetAction> getTargets(String statementValue) {
        Map<MenuType, List<Long>> statementMap = StatementInfo.getMenuType(statementValue);
        List<Long> actionSids = statementMap.get((Object)MenuType.action);
        ArrayList<PolicyTargetAction> targets = new ArrayList<PolicyTargetAction>(this.policyTargetService.getAction(actionSids));
        List<Long> moduleSids = statementMap.get((Object)MenuType.module);
        targets.addAll(this.policyTargetService.getModule(moduleSids));
        return targets;
    }

    @Override
    public List<PolicyAttachedUser> getUsersByAction(long tenantSid, long sysSid, PolicyTargetAction target) {
        List<Long> userSids = this.getTargetSids(tenantSid, sysSid, target, TargetType.user);
        return this.policyTargetService.findUsers(userSids);
    }

    @Override
    public List<PolicyAttachedRole> getRolesByAction(long tenantSid, long sysSid, PolicyTargetAction target) {
        List<Long> roleSids = this.getTargetSids(tenantSid, sysSid, target, TargetType.role);
        return this.policyTargetService.findRoles(tenantSid, roleSids);
    }

    private List<Long> getTargetSids(long tenantSid, long sysSid, PolicyTargetAction target, TargetType targetType) {
        long actionSid = 0L;
        long moduleSid = this.moduleCrudService.getSidByUnionKey(new Object[]{target.getModuleId(), sysSid});
        if (!StringUtils.isEmpty((Object)target.getActionId())) {
            target.setTenantSid(target.getSelf() != false ? tenantSid : 0L);
            actionSid = this.actionCrudService.getSidByUnionKey(new Object[]{target.getActionId(), moduleSid, target.getTenantSid()});
        }
        List<Policy> policies = this.policyCrudService.findPolicy(tenantSid, sysSid, targetType.name());
        ArrayList<Long> targetSids = new ArrayList<Long>();
        for (Policy policy : policies) {
            List<Long> actionSids = StatementInfo.getAllowMenuSids(policy.getStatementValue());
            if (!actionSids.contains(actionSid)) continue;
            targetSids.add(policy.getTargetSid());
        }
        return targetSids;
    }

    @Override
    public void updatePolicyTarget(long tenantSid, long sysSid, String sysId, PolicyTargetVO targetVO) {
        AttachedVO attachment = targetVO.getAttachment();
        if (TargetType.user.name().equals(attachment.getType())) {
            long targetSid = this.userCrudService.getSidById(attachment.getId());
            if (targetSid == 0L) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_21001, new Object[]{attachment.getId()});
            }
            attachment.setSid(targetSid);
        } else if (TargetType.role.name().equals(attachment.getType())) {
            long targetSid = this.roleCrudService.getSidByTenantAndId(tenantSid, attachment.getId());
            if (targetSid == 0L) {
                throw new BusinessException((ErrorHandler)I18nError.ASSOCIATION_NOT_EXISTED, new Object[]{attachment.getId(), tenantSid});
            }
            attachment.setSid(targetSid);
        }
        this.savePolicyStatement(tenantSid, sysSid, attachment.getSid(), attachment.getType(), targetVO, 0);
    }

    @Override
    public void updatePolicyTargetBatch(long tenantSid, long sysSid, String sysId, PolicyTargetVO targetVO) {
        for (AttachedVO attachment : targetVO.getUsers()) {
            long targetSid;
            if (TargetType.user.name().equals(attachment.getType())) {
                targetSid = this.userCrudService.getSidById(attachment.getId());
                attachment.setSid(targetSid);
            } else if (TargetType.role.name().equals(attachment.getType())) {
                targetSid = this.roleCrudService.getSidByTenantAndId(tenantSid, attachment.getId());
                attachment.setSid(targetSid);
            }
            if (attachment.getSid() <= 0L) continue;
            this.savePolicyStatement(tenantSid, sysSid, attachment.getSid(), attachment.getType(), targetVO, 1);
        }
    }

    @Override
    public void savePolicyStatement(long tenantSid, long sysSid, long targetSid, String targetType, PolicyTargetVO input, Integer mode) {
        ArrayList<Long> moduleSids = new ArrayList<Long>();
        ArrayList<Long> actionSids = new ArrayList<Long>();
        for (PolicyTargetAction target : input.getTargets()) {
            long moduleSid = this.moduleCrudService.getSidByUnionKey(new Object[]{target.getModuleId(), sysSid});
            if (StringUtils.isEmpty((Object)target.getActionId())) {
                moduleSids.add(moduleSid);
                continue;
            }
            target.setTenantSid(target.getSelf() != false ? tenantSid : 0L);
            long actionSid = this.actionCrudService.getSidByUnionKey(new Object[]{target.getActionId(), moduleSid, target.getTenantSid()});
            target.setActionSid(actionSid);
            actionSids.add(actionSid);
        }
        Policy policy = this.policyHandleService.savePolicy(tenantSid, sysSid, targetSid, targetType);
        if (mode == 0) {
            policy.setStatementValue("");
        }
        this.policyHandleService.updateStatement(policy, moduleSids, actionSids, true, policy.getStatementValue());
        for (PolicyTargetAction action : input.getTargets()) {
            if (action.getConditions().isEmpty()) continue;
            List<Condition> defaultConditions = this.conditionCrudService.findByActionSid(action.getActionSid());
            Map<String, String> conditionMap = action.getConditions().stream().collect(Collectors.toMap(PolicyTargetCondition::getId, PolicyTargetCondition::getValue));
            TargetPolicy targetPolicy = new TargetPolicy();
            targetPolicy.setTenantSid(tenantSid);
            targetPolicy.setSysSid(sysSid);
            targetPolicy.setTargetSid(targetSid);
            targetPolicy.setType(targetType);
            targetPolicy.setActionSid(action.getActionSid());
            for (Condition condition : defaultConditions) {
                TargetCondition conditionValue = new TargetCondition();
                conditionValue.setSid(condition.getSid());
                conditionValue.setKey(condition.getKey());
                conditionValue.setValue(conditionMap.getOrDefault(condition.getKey(), condition.getDefaultValue()));
                targetPolicy.getConditionValue().add(conditionValue);
            }
            this.policyHandleService.saveConditionValue(policy.getSid(), targetPolicy);
        }
    }
}

