/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.policy.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.constant.enums.ConditionValueEnum;
import com.digiwin.dap.middleware.iam.domain.permission.v2.MenuType;
import com.digiwin.dap.middleware.iam.domain.permission.v2.StatementInfo;
import com.digiwin.dap.middleware.iam.domain.permission.v2.StatementType;
import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.domain.policy.BatchSaveTargetPolicyRequestVO;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetAction;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetCondition;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetPolicy;
import com.digiwin.dap.middleware.iam.entity.Action;
import com.digiwin.dap.middleware.iam.entity.Condition;
import com.digiwin.dap.middleware.iam.entity.Policy;
import com.digiwin.dap.middleware.iam.entity.PolicyConditionValue;
import com.digiwin.dap.middleware.iam.mapper.PermissionMapper;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ConditionCrudService;
import com.digiwin.dap.middleware.iam.service.permission.AuthCalcService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCalcService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyConditionValueCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyHandleService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyTargetService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PolicyHandleServiceImpl
implements PolicyHandleService {
    private static final Logger logger = LoggerFactory.getLogger(PolicyHandleServiceImpl.class);
    @Autowired
    private PolicyCalcService policyCalcService;
    @Autowired
    private PolicyCrudService policyCrudService;
    @Autowired
    private ActionCrudService actionCrudService;
    @Autowired
    private PolicyTargetService policyTargetService;
    @Autowired
    private ConditionCrudService conditionCrudService;
    @Autowired
    private PolicyConditionValueCrudService policyConditionValueCrudService;
    @Autowired
    private PermissionMapper permissionMapper;
    @Autowired
    private AuthCalcService authCalcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(long tenantSid, TargetPolicy targetPolicy) {
        if (targetPolicy.getMenuSid() == null) {
            return;
        }
        long sysSid = targetPolicy.getSysSid();
        long targetSid = targetPolicy.getTargetSid();
        String targetType = targetPolicy.getType();
        MenuType menuType = targetPolicy.getMenuType();
        Boolean effect = targetPolicy.getEffect();
        ArrayList<Long> moduleSids = new ArrayList<Long>();
        ArrayList<Long> actionSids = new ArrayList<Long>();
        if (menuType == MenuType.module) {
            moduleSids.add(targetPolicy.getModuleSid());
            actionSids.addAll(this.actionCrudService.getActionSidsByModuleSid(tenantSid, targetPolicy.getModuleSid()));
        } else {
            Action action = (Action)this.actionCrudService.findBySid(targetPolicy.getActionSid());
            if (action == null) {
                return;
            }
            actionSids.add(action.getSid());
            actionSids.addAll(this.actionCrudService.getActionSidsByUri(tenantSid, action.getUri()));
            if (effect != null && effect.booleanValue()) {
                moduleSids.add(action.getModuleSid());
                this.tickUpAction(action.getParentSid(), actionSids);
            }
        }
        Policy policy = this.savePolicy(tenantSid, sysSid, targetSid, targetType);
        this.updateStatement(policy, moduleSids, actionSids, effect, policy.getStatementValue());
        if (TargetType.org.name().equals(targetType)) {
            List<Long> roleSids;
            List<Long> orgSids;
            ArrayList<Long> directModuleSids = new ArrayList<Long>();
            if (menuType == MenuType.module) {
                directModuleSids.add(targetPolicy.getModuleSid());
            }
            if ((orgSids = this.policyTargetService.getChildSidsByOrgSid(tenantSid, targetSid, TargetType.org.name())).size() > 0) {
                List<Policy> orgPolicies = this.policyCrudService.findPolicy(tenantSid, sysSid, orgSids, TargetType.org.name());
                for (Policy orgPolicy : orgPolicies) {
                    orgPolicy.setStatementValue(this.handleStatement(directModuleSids, actionSids, null, orgPolicy.getStatementValue()));
                }
                this.policyCrudService.batchUpdatePolicy(orgPolicies);
            }
            if ((roleSids = this.policyTargetService.getChildSidsByOrgSid(tenantSid, targetSid, TargetType.role.name())).size() > 0) {
                List<Policy> rolePolicies = this.policyCrudService.findPolicy(tenantSid, sysSid, roleSids, TargetType.role.name());
                for (Policy rolePolicy : rolePolicies) {
                    rolePolicy.setStatementValue(this.handleStatement(directModuleSids, actionSids, null, rolePolicy.getStatementValue()));
                }
                this.policyCrudService.batchUpdatePolicy(rolePolicies);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdate(BatchSaveTargetPolicyRequestVO input) {
        long tenantSid = input.getTenantSid();
        long sysSid = input.getSysSid();
        long targetSid = input.getTargetSid();
        String targetType = input.getType();
        List<TargetPolicy> targets = input.getTargets();
        Map<Boolean, List<TargetPolicy>> groupedByEffect = targets.stream().filter(a -> a.getEffect() != null).collect(Collectors.groupingBy(TargetPolicy::getEffect));
        Policy policy = this.savePolicy(tenantSid, sysSid, targetSid, targetType);
        policy.setStatementValue("");
        ArrayList<Policy> changedPolicies = new ArrayList<Policy>();
        changedPolicies.add(policy);
        for (Map.Entry<Boolean, List<TargetPolicy>> entry : groupedByEffect.entrySet()) {
            Boolean effect = entry.getKey();
            List<Long> moduleSids = entry.getValue().stream().filter(a -> a.getActionSid() == null).map(TargetPolicy::getModuleSid).collect(Collectors.toList());
            List<Long> actionSids = entry.getValue().stream().filter(a -> a.getModuleSid() == null).map(TargetPolicy::getActionSid).collect(Collectors.toList());
            policy.setStatementValue(this.handleStatement(moduleSids, actionSids, effect, policy.getStatementValue()));
            if (!TargetType.org.name().equals(targetType)) continue;
            changedPolicies.addAll(this.emptyChildrenStatement(tenantSid, targetSid, TargetType.org.name(), sysSid, moduleSids, actionSids));
            changedPolicies.addAll(this.emptyChildrenStatement(tenantSid, targetSid, TargetType.role.name(), sysSid, moduleSids, actionSids));
        }
        this.policyCrudService.batchUpdatePolicy(changedPolicies);
    }

    private List<Policy> emptyChildrenStatement(long tenantSid, long targetSid, String targetType, long sysSid, List<Long> moduleSids, List<Long> actionSids) {
        ArrayList<Policy> changed = new ArrayList<Policy>();
        List<Long> childrenSids = this.policyTargetService.getChildSidsByOrgSid(tenantSid, targetSid, targetType);
        if (!childrenSids.isEmpty()) {
            List<Policy> childrenPolicies = this.policyCrudService.findPolicy(tenantSid, sysSid, childrenSids, targetType);
            for (Policy policy : childrenPolicies) {
                policy.setStatementValue(this.handleStatement(moduleSids, actionSids, null, policy.getStatementValue()));
            }
            changed.addAll(childrenPolicies);
        }
        return changed;
    }

    @Override
    public void delete(long tenantSid, long sysSid, long targetSid, String targetType) {
        Policy policy = this.policyCrudService.findPolicy(tenantSid, sysSid, targetSid, targetType);
        if (policy != null) {
            this.policyCrudService.deleteBySidAndTenantSid(policy.getSid(), policy.getTenantSid());
            this.policyConditionValueCrudService.deleteByPolicySid(policy.getSid());
        }
    }

    @Override
    public List<Long> getPolicyAllowActionActual(long tenantSid, long sysSid, long targetSid, String targetType) {
        Policy policy = this.policyCrudService.findPolicy(tenantSid, sysSid, targetSid, targetType);
        if (policy != null) {
            return StatementInfo.getAllowMenuSids(policy.getStatementValue());
        }
        return Collections.emptyList();
    }

    @Override
    public Map<Long, String> getPolicyActionActual(long tenantSid, long sysSid, long targetSid, String targetType) {
        Policy policy = this.policyCrudService.findPolicy(tenantSid, sysSid, targetSid, targetType);
        if (policy != null) {
            return StatementInfo.getMenuEffect(policy.getStatementValue());
        }
        return Collections.emptyMap();
    }

    @Override
    public List<Long> getPolicyActionAndModule(long tenantSid, long sysSid, long targetSid, String targetType) {
        List<Long> actions = this.policyCalcService.getPolicyAction(tenantSid, targetType, targetSid, sysSid);
        Policy policy = this.policyCrudService.findPolicy(tenantSid, sysSid, targetSid, targetType);
        if (policy != null) {
            actions.addAll(StatementInfo.getAllowModuleSids(policy.getStatementValue()));
        }
        return actions;
    }

    @Override
    public List<Long> getPolicyActionExcluded(Long tenantSid, Long sysSid, Long targetSid, String type) {
        return this.policyCalcService.getPolicyActionExcluded(tenantSid, type, targetSid, sysSid);
    }

    private void tickUpAction(long parentSid, List<Long> actionSids) {
        if (parentSid > 0L) {
            actionSids.add(parentSid);
            Action pAction = (Action)this.actionCrudService.findBySid(parentSid);
            this.tickUpAction(pAction.getParentSid(), actionSids);
        }
    }

    @Override
    public Policy savePolicy(long tenantSid, long sysSid, long targetSid, String targetType) {
        return this.savePolicy(tenantSid, sysSid, targetSid, targetType, "");
    }

    @Override
    public Policy savePolicy(long tenantSid, long sysSid, long targetSid, String targetType, String statementValue) {
        Policy policy = this.policyCrudService.findPolicy(tenantSid, sysSid, targetSid, targetType);
        if (policy == null) {
            String sysId = this.policyTargetService.getTargetId(tenantSid, sysSid, "sys");
            String targetId = this.policyTargetService.getTargetId(tenantSid, targetSid, targetType);
            String policyId = Policy.buildId(targetType, targetId, sysId);
            policy = new Policy();
            policy.setTenantSid(tenantSid);
            policy.setId(policyId);
            policy.setName(policyId);
            policy.setSysSid(sysSid);
            policy.setTargetSid(targetSid);
            policy.setType(targetType);
            policy.setStatementValue(statementValue);
            this.policyCrudService.create((BaseEntity)policy);
        }
        return policy;
    }

    @Override
    public void updateStatement(Policy policy, List<Long> moduleSids, List<Long> actionSids, Boolean effect, String oldStatementValue) {
        String statement = this.handleStatement(moduleSids, actionSids, effect, oldStatementValue);
        this.policyCrudService.updatePolicy(policy.getSid(), policy.getTenantSid(), statement);
    }

    private String handleStatement(List<Long> moduleSids, List<Long> actionSids, Boolean effect, String statementValue) {
        Map<Long, Integer> menuEffectMap = StatementInfo.getStatementType(statementValue);
        for (Long moduleSid : moduleSids) {
            if (effect == null) {
                menuEffectMap.remove(moduleSid);
                continue;
            }
            menuEffectMap.put(moduleSid, StatementType.valueOf(MenuType.module, effect).ordinal());
        }
        for (Long childAction : actionSids) {
            if (effect == null) {
                menuEffectMap.remove(childAction);
                continue;
            }
            menuEffectMap.put(childAction, StatementType.valueOf(MenuType.action, effect).ordinal());
        }
        if (menuEffectMap.size() == 1 && menuEffectMap.values().stream().anyMatch(p -> p > 1)) {
            return "";
        }
        return StatementInfo.getStatementValue(menuEffectMap);
    }

    @Override
    public void saveConditionValue(long policySid, TargetPolicy targetPolicy) {
        PolicyConditionValue conditionValue = (PolicyConditionValue)this.policyConditionValueCrudService.findByUnionKey(new Object[]{policySid, targetPolicy.getActionSid()});
        if (conditionValue == null) {
            conditionValue = new PolicyConditionValue();
            conditionValue.setPolicySid(policySid);
            conditionValue.setActionSid(targetPolicy.getActionSid());
            conditionValue.setConditionValue(targetPolicy.getValue());
            this.policyConditionValueCrudService.create(conditionValue);
        } else {
            conditionValue.setConditionValue(targetPolicy.getValue());
            this.policyConditionValueCrudService.update(conditionValue);
        }
    }

    @Override
    public List<TargetCondition> queryConditionValueActual(TargetPolicy targetPolicy) {
        Policy policy = this.policyCrudService.findPolicy((long)targetPolicy.getTenantSid(), (long)targetPolicy.getSysSid(), targetPolicy.getTargetSid(), targetPolicy.getType());
        if (policy != null) {
            PolicyConditionValue policyCv = this.policyConditionValueCrudService.findByPolicySidAndActionSid(policy.getSid(), targetPolicy.getActionSid());
            return TargetPolicy.getValues(policyCv == null ? null : policyCv.getConditionValue());
        }
        return Collections.emptyList();
    }

    @Override
    public TargetPolicy queryConditionValue(TargetPolicy targetPolicy) {
        boolean superAdmin = this.policyTargetService.isSuperAdmin(targetPolicy.getTenantSid(), targetPolicy.getTargetSid(), targetPolicy.getType());
        if (superAdmin) {
            List<Condition> defaultConditions = this.conditionCrudService.findByActionSid(targetPolicy.getActionSid());
            defaultConditions.stream().filter(condition -> !"".equals(condition.getTypeParameter())).forEach(condition -> {
                TargetCondition targetCondition = new TargetCondition();
                targetCondition.setSid(condition.getSid());
                targetCondition.setKey(condition.getKey());
                targetCondition.setValue(ConditionValueEnum.max(condition.getTypeParameter()));
                targetPolicy.getConditionValue().add(targetCondition);
            });
        } else {
            Policy policy = this.policyCrudService.findPolicy((long)targetPolicy.getTenantSid(), (long)targetPolicy.getSysSid(), targetPolicy.getTargetSid(), targetPolicy.getType());
            if (policy != null) {
                PolicyConditionValue policyCv = this.policyConditionValueCrudService.findByPolicySidAndActionSid(policy.getSid(), targetPolicy.getActionSid());
                targetPolicy.setConditionValue(TargetPolicy.getValues(policyCv == null ? null : policyCv.getConditionValue()));
            }
        }
        return targetPolicy;
    }

    @Override
    public TargetPolicy queryMergeConditionValue(TargetPolicy targetPolicy) {
        boolean superAdmin = this.policyTargetService.isSuperAdmin(targetPolicy.getTenantSid(), targetPolicy.getTargetSid(), targetPolicy.getType());
        if (superAdmin) {
            List<Condition> defaultConditions = this.conditionCrudService.findByActionSid(targetPolicy.getActionSid());
            defaultConditions.stream().filter(condition -> !"".equals(condition.getTypeParameter())).forEach(condition -> {
                TargetCondition targetCondition = new TargetCondition();
                targetCondition.setSid(condition.getSid());
                targetCondition.setKey(condition.getKey());
                targetCondition.setValue(ConditionValueEnum.max(condition.getTypeParameter()));
                targetPolicy.getConditionValue().add(targetCondition);
            });
        } else {
            List<TargetAction> targetConditions = this.authCalcService.getActionCondition(targetPolicy.getTenantSid(), targetPolicy.getSysSid(), targetPolicy.getType(), targetPolicy.getTargetSid(), targetPolicy.getActionSid());
            targetPolicy.getConditionValue().addAll(targetConditions.stream().map(TargetAction::getConditions).flatMap(Collection::stream).collect(Collectors.toList()));
        }
        return targetPolicy;
    }
}

