/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.policy.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyAttachedRole;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyAttachedUser;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyTargetAction;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.PolicyMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.repository.OrgRepository;
import com.digiwin.dap.middleware.iam.repository.RoleRepository;
import com.digiwin.dap.middleware.iam.repository.SysRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyTargetService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PolicyTargetServiceImpl
implements PolicyTargetService {
    private static final Logger logger = LoggerFactory.getLogger(PolicyTargetServiceImpl.class);
    @Autowired
    private PolicyMapper policyMapper;
    @Autowired
    private SysRepository sysRepository;
    @Autowired
    private OrgRepository orgRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private UserInRoleMapper userInRoleMapper;

    @Override
    public long getTargetSid(long tenantSid, String targetId, String targetType) {
        try {
            if ("sys".equals(targetType)) {
                return ((Sys)this.sysRepository.findById(targetId)).getSid();
            }
            if (TargetType.user.name().equals(targetType)) {
                return ((User)this.userRepository.findById(targetId)).getSid();
            }
            if (TargetType.role.name().equals(targetType)) {
                return this.roleRepository.findByTenantSidAndId(tenantSid, targetId).getSid();
            }
            if (TargetType.org.name().equals(targetType)) {
                return 0L;
            }
        }
        catch (Exception ignored) {
            logger.error(String.format("[%s]\u76ee\u6807[%s]\u4e0d\u5b58\u5728", targetType, targetId));
        }
        return 0L;
    }

    @Override
    public String getTargetId(long tenantSid, long targetSid, String targetType) {
        try {
            logger.error("\u521d\u59cb\u5316\u89d2\u8272\u95ee\u9898\u6392\u67e5:{}/{}/{}", new Object[]{tenantSid, targetSid, targetType});
            if ("sys".equals(targetType)) {
                logger.error("\u521d\u59cb\u5316\u89d2\u8272\u95ee\u9898\u6392\u67e5-sys:{}/{}/{}", new Object[]{tenantSid, targetSid, targetType});
                Sys sys = this.sysRepository.findById(targetSid).orElse(null);
                if (Objects.isNull((Object)sys)) {
                    throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED);
                }
                return sys.getId();
            }
            if (TargetType.user.name().equals(targetType)) {
                User user = this.userRepository.findById(targetSid).orElse(null);
                if (Objects.isNull((Object)user)) {
                    throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
                }
                return user.getId();
            }
            if (TargetType.role.name().equals(targetType)) {
                return this.roleRepository.findByTenantSidAndSid(tenantSid, targetSid).getId();
            }
            if (TargetType.org.name().equals(targetType)) {
                Org org = this.orgRepository.findById(targetSid).orElse(null);
                if (Objects.isNull((Object)org)) {
                    throw new BusinessException((ErrorHandler)I18nError.ORG_NOT_EXIST);
                }
                return org.getId();
            }
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u89d2\u8272\u95ee\u9898\u6392\u67e5-sys-error:{}/{}/{},{}", new Object[]{tenantSid, targetSid, targetType, e.getMessage(), e});
        }
        throw new BusinessException((ErrorHandler)I18nError.TARGET_NOT_EXIST, new Object[]{targetType, targetSid});
    }

    @Override
    public boolean isSuperAdmin(long tenantSid, long targetSid, String targetType) {
        if (TargetType.user.name().equals(targetType)) {
            return this.userInRoleMapper.hasRole(tenantSid, targetSid, "superadmin");
        }
        if (TargetType.role.name().equals(targetType)) {
            Role role = this.roleCrudService.findByTenantSidAndSid(tenantSid, targetSid);
            return role != null && "superadmin".equals(role.getId());
        }
        return false;
    }

    @Override
    public List<Long> getChildSidsByOrgSid(long tenantSid, long orgSid, String targetType) {
        Org org = (Org)this.orgCrudService.findBySid(orgSid);
        if (org != null) {
            if (TargetType.org.name().equals(targetType)) {
                return this.orgCrudService.getOrgSidsByUri(tenantSid, org.getUri());
            }
            if (TargetType.role.name().equals(targetType)) {
                return this.roleCrudService.getRoleSidsByUri(tenantSid, org.getUri());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<PolicyAttachedUser> findUsers(List<Long> userSids) {
        return userSids.isEmpty() ? Collections.emptyList() : this.policyMapper.findUsers(userSids);
    }

    @Override
    public List<PolicyAttachedRole> findRoles(long tenantSid, List<Long> roleSids) {
        return roleSids.isEmpty() ? Collections.emptyList() : this.policyMapper.findRoles(tenantSid, roleSids);
    }

    @Override
    public List<PolicyTargetAction> getAction(List<Long> actionSids) {
        return actionSids == null || actionSids.isEmpty() ? Collections.emptyList() : this.policyMapper.getAction(actionSids);
    }

    @Override
    public List<PolicyTargetAction> getModule(List<Long> moduleSids) {
        return moduleSids == null || moduleSids.isEmpty() ? Collections.emptyList() : this.policyMapper.getModule(moduleSids);
    }
}

