/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.role.impl;

import cn.hutool.core.io.IoUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.mapper.RoleMapper;
import com.digiwin.dap.middleware.iam.service.role.ExportRoleService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.util.excelUtil.DWExcelBuilder;
import com.digiwin.dap.middleware.iam.util.excelUtil.DWExcelSheetSetting;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportRoleServiceImpl
implements ExportRoleService {
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private RoleMapper roleMapper;

    @Override
    public byte[] getRoleFileByte(long tenantSid) {
        byte[] bytes;
        if (!this.tenantCrudService.exists(tenantSid)) {
            throw new BusinessException((ErrorHandler)I18nError.TARGET_NOT_EXIST, new Object[]{tenantSid});
        }
        Workbook workbook = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            List<Map<String, Object>> mapList = this.roleMapper.findRoleForEcportByTenantSid(tenantSid);
            DWExcelBuilder excelBuilder = new DWExcelBuilder();
            DWExcelSheetSetting sheetSetting = excelBuilder.addSheet("role");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ROLE_ID.getCode()).setDataMappingKey("id");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ROLE_NAME.getCode()).setDataMappingKey("name");
            sheetSetting.addColumnByModuleI18nKey(I18nCode.EXCEL_ROLE_REMARK.getCode()).setDataMappingKey("remark");
            sheetSetting.setDatas(mapList);
            workbook = excelBuilder.create();
            workbook.write((OutputStream)bos);
            bytes = bos.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
            }
            catch (Throwable throwable) {
                IoUtil.close(workbook);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)workbook);
        return bytes;
    }
}

