/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.role.impl;

import com.digiwin.dap.middleware.iam.domain.role.RoleCatalogQueryResuleVO;
import com.digiwin.dap.middleware.iam.domain.role.RoleCatalogResultVO;
import com.digiwin.dap.middleware.iam.domain.role.RoleQueryResultVO;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.mapper.RoleCatalogMapper;
import com.digiwin.dap.middleware.iam.mapper.RoleMapper;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogQueryService;
import com.digiwin.dap.middleware.language.service.LanguageService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class RoleCatalogQueryServiceImpl
implements RoleCatalogQueryService {
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private RoleCatalogMapper roleCatalogMapper;
    @Autowired
    private LanguageService languageService;

    @Override
    public List<RoleCatalogQueryResuleVO> getByTenantSid(long tenantSid) {
        List<RoleCatalogQueryResuleVO> roleCatalogQueryResuleVOS = this.roleCatalogMapper.findRoleCatalogByTenantSid(tenantSid);
        if (roleCatalogQueryResuleVOS.size() > 0) {
            for (RoleCatalogQueryResuleVO roleCatalogQueryResuleVO : roleCatalogQueryResuleVOS) {
                String canUpdateProvider = roleCatalogQueryResuleVO.getCanUpdateProviders();
                String editedRoles = roleCatalogQueryResuleVO.getEditedRole();
                this.buildRoleCatalogResultVO(roleCatalogQueryResuleVO, canUpdateProvider, editedRoles);
            }
        }
        return roleCatalogQueryResuleVOS;
    }

    @Override
    public RoleCatalogResultVO getRoleCatalogResultVO(long tenantSid) {
        RoleCatalogResultVO roleCatalogResultVO = new RoleCatalogResultVO();
        List<RoleCatalogQueryResuleVO> roleCatalogQueryResuleVOS = this.getByTenantSid(tenantSid);
        roleCatalogResultVO.setRoleCatalog(roleCatalogQueryResuleVOS);
        List<RoleQueryResultVO> roleQueryResultVOS = this.roleMapper.findRoleQueryResultVOByTenantSid(tenantSid);
        this.languageService.parse(roleQueryResultVOS, Collections.singletonMap("name", "roleName"), RoleQueryResultVO.class, Role.class);
        roleCatalogResultVO.setRole(roleQueryResultVOS);
        return roleCatalogResultVO;
    }

    private void buildRoleCatalogResultVO(RoleCatalogQueryResuleVO roleCatalogQueryResuleVO, String canUpdateProvider, String editedRoles) {
        if (!StringUtils.isEmpty((Object)canUpdateProvider) && !"[]".equals(canUpdateProvider)) {
            roleCatalogQueryResuleVO.setCanUpdateProvider((List)JsonUtils.jsonToObj((String)canUpdateProvider, ArrayList.class));
        }
        ArrayList<Long> roleSids = new ArrayList<Long>();
        if (!"[]".equals(editedRoles) && !StringUtils.isEmpty((Object)editedRoles)) {
            String[] roles;
            for (String sid : roles = editedRoles.substring(1, editedRoles.length() - 1).split(",")) {
                roleSids.add(Long.parseLong(sid));
            }
        }
        roleCatalogQueryResuleVO.setEditedRoles(roleSids);
    }
}

