/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.role.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.role.RoleCatalogVO;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.RoleCatalog;
import com.digiwin.dap.middleware.iam.repository.RoleRepository;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogService;
import com.digiwin.dap.middleware.iam.support.validate.RoleValidateService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoleCatalogServiceImpl
implements RoleCatalogService {
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private RoleCatalogCrudService roleCatalogCrudService;
    @Autowired
    private RoleValidateService roleValidateService;

    @Override
    public long addRoleCatalog(RoleCatalogVO roleCatalogVO, long tenantSid) {
        this.roleValidateService.check(tenantSid, roleCatalogVO);
        RoleCatalog catalog = new RoleCatalog();
        catalog.setTenantSid(tenantSid);
        catalog.setId(roleCatalogVO.getId());
        catalog.setName(roleCatalogVO.getName());
        catalog.setCanupdateProvider(JsonUtils.objToJson(roleCatalogVO.getCanUpdateProvider()));
        if (roleCatalogVO.getReadOnly() != null && roleCatalogVO.getReadOnly().booleanValue()) {
            catalog.setReadonly(roleCatalogVO.getReadOnly());
            catalog.setCanupdateProvider(JsonUtils.objToJson(roleCatalogVO.getCanUpdateProvider()));
            catalog.setMultiSelect(roleCatalogVO.getMultiSelect());
        }
        if (roleCatalogVO.getShared() != null && roleCatalogVO.getShared().booleanValue()) {
            catalog.setShared(roleCatalogVO.getShared());
            catalog.setEditedRoles(JsonUtils.objToJson(roleCatalogVO.getEditedRoles()));
        }
        return this.roleCatalogCrudService.create((BaseEntity)catalog);
    }

    @Override
    public void modifyRoleCatalog(RoleCatalogVO roleCatalogVO, long tenantSid) {
        this.roleValidateService.check2(roleCatalogVO);
        RoleCatalog roleCatalog = this.roleCatalogCrudService.findByTenantSidAndId(tenantSid, roleCatalogVO.getId());
        if (roleCatalog == null) {
            throw new BusinessException((ErrorHandler)I18nError.ROLE_CATALOG_NOT_EXISTED, new Object[]{roleCatalogVO.getSid()});
        }
        roleCatalog.setName(roleCatalogVO.getName());
        roleCatalog.setShared(roleCatalogVO.getShared());
        roleCatalog.setEditedRoles(JsonUtils.objToJson(roleCatalogVO.getEditedRoles()));
        this.roleCatalogCrudService.update((BaseEntity)roleCatalog);
    }

    @Override
    public void disableRoleCatalog(Long tenantSid, long roleCatalogSid) {
        RoleCatalog roleCatalog = this.roleCatalogCrudService.findByTenantSidAndSid(tenantSid, roleCatalogSid);
        if (roleCatalog == null) {
            throw new BusinessException((ErrorHandler)I18nError.ROLE_CATALOG_NOT_EXISTED, new Object[]{roleCatalogSid});
        }
        List<Role> roles = this.roleRepository.findByTenantSidAndRoleCatalogSid(roleCatalog.getTenantSid(), roleCatalogSid);
        if (roles != null && roles.size() > 0) {
            throw new BusinessException((ErrorHandler)I18nError.ROLE_CATALOG_CANNOT_DEACTIVATE, new Object[]{roleCatalogSid});
        }
        this.roleCatalogCrudService.disable(roleCatalogSid, tenantSid);
    }
}

