/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.role.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.role.RoleQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.role.RoleSimplInfoVO;
import com.digiwin.dap.middleware.iam.domain.role.UserAllRoleVO;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.RoleCatalog;
import com.digiwin.dap.middleware.iam.mapper.RoleMapper;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.language.service.LanguageService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class RoleQueryServiceImpl
implements RoleQueryService {
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private RoleCatalogCrudService roleCatalogCrudService;
    @Autowired
    private LanguageService languageService;
    @Autowired
    private AuthValidateService authValidateService;

    @Override
    public RoleQueryResultVO getRoleBySid(long sid) {
        RoleQueryResultVO roleResultVO = this.authValidateService.checkAccessPermission("Sys", AppAuthContextHolder.getContext().getRequestInfo().getMethod(), AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()) == false ? this.roleMapper.findRoleBySid(UserUtils.getTenantSid(), sid) : this.roleMapper.findRoleBySid(0L, sid);
        Optional.ofNullable(roleResultVO).ifPresent(roleVO -> {
            RoleCatalog roleCatalog = this.roleCatalogCrudService.findByTenantSidAndSid(roleVO.getTenantSid(), roleVO.getCatalogSid());
            Optional.ofNullable(roleCatalog).ifPresent(o -> {
                roleVO.setCatalogId(o.getId());
                roleVO.setCatalogName(o.getName());
            });
        });
        return roleResultVO;
    }

    @Override
    public RoleQueryResultVO getRoleByTenantSidAndId(long tenantSid, String id) {
        return this.roleMapper.findRoleByTenantSidAndId(tenantSid, id);
    }

    @Override
    public List<RoleQueryResultVO> getRoleQueryResultVosByCatalogSid(long tenantSid, long roleCatalogSid) {
        return this.roleMapper.findRoleQueryResultVOByCatalogSid(tenantSid, roleCatalogSid);
    }

    @Override
    public List<RoleQueryResultVO> getRoleQueryResultVosByType(boolean isDisable, long tenantSid) {
        List<RoleQueryResultVO> roleQueryResultVOList = this.roleMapper.findRoleQueryResultVOByType(isDisable, tenantSid);
        return this.languageService.parse(roleQueryResultVOList, Collections.singletonMap("name", "roleName"), RoleQueryResultVO.class, Role.class);
    }

    @Override
    public List<RoleQueryResultVO> getRoleQueryResultVosByTenant(long tenantSid) {
        List<RoleQueryResultVO> roleQueryResultVOList = this.roleMapper.findRoleQueryResultVOByTenantSid(tenantSid);
        return this.languageService.parse(roleQueryResultVOList, Collections.singletonMap("name", "roleName"), RoleQueryResultVO.class, Role.class);
    }

    @Override
    public List<UserAllRoleVO> getRolesByUserIds(List<String> userIds, String tenantId) {
        Assert.notNull(userIds, (String)"userIds is null");
        Assert.notNull((Object)tenantId, (String)"tenantId is null");
        long tenantSid = this.tenantCrudService.getSidById(tenantId);
        if (tenantSid == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        List<UserAllRoleVO> userAllRoleVOList = this.roleMapper.getRolesByUserIds(userIds, tenantSid);
        this.languageService.parse(userAllRoleVOList.stream().flatMap(x -> x.getRoles().stream()).collect(Collectors.toList()), Collections.singletonMap("name", "roleName"), RoleSimplInfoVO.class, Role.class);
        return userAllRoleVOList;
    }
}

