/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.role.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.org.BatchReplaceVO;
import com.digiwin.dap.middleware.iam.domain.role.RoleVO;
import com.digiwin.dap.middleware.iam.entity.Association;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.RoleCatalog;
import com.digiwin.dap.middleware.iam.repository.AssociationRepository;
import com.digiwin.dap.middleware.iam.repository.RoleRepository;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
implements RoleService {
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private RoleCatalogCrudService roleCatalogCrudService;
    @Autowired
    private AssociationRepository associationRepository;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private UserInRoleCrudService userInRoleCrudService;

    @Override
    public long addRole(RoleVO roleVO, long tenantSid) {
        Role role = this.roleCrudService.findByTenantSidAndId(tenantSid, roleVO.getId());
        if (role == null) {
            role = new Role();
            role.setId(roleVO.getId());
            role.setTenantSid(tenantSid);
            role.setRoleCatalogSid(roleVO.getCatalogSid());
            EntityUtils.setCreateFields((BaseEntity)role);
        }
        role = this.createRole(roleVO, role);
        return ((Role)((Object)this.roleRepository.save((Object)role))).getSid();
    }

    @Override
    public void modifyRole(RoleVO roleVO, long tenantSid) {
        Role role = this.roleCrudService.findByTenantSidAndId(tenantSid, roleVO.getId());
        if (role == null) {
            throw new BusinessException((ErrorHandler)I18nError.ROLE_DELETE, new Object[]{roleVO.getId()});
        }
        role = this.createRole(roleVO, role);
        this.roleCrudService.update((BaseEntity)role);
    }

    private Role createRole(RoleVO roleVO, Role role) {
        RoleCatalog roleCatalog = this.roleCatalogCrudService.findByTenantSidAndSid(role.getTenantSid(), roleVO.getCatalogSid());
        if (roleCatalog == null) {
            throw new BusinessException((ErrorHandler)I18nError.ROLE_CATALOG_NOT_EXISTED, new Object[]{roleVO.getCatalogSid()});
        }
        if (roleVO.getOrgSid() != null && roleVO.getOrgSid() > 0L) {
            if (role.getOrgSid() != roleVO.getOrgSid().longValue()) {
                Org org = (Org)this.orgCrudService.findBySid(roleVO.getOrgSid());
                if (org == null) {
                    throw new BusinessException((ErrorHandler)I18nError.ORG_ID_EXISTED, new Object[]{roleVO.getOrgSid()});
                }
                role.setUri(org.getUri() + ":" + role.getId());
                role.setUrn(org.getUrn() + ":" + role.getName());
            }
        } else {
            role.setUri("");
            role.setUrn("");
        }
        role.setOrgSid(roleVO.getOrgSid() == null ? 0L : roleVO.getOrgSid());
        if (roleVO.getRemark() != null) {
            role.setRemark(roleVO.getRemark());
        }
        role.setName(roleVO.getName());
        return role;
    }

    @Override
    public void disableRole(long roleSid, long tenantSid) {
        Role role = this.roleCrudService.findByTenantSidAndSid(tenantSid, roleSid);
        if (role == null) {
            throw new BusinessException((ErrorHandler)I18nError.ROLE_NOT_EXIST, new Object[]{roleSid});
        }
        if (this.associationRepository.existsByTenantSidAndRoleSid(tenantSid, roleSid)) {
            throw new BusinessException((ErrorHandler)I18nError.ROLE_CANNOT_DEACTIVATE, new Object[]{roleSid});
        }
        if (role.isDisabled()) {
            return;
        }
        role.setDisabled(true);
        this.roleCrudService.update((BaseEntity)role);
    }

    @Override
    @Transactional
    public void batchReplaceRole(BatchReplaceVO vo, long tenantSid) {
        List<Association> associations = this.associationRepository.findByTenantSidAndUserSidInAndRoleSid(tenantSid, vo.getUserSids(), vo.getOldSid());
        List toAdd = associations.stream().map(a -> {
            Association newAssociation = new Association();
            newAssociation.setRoleSid(vo.getNewSid());
            newAssociation.setUserSid(a.getUserSid());
            newAssociation.setTenantSid(a.getTenantSid());
            newAssociation.setStatus(Boolean.TRUE);
            return newAssociation;
        }).collect(Collectors.toList());
        this.associationRepository.deleteAll(associations);
        Set exist = this.associationRepository.findByTenantSidAndRoleSid(tenantSid, vo.getNewSid()).stream().map(Association::getUserSid).collect(Collectors.toSet());
        toAdd.removeIf(a -> exist.contains(a.getUserSid()));
        this.associationRepository.flush();
        this.userInRoleCrudService.saveAll(toAdd);
    }
}

