/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.service.authorization.code.impl;

import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.authorization.code.PageSearchParam;
import com.digiwin.dap.middleware.iam.domain.authorization.code.ServiceAuthorizationCodeDTO;
import com.digiwin.dap.middleware.iam.domain.authorization.code.ServiceAuthorizationCodeVO;
import com.digiwin.dap.middleware.iam.domain.authorization.record.ServiceAuthorizationRecordChangeLogInfo;
import com.digiwin.dap.middleware.iam.domain.authorization.record.ServiceAuthorizationRecordDTO;
import com.digiwin.dap.middleware.iam.domain.authorization.record.ServiceAuthorizationRecordVO;
import com.digiwin.dap.middleware.iam.domain.enumeration.StopTypeEnum;
import com.digiwin.dap.middleware.iam.entity.ServiceAuthorizationCode;
import com.digiwin.dap.middleware.iam.entity.ServiceAuthorizationRecord;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.ServiceAuthorizationCodeMapper;
import com.digiwin.dap.middleware.iam.mapper.ServiceAuthorizationRecordMapper;
import com.digiwin.dap.middleware.iam.repository.ServiceAuthorizationCodeRepository;
import com.digiwin.dap.middleware.iam.repository.ServiceAuthorizationRecordRepository;
import com.digiwin.dap.middleware.iam.service.service.authorization.code.ServiceAuthorizationCodeCrudService;
import com.digiwin.dap.middleware.iam.service.service.authorization.code.ServiceAuthorizationCodeService;
import com.digiwin.dap.middleware.iam.service.service.authorization.record.impl.ServiceAuthorizationRecordServiceImpl;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantOperationService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceAuthorizationCodeServiceImpl
implements ServiceAuthorizationCodeService {
    private static final Logger log = LoggerFactory.getLogger(ServiceAuthorizationCodeServiceImpl.class);
    @Autowired
    private ServiceAuthorizationCodeCrudService serviceAuthorizationCodeCrudService;
    @Autowired
    private ServiceAuthorizationCodeRepository serviceAuthorizationCodeRepository;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private ServiceAuthorizationRecordRepository serviceAuthorizationRecordRepository;
    @Autowired
    private ServiceAuthorizationRecordMapper serviceAuthorizationRecordMapper;
    @Autowired
    private UserInTenantOperationService userInTenantOperationService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private ServiceAuthorizationCodeMapper serviceAuthorizationCodeMapper;
    @Autowired
    private ServiceAuthorizationRecordServiceImpl serviceAuthorizationRecordService;

    @Override
    public ServiceAuthorizationCode save(ServiceAuthorizationCodeDTO dto) {
        if (this.serviceAuthorizationCodeRepository.existsByTenantSidAndDisabledAndType(dto.getTenantSid(), Boolean.FALSE, dto.getType())) {
            throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTH_CODE_EXISTED, new Object[]{dto.getTenantSid()});
        }
        dto.setCode(UUID.randomUUID().toString());
        if (0 == dto.getType()) {
            dto.setStartDate(LocalDateTime.now());
        }
        ServiceAuthorizationCode serviceAuthorizationCode = new ServiceAuthorizationCode();
        BeanUtils.mergeDifferentTypeObject((Object)dto, (Object)((Object)serviceAuthorizationCode));
        EntityUtils.setCreateFields((BaseEntity)serviceAuthorizationCode);
        serviceAuthorizationCode.setCreateById(UserUtils.getUserId());
        serviceAuthorizationCode.setCreateByName(UserUtils.getUserName());
        serviceAuthorizationCode.setModifyById(UserUtils.getUserId());
        serviceAuthorizationCode.setModifyByName(UserUtils.getUserName());
        this.serviceAuthorizationCodeRepository.save((Object)serviceAuthorizationCode);
        return serviceAuthorizationCode;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void stopCode(ServiceAuthorizationCodeDTO dto) {
        String code = dto.getCode();
        long tenantSid = dto.getTenantSid();
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, new Object[]{tenantSid});
        }
        ServiceAuthorizationCode authorizationCode = this.serviceAuthorizationCodeRepository.findByCodeAndTenantSid(code, tenantSid);
        if (authorizationCode == null) {
            throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTH_CODE_EXISTED, new Object[]{tenant.getId(), code});
        }
        if (authorizationCode.isDisabled()) {
            throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTH_CODE_DISABLE, new Object[]{code});
        }
        authorizationCode.setStopType(dto.getStopType());
        authorizationCode.setDisabled(Boolean.TRUE);
        this.stopAuthCode(authorizationCode, tenant, dto.getStopType(), dto.getCode());
    }

    @Override
    public PageSerializable getCodeList(PageSearchParam<ServiceAuthorizationCodeDTO> searchParam) {
        List<ServiceAuthorizationCodeVO> codeList = this.serviceAuthorizationCodeMapper.queryCodeList(searchParam.getPageNum(), searchParam.getPageSize(), searchParam.getOrderBy(), searchParam.getParams());
        return new PageSerializable(codeList);
    }

    @Override
    public ServiceAuthorizationCode copy(ServiceAuthorizationCodeDTO dto) {
        ServiceAuthorizationCode serviceAuthorizationCode = this.serviceAuthorizationCodeRepository.findByCode(dto.getCode());
        if (null == serviceAuthorizationCode) {
            throw new BusinessException((ErrorHandler)I18nError.AUTHORIZATION_CODE_NOT_EXIST, new Object[]{dto.getCode()});
        }
        if (serviceAuthorizationCode.isDisabled()) {
            throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTHORIZATION_CODE_STOPPED, new Object[]{serviceAuthorizationCode.getCode()});
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(serviceAuthorizationCode.getTenantSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, new Object[]{serviceAuthorizationCode.getTenantSid()});
        }
        ServiceAuthorizationRecordDTO searchCondition = new ServiceAuthorizationRecordDTO();
        searchCondition.setCode(dto.getCode());
        searchCondition.setTenantSid(tenant.getSid());
        searchCondition.setDisabled(false);
        List<ServiceAuthorizationRecordVO> recordList = this.serviceAuthorizationRecordMapper.selectServiceAuthorizationRecordList(searchCondition, 1, 99999, "ar.create_date desc");
        this.stopAuthCode(serviceAuthorizationCode, tenant, 1, dto.getCode());
        ServiceAuthorizationCode newServiceAuthorizationCode = new ServiceAuthorizationCode();
        newServiceAuthorizationCode.setAccountAuthorizationAgreement(dto.getAccountAuthorizationAgreement());
        newServiceAuthorizationCode.setStartDate(dto.getStartDate());
        newServiceAuthorizationCode.setEndDate(dto.getEndDate());
        newServiceAuthorizationCode.setType(serviceAuthorizationCode.getType());
        newServiceAuthorizationCode.setCode(UUID.randomUUID().toString());
        newServiceAuthorizationCode.setTenantSid(serviceAuthorizationCode.getTenantSid());
        newServiceAuthorizationCode.setSid(SnowFlake.getInstance().newId());
        EntityUtils.setCreateFields((BaseEntity)newServiceAuthorizationCode);
        newServiceAuthorizationCode.setCreateById(UserUtils.getUserId());
        newServiceAuthorizationCode.setCreateByName(UserUtils.getUserName());
        newServiceAuthorizationCode.setModifyById(UserUtils.getUserId());
        newServiceAuthorizationCode.setModifyByName(UserUtils.getUserName());
        this.serviceAuthorizationCodeRepository.save((Object)newServiceAuthorizationCode);
        ArrayList recodes = new ArrayList();
        ArrayList<ServiceAuthorizationRecordChangeLogInfo> changeLogInfos = new ArrayList<ServiceAuthorizationRecordChangeLogInfo>();
        recordList.forEach(r -> {
            if (r.getEndDate().isBefore(dto.getEndDate()) && r.getEndDate().isAfter(dto.getStartDate()) && r.getEndDate().isAfter(LocalDateTime.now())) {
                ServiceAuthorizationRecord serviceAuthorizationRecord = new ServiceAuthorizationRecord();
                serviceAuthorizationRecord.setCode(newServiceAuthorizationCode.getCode());
                serviceAuthorizationRecord.setAccountAuthorizationAgreement(true);
                serviceAuthorizationRecord.setUserSid(r.getUserSid());
                serviceAuthorizationRecord.setStartDate(newServiceAuthorizationCode.getStartDate());
                serviceAuthorizationRecord.setEndDate(r.getEndDate());
                serviceAuthorizationRecord.setRemark(String.format("\u5c55\u5ef6\u590d\u5236\u6388\u6743\u4ee3\u7406\uff0c\u6388\u6743\u7801%s", dto.getCode()));
                serviceAuthorizationRecord.setExtendData(serviceAuthorizationRecord, 0);
                recodes.add(serviceAuthorizationRecord);
                User user = new User();
                user.setSid(r.getUserSid());
                user.setId(r.getUserId());
                user.setName(r.getUserName());
                ServiceAuthorizationRecordChangeLogInfo changeLogInfo = new ServiceAuthorizationRecordChangeLogInfo(null, serviceAuthorizationRecord, tenant, user);
                changeLogInfos.add(changeLogInfo);
            }
        });
        if (!recodes.isEmpty()) {
            this.serviceAuthorizationRecordRepository.saveAll(recodes);
            this.changeLogService.saveServiceAuthCodeRecordUpdateLogs(changeLogInfos);
        }
        return newServiceAuthorizationCode;
    }

    @Override
    public List<ServiceAuthorizationRecordVO> getProxyUsers(String code) {
        ServiceAuthorizationCode existedAuthCode = this.serviceAuthorizationCodeRepository.findByCode(code);
        if (null == existedAuthCode) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_AGENT_CODE_NOT_EXISTED, new Object[]{code});
        }
        if (existedAuthCode.getStartDate().isAfter(LocalDateTime.now())) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_AGENT_CODE_NOT_START, new Object[]{code});
        }
        if (existedAuthCode.getEndDate().isBefore(LocalDateTime.now())) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_AGENT_CODE_EXPIRED, new Object[]{code});
        }
        if (existedAuthCode.isDisabled()) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_AGENT_CODE_DISABLED, new Object[]{code});
        }
        ServiceAuthorizationRecordDTO searchParams = new ServiceAuthorizationRecordDTO();
        searchParams.setType(1);
        searchParams.setCode(code);
        searchParams.setDisabled(false);
        List<ServiceAuthorizationRecordVO> serviceAuthorizationRecordVOS = this.serviceAuthorizationRecordMapper.selectServiceAuthorizationRecordList(searchParams, 1, 9999, "ar.create_date desc");
        return serviceAuthorizationRecordVOS.stream().filter(u -> LocalDateTime.now().isBefore(u.getEndDate()) && LocalDateTime.now().isAfter(u.getStartDate())).collect(Collectors.toList());
    }

    private void stopAuthCode(ServiceAuthorizationCode authorizationCode, Tenant tenant, Integer stopType, String code) {
        authorizationCode.setStopType(stopType);
        authorizationCode.setDisabled(Boolean.TRUE);
        String modifyId = StringUtils.isEmpty((CharSequence)UserUtils.getUserId()) ? "schedule" : UserUtils.getUserId();
        String modifyName = StringUtils.isEmpty((CharSequence)UserUtils.getUserName()) ? "\u540e\u53f0\u6392\u7a0b" : UserUtils.getUserName();
        EntityUtils.setModifyFields((BaseEntity)authorizationCode);
        authorizationCode.setModifyById(modifyId);
        authorizationCode.setModifyByName(modifyName);
        this.serviceAuthorizationCodeRepository.save((Object)authorizationCode);
        List<ServiceAuthorizationRecord> records = this.serviceAuthorizationRecordRepository.findByCodeAndDisabled(code, Boolean.FALSE);
        LocalDateTime dateTime = LocalDateTime.now();
        if (!records.isEmpty()) {
            records.forEach(r -> {
                r.setStopType(stopType);
                r.setStopDate(dateTime);
                r.setDisabled(Boolean.TRUE);
                EntityUtils.setModifyFields((BaseEntity)r);
                r.setModifyById(modifyId);
                r.setModifyByName(modifyName);
                this.serviceAuthorizationRecordRepository.save(r);
                User user = (User)this.userCrudService.findBySid(r.getUserSid());
                if (user == null) {
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_21001, new Object[]{r.getUserSid()});
                }
                if (0 == authorizationCode.getType()) {
                    this.userInTenantOperationService.exitTenant(tenant.getSid(), user);
                } else if (1 == authorizationCode.getType()) {
                    this.serviceAuthorizationRecordService.deleteAgentRedisKeys(tenant.getId(), user.getId());
                }
            });
        }
        if (StopTypeEnum.EXPIRED_STOP.getValue().equals(stopType)) {
            this.changeLogService.saveStopCodeChangeLogs(authorizationCode, tenant);
        }
    }
}

