/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.service.authorization.record.impl;

import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.authorization.record.ServiceAuthorizationRecordChangeLogInfo;
import com.digiwin.dap.middleware.iam.domain.authorization.record.ServiceAuthorizationRecordDTO;
import com.digiwin.dap.middleware.iam.domain.authorization.record.ServiceAuthorizationRecordVO;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.entity.Association;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.ServiceAuthorizationCode;
import com.digiwin.dap.middleware.iam.entity.ServiceAuthorizationRecord;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.ServiceAuthorizationRecordMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.repository.ServiceAuthorizationCodeRepository;
import com.digiwin.dap.middleware.iam.repository.ServiceAuthorizationRecordRepository;
import com.digiwin.dap.middleware.iam.repository.UserInTenantRepository;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.service.authorization.record.ServiceAuthorizationRecordCrudService;
import com.digiwin.dap.middleware.iam.service.service.authorization.record.ServiceAuthorizationRecordService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplication;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplicationDTO;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ServiceAuthorizationRecordServiceImpl
implements ServiceAuthorizationRecordService {
    private static final Logger log = LoggerFactory.getLogger(ServiceAuthorizationRecordServiceImpl.class);
    @Autowired
    private ServiceAuthorizationCodeRepository serviceAuthorizationCodeRepository;
    @Autowired
    private ServiceAuthorizationRecordRepository serviceAuthorizationRecordRepository;
    @Autowired
    private ServiceAuthorizationRecordCrudService serviceAuthorizationRecordCrudService;
    @Autowired
    private UserInTenantRepository userInTenantRepository;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private UserInRoleMapper userInRoleMapper;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private UserInRoleCrudService userInRoleCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private ServiceAuthorizationRecordMapper serviceAuthorizationRecordMapper;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private CacService cacService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserCrudService userCrudService;

    @Override
    @Transactional
    public ServiceAuthorizationRecordVO save(ServiceAuthorizationRecordDTO dto) {
        List<TenantApplication> tenantApplications;
        Role role;
        ServiceAuthorizationRecordVO recordVO = new ServiceAuthorizationRecordVO();
        long userSid = dto.getUserSid();
        String userId = dto.getUserId();
        String code = dto.getCode();
        ServiceAuthorizationCode authorizationCode = this.serviceAuthorizationCodeRepository.findByCode(code);
        if (authorizationCode == null) {
            log.error("\u670d\u52a1\u6388\u6743\u7801{}\u4e0d\u5b58\u5728", (Object)code);
            throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTHORIZATION_CODE_EMPTY_TIPS);
        }
        long tenantSid = authorizationCode.getTenantSid();
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{tenantSid});
        }
        if (authorizationCode.isDisabled()) {
            throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTHORIZATION_CODE_STOPPED, new Object[]{code});
        }
        recordVO.setTenantId(tenant.getId());
        recordVO.setTenantName(tenant.getName());
        recordVO.setEndDate(authorizationCode.getEndDate());
        boolean existsRecord = this.serviceAuthorizationRecordRepository.existsByCodeAndUserSidAndDisabled(code, userSid, Boolean.FALSE);
        if (existsRecord) {
            log.error("\u7528\u6237{}\u5df2\u6388\u6743\u8be5\u79df\u6237{}\u670d\u52a1\u6388\u6743\u7801{}", new Object[]{userSid, tenant.getId(), code});
            throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTHORIZATION_RECORD_USER_EXISTED);
        }
        List<ServiceAuthorizationRecord> records = this.serviceAuthorizationRecordRepository.findByCodeAndDisabled(code, Boolean.FALSE);
        if (records.size() >= 5) {
            log.error("\u6388\u6743\u7801{}\u6388\u6743\u4eba\u6570\u5df2\u6ee1{}\u4eba\uff0c\u8bf7\u534f\u8c03\u76ee\u524d\u5df2\u6388\u6743\u4eba\u5458\u9000\u51fa\u4f01\u4e1a\uff0c\u65b9\u53ef\u8fdb\u884c\u6388\u6743", (Object)code, (Object)5);
            throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTHORIZATION_CODE_MAX_USER_ERROR, new Object[]{5});
        }
        UserInTenant userInTenant = this.userInTenantRepository.findByTenantSidAndUserSid(tenantSid, userSid);
        if (userInTenant != null) {
            if (!userInTenant.isDisabled()) {
                log.error("\u7528\u6237{}\u5df2\u52a0\u5165\u8be5\u79df\u6237{}", (Object)userSid, (Object)tenant.getId());
                throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTHORIZATION_CODE_TENANT_USER_EXISTED);
            }
            this.createRecord(dto);
            userInTenant.setDisabled(Boolean.FALSE);
            this.userInTenantCrudService.update(userInTenant);
            return recordVO;
        }
        this.createRecord(dto);
        if (!this.userInTenantCrudService.existsByUnionKey(tenantSid, userSid)) {
            UserInTenant userInTenantDTO = new UserInTenant(userSid, tenantSid);
            this.userInTenantCrudService.create(userInTenantDTO);
        }
        if ((role = this.roleCrudService.findByTenantSidAndId(tenantSid, "superadmin")) == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NO_SUPER_ADMIN, new Object[]{tenantSid});
        }
        List<QueryRoleResultVO> userInRoles = this.userInRoleMapper.queryUserInRoleByUser(tenantSid, userSid);
        if (userInRoles.stream().noneMatch(ur -> "superadmin".equals(ur.getId()))) {
            Association association = new Association();
            association.setTenantSid(tenantSid);
            association.setRoleSid(role.getSid());
            association.setUserSid(userSid);
            association.setStatus(Boolean.TRUE);
            this.userInRoleCrudService.create((BaseEntity)association);
        }
        if (CollectionUtils.isEmpty(tenantApplications = this.tenantQueryService.getTenantApplicationAndPlatFormByTenant(new TenantApplicationDTO(tenant.getId())))) {
            return recordVO;
        }
        tenantApplications.forEach(tenantApplication -> {
            if (tenantApplication.isExpired() || Boolean.TRUE.equals(tenantApplication.getInside())) {
                return;
            }
            List<String> userIds = this.cacService.getAuthorizedUserIds(tenant.getId(), tenantApplication.getId());
            this.cacService.addAuthorization(this.envProperties.getCacUri(), tenant.getId(), tenantApplication.getId(), userId);
            List<String> newUserIds = this.cacService.getAuthorizedUserIds(tenant.getId(), tenantApplication.getId());
            this.changeLogService.addUserInCountingChangeLogs(dto, (TenantApplication)tenantApplication, userIds, newUserIds);
        });
        return recordVO;
    }

    @Override
    @Transactional
    public ServiceAuthorizationRecordVO saveIam(ServiceAuthorizationRecordDTO dto) {
        Role role;
        ServiceAuthorizationRecordVO recordVO = new ServiceAuthorizationRecordVO();
        long userSid = dto.getUserSid();
        String userId = dto.getUserId();
        String code = dto.getCode();
        ServiceAuthorizationCode authorizationCode = this.serviceAuthorizationCodeRepository.findByCode(code);
        if (authorizationCode == null) {
            log.error("\u670d\u52a1\u6388\u6743\u7801{}\u4e0d\u5b58\u5728", (Object)code);
            throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTHORIZATION_CODE_EMPTY_TIPS);
        }
        long tenantSid = authorizationCode.getTenantSid();
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{tenantSid});
        }
        if (authorizationCode.isDisabled()) {
            throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTHORIZATION_CODE_STOPPED, new Object[]{code});
        }
        recordVO.setTenantId(tenant.getId());
        recordVO.setTenantName(tenant.getName());
        recordVO.setEndDate(authorizationCode.getEndDate());
        boolean existsRecord = this.serviceAuthorizationRecordRepository.existsByCodeAndUserSidAndDisabled(code, userSid, Boolean.FALSE);
        if (existsRecord) {
            log.error("\u7528\u6237{}\u5df2\u6388\u6743\u8be5\u79df\u6237{}\u670d\u52a1\u6388\u6743\u7801{}", new Object[]{userSid, tenant.getId(), code});
            throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTHORIZATION_RECORD_USER_EXISTED);
        }
        List<ServiceAuthorizationRecord> records = this.serviceAuthorizationRecordRepository.findByCodeAndDisabled(code, Boolean.FALSE);
        if (records.size() >= 5) {
            log.error("\u6388\u6743\u7801{}\u6388\u6743\u4eba\u6570\u5df2\u6ee1{}\u4eba\uff0c\u8bf7\u534f\u8c03\u76ee\u524d\u5df2\u6388\u6743\u4eba\u5458\u9000\u51fa\u4f01\u4e1a\uff0c\u65b9\u53ef\u8fdb\u884c\u6388\u6743", (Object)code, (Object)5);
            throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTHORIZATION_CODE_MAX_USER_ERROR, new Object[]{5});
        }
        UserInTenant userInTenant = this.userInTenantRepository.findByTenantSidAndUserSid(tenantSid, userSid);
        if (userInTenant != null) {
            if (!userInTenant.isDisabled()) {
                log.error("\u7528\u6237{}\u5df2\u52a0\u5165\u8be5\u79df\u6237{}", (Object)userSid, (Object)tenant.getId());
                throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTHORIZATION_CODE_TENANT_USER_EXISTED);
            }
            this.createRecord(dto);
            userInTenant.setDisabled(Boolean.FALSE);
            this.userInTenantCrudService.update(userInTenant);
            return recordVO;
        }
        this.createRecord(dto);
        if (!this.userInTenantCrudService.existsByUnionKey(tenantSid, userSid)) {
            UserInTenant userInTenantDTO = new UserInTenant(userSid, tenantSid);
            this.userInTenantCrudService.create(userInTenantDTO);
        }
        if ((role = this.roleCrudService.findByTenantSidAndId(tenantSid, "superadmin")) == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NO_SUPER_ADMIN, new Object[]{tenantSid});
        }
        List<QueryRoleResultVO> userInRoles = this.userInRoleMapper.queryUserInRoleByUser(tenantSid, userSid);
        if (userInRoles.stream().noneMatch(ur -> "superadmin".equals(ur.getId()))) {
            Association association = new Association();
            association.setTenantSid(tenantSid);
            association.setRoleSid(role.getSid());
            association.setUserSid(userSid);
            association.setStatus(Boolean.TRUE);
            this.userInRoleCrudService.create((BaseEntity)association);
        }
        recordVO.setProceed(true);
        return recordVO;
    }

    @Override
    public ServiceAuthorizationRecord addAgent(ServiceAuthorizationRecordDTO dto) {
        User user;
        if (null == dto.getUserSid() || 0L == dto.getUserSid()) {
            if (StringUtils.isEmpty((Object)dto.getUserId())) {
                throw new BusinessException((ErrorHandler)I18nError.AGENT_USER_INFO_NOT_NULL);
            }
            user = (User)this.userCrudService.findById(dto.getUserId());
        } else {
            user = (User)this.userCrudService.findBySid(dto.getUserSid());
        }
        if (null == user) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        User tempUser = new User();
        tempUser.setName(user.getName());
        tempUser.setId(user.getId());
        dto.setUserSid(user.getSid());
        ServiceAuthorizationCode authorizationCode = this.serviceAuthorizationCodeRepository.findByCode(dto.getCode());
        if (authorizationCode == null) {
            log.error("\u4ee3\u7406\u6388\u6743\u7801{}\u4e0d\u5b58\u5728", (Object)dto.getCode());
            throw new BusinessException((ErrorHandler)I18nError.AGENT_AUTHORIZATION_CODE_NOT_EXIST);
        }
        if (authorizationCode.getEndDate().isBefore(dto.getEndDate())) {
            log.error("\u4ee3\u7406\u4eba\u6388\u6743\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6388\u6743\u7801\u622a\u6b62\u65f6\u95f4");
            throw new BusinessException((ErrorHandler)I18nError.AGENT_TIME_ERROR);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(dto.getTenantSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{dto.getTenantSid()});
        }
        if (!this.userInTenantCrudService.existsByUnionKey(tenant.getSid(), user.getSid())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_IN_TENANT_NOT_EXIST, new Object[]{user.getId(), tenant.getId()});
        }
        ServiceAuthorizationRecord existedRecord = this.serviceAuthorizationRecordRepository.getByCodeAndUserSid(dto.getCode(), dto.getUserSid());
        ServiceAuthorizationRecord serviceRecord = new ServiceAuthorizationRecord();
        if (null != existedRecord) {
            BeanUtils.mergeObject((Object)((Object)existedRecord), (Object)((Object)serviceRecord));
            serviceRecord.setEndDate(dto.getEndDate());
            if (dto.getEndDate().isBefore(LocalDateTime.now())) {
                serviceRecord.setDisabled(true);
                serviceRecord.setStopDate(LocalDateTime.now());
                serviceRecord.setStopType(2);
            } else {
                serviceRecord.setDisabled(false);
                serviceRecord.setStopDate(null);
                serviceRecord.setStopType(null);
            }
            serviceRecord.setExtendData(serviceRecord, 1);
            this.serviceAuthorizationRecordRepository.save((Object)serviceRecord);
        } else {
            dto.setStartDate(authorizationCode.getStartDate());
            dto.copyToEntity(serviceRecord);
            serviceRecord.setExtendData(serviceRecord, 0);
            this.serviceAuthorizationRecordRepository.save((Object)serviceRecord);
        }
        ArrayList<ServiceAuthorizationRecordChangeLogInfo> changeLogInfos = new ArrayList<ServiceAuthorizationRecordChangeLogInfo>(1);
        ServiceAuthorizationRecordChangeLogInfo changeLogInfo = new ServiceAuthorizationRecordChangeLogInfo(existedRecord, serviceRecord, tenant, tempUser);
        changeLogInfos.add(changeLogInfo);
        this.changeLogService.saveServiceAuthCodeRecordUpdateLogs(changeLogInfos);
        return serviceRecord;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchAddAgent(ServiceAuthorizationRecordDTO dto) {
        if (CollectionUtils.isEmpty(dto.getUserSids())) {
            return 0;
        }
        int add = 0;
        for (Long userSid : dto.getUserSids()) {
            ServiceAuthorizationRecordDTO aDto = new ServiceAuthorizationRecordDTO();
            org.springframework.beans.BeanUtils.copyProperties((Object)dto, (Object)aDto);
            aDto.setUserSid(userSid);
            this.addAgent(aDto);
            ++add;
        }
        return add;
    }

    @Override
    public ServiceAuthorizationRecord modifyAgent(ServiceAuthorizationRecordDTO dto) {
        ServiceAuthorizationRecord existedRecord = (ServiceAuthorizationRecord)this.serviceAuthorizationRecordCrudService.findBySid(dto.getSid());
        if (null == existedRecord) {
            throw new BusinessException((ErrorHandler)I18nError.AGENT_AUTHORIZATION_CODE_NOT_EXIST);
        }
        User user = (User)this.userCrudService.findBySid(existedRecord.getUserSid());
        if (null == user) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(dto.getTenantSid());
        if (null == tenant) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{dto.getTenantSid()});
        }
        if (!this.userInTenantCrudService.existsByUnionKey(tenant.getSid(), existedRecord.getUserSid())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_IN_TENANT_NOT_EXIST, new Object[]{user.getId(), tenant.getId()});
        }
        return this.updateServiceRecord(existedRecord, dto, tenant, user);
    }

    private ServiceAuthorizationRecord updateServiceRecord(ServiceAuthorizationRecord existedRecord, ServiceAuthorizationRecordDTO dto, Tenant tenant, User user) {
        ServiceAuthorizationRecord serviceAuthorizationRecord = new ServiceAuthorizationRecord();
        BeanUtils.mergeObject((Object)((Object)existedRecord), (Object)((Object)serviceAuthorizationRecord));
        if (null != dto.getDisabled() && serviceAuthorizationRecord.isDisabled() != dto.getDisabled().booleanValue()) {
            serviceAuthorizationRecord.setDisabled(dto.getDisabled());
            if (dto.getDisabled().booleanValue()) {
                serviceAuthorizationRecord.setStopDate(LocalDateTime.now());
                serviceAuthorizationRecord.setStopType(null == dto.getStopType() ? 1 : dto.getStopType());
            } else {
                serviceAuthorizationRecord.setStopType(null);
                serviceAuthorizationRecord.setStopDate(null);
            }
        }
        if (null != dto.getEndDate() && dto.getEndDate() != serviceAuthorizationRecord.getEndDate()) {
            serviceAuthorizationRecord.setEndDate(dto.getEndDate());
            if (dto.getEndDate().isBefore(LocalDateTime.now())) {
                serviceAuthorizationRecord.setDisabled(true);
                serviceAuthorizationRecord.setStopDate(LocalDateTime.now());
                serviceAuthorizationRecord.setStopType(1);
            } else {
                serviceAuthorizationRecord.setDisabled(false);
                serviceAuthorizationRecord.setStopDate(null);
                serviceAuthorizationRecord.setStopType(null);
            }
        }
        serviceAuthorizationRecord.setExtendData(serviceAuthorizationRecord, 1);
        this.serviceAuthorizationRecordRepository.save((Object)serviceAuthorizationRecord);
        if (serviceAuthorizationRecord.isDisabled()) {
            this.deleteAgentRedisKeys(tenant.getId(), user.getId());
        }
        ArrayList<ServiceAuthorizationRecordChangeLogInfo> changeLogInfos = new ArrayList<ServiceAuthorizationRecordChangeLogInfo>(1);
        ServiceAuthorizationRecordChangeLogInfo changeLogInfo = new ServiceAuthorizationRecordChangeLogInfo(existedRecord, serviceAuthorizationRecord, tenant, user);
        changeLogInfos.add(changeLogInfo);
        this.changeLogService.saveServiceAuthCodeRecordUpdateLogs(changeLogInfos);
        return serviceAuthorizationRecord;
    }

    @Override
    public void deleteAgentRedisKeys(String tenantId, String agentUserId) {
        List range = RedisUtils.opsForList().range((Object)LoginUser.agentListKey(tenantId, agentUserId), 0L, -1L);
        if (!CollectionUtils.isEmpty((Collection)range)) {
            for (Object key : range) {
                String token = (String)RedisUtils.get((Object)key.toString(), String.class);
                RedisUtils.delete((String)LoginUser.tokenKey(token));
                RedisUtils.delete((String)key.toString());
            }
        }
        RedisUtils.delete((String)LoginUser.agentListKey(tenantId, agentUserId));
    }

    @Override
    public void batchModifyAgent(List<ServiceAuthorizationRecordDTO> dtoList, Long tenantSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (null == tenant) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{tenantSid});
        }
        List<Long> sids = dtoList.stream().map(ServiceAuthorizationRecordDTO::getSid).collect(Collectors.toList());
        if (sids.isEmpty()) {
            log.error("\u4fee\u6539\u4e3b\u952e\u4e3a\u7a7a\uff0c{}", (Object)JsonUtils.writeValue(dtoList));
            return;
        }
        List<ServiceAuthorizationRecord> records = this.serviceAuthorizationRecordRepository.findInSids(sids);
        dtoList.forEach(r -> {
            ServiceAuthorizationRecord existedRecord = records.stream().filter(re -> re.getSid() == r.getSid().longValue()).findFirst().orElse(null);
            if (null == existedRecord) {
                log.error("\u6388\u6743\u4ee3\u7406\u7528\u6237\u8bb0\u5f55{}\u4e0d\u5b58\u5728", (Object)r.getSid());
                return;
            }
            User user = (User)this.userCrudService.findBySid(existedRecord.getUserSid());
            if (null == user) {
                log.error("\u4ee3\u7406\u8bb0\u5f55{}\u7684\u7528\u6237{}\u4e0d\u5b58\u5728", (Object)r.getSid(), (Object)r.getUserSid());
                return;
            }
            if (!this.userInTenantCrudService.existsByUnionKey(tenant.getSid(), existedRecord.getUserSid())) {
                log.error("\u7528\u6237{}\u672a\u52a0\u5165\u5230\u79df\u6237{}", (Object)user.getId(), (Object)tenant.getId());
                return;
            }
            ServiceAuthorizationRecord record = this.updateServiceRecord(existedRecord, (ServiceAuthorizationRecordDTO)r, tenant, user);
            log.info("\u53d8\u66f4\u6210\u529f\uff0c\u4fe1\u606f{}", (Object)JsonUtils.writeValue((Object)((Object)record)));
        });
    }

    @Override
    public List<ServiceAuthorizationRecordVO> getRecords(ServiceAuthorizationRecordDTO dto, Integer pageNum, Integer pageSize, String orderBy) {
        return this.serviceAuthorizationRecordMapper.selectServiceAuthorizationRecordList(dto, pageNum, pageSize, orderBy);
    }

    @Override
    @Transactional
    public void updateRecordStop(long tenantSid, long userSid, Integer stopType) {
        ServiceAuthorizationRecord record = this.serviceAuthorizationRecordMapper.selectByUserSidAndTenantSid(userSid, tenantSid, Boolean.FALSE);
        if (record != null) {
            record.setStopDate(LocalDateTime.now());
            record.setStopType(stopType);
            record.setDisabled(Boolean.TRUE);
            this.serviceAuthorizationRecordCrudService.update(record);
        }
    }

    @Override
    public boolean checkCanAgent(String code, String userId) {
        return this.serviceAuthorizationRecordMapper.checkCanAgent(code, userId);
    }

    private void createRecord(ServiceAuthorizationRecordDTO dto) {
        ServiceAuthorizationRecord record = new ServiceAuthorizationRecord();
        BeanUtils.mergeDifferentTypeObject((Object)dto, (Object)((Object)record));
        this.serviceAuthorizationRecordCrudService.create(record);
    }
}

