/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.service.permission.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.dev.DevActionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevConditionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevModuleVO;
import com.digiwin.dap.middleware.iam.domain.service.permission.AppWithApiRelationVO;
import com.digiwin.dap.middleware.iam.domain.service.permission.MetadataApiRelationVO;
import com.digiwin.dap.middleware.iam.domain.service.permission.MetadataApiVO;
import com.digiwin.dap.middleware.iam.entity.DevSys;
import com.digiwin.dap.middleware.iam.entity.ServiceMetadataApi;
import com.digiwin.dap.middleware.iam.entity.ServiceMetadataApiRelation;
import com.digiwin.dap.middleware.iam.mapper.DevActionMapper;
import com.digiwin.dap.middleware.iam.mapper.DevConditionMapper;
import com.digiwin.dap.middleware.iam.mapper.DevModuleMapper;
import com.digiwin.dap.middleware.iam.mapper.DevSysMapper;
import com.digiwin.dap.middleware.iam.mapper.ServicePermissionMapper;
import com.digiwin.dap.middleware.iam.repository.SpMetadataApiRelationRepository;
import com.digiwin.dap.middleware.iam.repository.SpMetadataApiRepository;
import com.digiwin.dap.middleware.iam.service.service.permission.SpMetadataApiRelationService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.StringUtils;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpMetadataApiRelationServiceImpl
implements SpMetadataApiRelationService {
    private static final Logger log = LoggerFactory.getLogger(SpMetadataApiRelationServiceImpl.class);
    @Autowired
    private SpMetadataApiRelationRepository spMetadataApiRelationRepository;
    @Autowired
    private ServicePermissionMapper servicePermissionMapper;
    @Autowired
    private DevSysMapper devSysMapper;
    @Autowired
    private DevModuleMapper devModuleMapper;
    @Autowired
    private DevActionMapper devActionMapper;
    @Autowired
    private DevConditionMapper devConditionMapper;
    @Autowired
    private SpMetadataApiRepository spMetadataApiRepository;

    @Override
    public void save(AppWithApiRelationVO appWithApiRelationVO) {
        ArrayList relations = new ArrayList();
        ArrayList addApis = new ArrayList();
        this.spMetadataApiRelationRepository.deleteByDataSid(appWithApiRelationVO.getDataSid());
        Map<String, Map<String, Map<String, List<MetadataApiVO>>>> groupApis = appWithApiRelationVO.getApis().stream().collect(Collectors.groupingBy(MetadataApiVO::getApp, Collectors.groupingBy(MetadataApiVO::getMethod, Collectors.groupingBy(MetadataApiVO::getPath))));
        for (Map.Entry<String, Map<String, Map<String, List<MetadataApiVO>>>> groupApi : groupApis.entrySet()) {
            String app = groupApi.getKey();
            Map<String, Map<String, List<MetadataApiVO>>> appApiMap = groupApi.getValue();
            for (Map.Entry<String, Map<String, List<MetadataApiVO>>> appApi : appApiMap.entrySet()) {
                String method = appApi.getKey();
                Map<String, List<MetadataApiVO>> apiMap = appApi.getValue();
                for (Map.Entry<String, List<MetadataApiVO>> pathApi : apiMap.entrySet()) {
                    String path = pathApi.getKey();
                    List<ServiceMetadataApi> apis = this.spMetadataApiRepository.findByAppAndMethodAndPath(app, method, path);
                    ServiceMetadataApi originApi = apis.stream().filter(p -> StringUtils.isEmpty((Object)p.getTableName())).findFirst().orElse(null);
                    if (originApi == null) {
                        log.error("\u5e94\u7528{}\u4e0b\u7684\u5143\u6570\u636e{}[\u8bf7\u6c42\u65b9\u5f0f\u4e3a{}]\u4e0d\u5b58\u5728", new Object[]{app, path, method});
                        continue;
                    }
                    pathApi.getValue().forEach(a -> {
                        ServiceMetadataApiRelation relation = new ServiceMetadataApiRelation();
                        if (!StringUtils.isEmpty((Object)a.getTableName())) {
                            ServiceMetadataApi existedApi = apis.stream().filter(p -> a.getTableName().equals(p.getTableName())).findFirst().orElse(null);
                            if (existedApi == null) {
                                existedApi = new ServiceMetadataApi();
                                existedApi.setApp(app);
                                existedApi.setMethod(method);
                                existedApi.setPath(path);
                                existedApi.setAnonymous(originApi.getAnonymous());
                                existedApi.setDisplayName(originApi.getDisplayName());
                                existedApi.setRemark(originApi.getRemark());
                                existedApi.setSid(SnowFlake.getInstance().newId());
                                existedApi.setTableName(a.getTableName());
                                addApis.add(existedApi);
                            }
                            relation.setMetadataApiSid(existedApi.getSid());
                        } else {
                            relation.setMetadataApiSid(a.getSid());
                        }
                        relation.setDataSid(appWithApiRelationVO.getDataSid());
                        relation.setType(appWithApiRelationVO.getType());
                        EntityUtils.setCreateFields((BaseEntity)relation);
                        relations.add(relation);
                    });
                }
            }
        }
        if (!addApis.isEmpty()) {
            this.spMetadataApiRepository.saveAll(addApis);
        }
        if (!relations.isEmpty()) {
            this.spMetadataApiRelationRepository.saveAll(relations);
        }
    }

    @Override
    public void delete(List<Long> sids) {
        this.spMetadataApiRelationRepository.deleteInSids(sids);
    }

    @Override
    public PageSerializable getList(Long dataSid, Integer pageNum, Integer pageSize) {
        List<MetadataApiRelationVO> relationVOS = this.servicePermissionMapper.getRelationListWithPage(dataSid, pageNum, pageSize);
        return new PageSerializable(relationVOS);
    }

    @Override
    public List<AppWithApiRelationVO> getRelationInfo(Long apiSid) {
        List<Long> conditionSids;
        List<Long> actionSids;
        List<Long> moduleSids;
        ArrayList<AppWithApiRelationVO> result = new ArrayList<AppWithApiRelationVO>();
        List<AppWithApiRelationVO> relatedDataSidList = this.servicePermissionMapper.getApiRelatedAppInfo(apiSid);
        List<Long> appSids = relatedDataSidList.stream().filter(d -> d.getType().equals(0)).map(AppWithApiRelationVO::getDataSid).collect(Collectors.toList());
        if (!appSids.isEmpty()) {
            List<DevSys> devSysList = this.devSysMapper.findSysInSids(appSids);
            devSysList.forEach(s -> {
                AppWithApiRelationVO appWithApiRelationVO = relatedDataSidList.stream().filter(d -> d.getDataSid().equals(s.getSid())).findFirst().orElse(null);
                if (appWithApiRelationVO != null) {
                    appWithApiRelationVO.setApp(s.getId());
                    appWithApiRelationVO.setAppName(s.getNameCN());
                    result.add(appWithApiRelationVO);
                }
            });
        }
        if (!(moduleSids = relatedDataSidList.stream().filter(d -> d.getType().equals(1)).map(AppWithApiRelationVO::getDataSid).collect(Collectors.toList())).isEmpty()) {
            List<DevModuleVO> moduleVOS = this.devModuleMapper.getListInSids(moduleSids);
            moduleVOS.forEach(m -> {
                AppWithApiRelationVO appWithApiRelationVO = relatedDataSidList.stream().filter(d -> d.getDataSid().equals(m.getSid())).findFirst().orElse(null);
                if (appWithApiRelationVO != null) {
                    appWithApiRelationVO.setModuleId(m.getId());
                    appWithApiRelationVO.setModuleName(m.getNameCN());
                    appWithApiRelationVO.setApp(m.getAppId());
                    appWithApiRelationVO.setAppName(m.getAppName());
                    result.add(appWithApiRelationVO);
                }
            });
        }
        if (!(actionSids = relatedDataSidList.stream().filter(d -> d.getType().equals(2)).map(AppWithApiRelationVO::getDataSid).collect(Collectors.toList())).isEmpty()) {
            List<DevActionQueryResultVO> actionVOs = this.devActionMapper.getListInSids(actionSids);
            actionVOs.forEach(a -> {
                AppWithApiRelationVO appWithApiRelationVO = relatedDataSidList.stream().filter(d -> d.getDataSid().equals(a.getSid())).findFirst().orElse(null);
                if (appWithApiRelationVO != null) {
                    appWithApiRelationVO.setActionId(a.getId());
                    appWithApiRelationVO.setActionName(a.getNameCN());
                    appWithApiRelationVO.setModuleId(a.getModuleId());
                    appWithApiRelationVO.setModuleName(a.getModuleName());
                    appWithApiRelationVO.setApp(a.getAppId());
                    appWithApiRelationVO.setAppName(a.getAppName());
                    result.add(appWithApiRelationVO);
                }
            });
        }
        if (!(conditionSids = relatedDataSidList.stream().filter(d -> d.getType().equals(3)).map(AppWithApiRelationVO::getDataSid).collect(Collectors.toList())).isEmpty()) {
            List<DevConditionQueryResultVO> conditionVOs = this.devConditionMapper.getListInSids(conditionSids);
            conditionVOs.forEach(c -> {
                AppWithApiRelationVO appWithApiRelationVO = relatedDataSidList.stream().filter(d -> d.getDataSid().equals(Long.parseLong(c.getSid()))).findFirst().orElse(null);
                if (appWithApiRelationVO != null) {
                    appWithApiRelationVO.setConditionId(c.getKey());
                    appWithApiRelationVO.setConditionName(c.getNameCN());
                    appWithApiRelationVO.setActionId(c.getActionId());
                    appWithApiRelationVO.setActionName(c.getActionName());
                    appWithApiRelationVO.setModuleId(c.getModuleId());
                    appWithApiRelationVO.setModuleName(c.getModuleName());
                    appWithApiRelationVO.setApp(c.getAppId());
                    appWithApiRelationVO.setAppName(c.getAppName());
                    result.add(appWithApiRelationVO);
                }
            });
        }
        return result;
    }
}

