/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.service.permission.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.service.permission.MetadataApiVO;
import com.digiwin.dap.middleware.iam.entity.ServiceMetadataApi;
import com.digiwin.dap.middleware.iam.mapper.ServicePermissionMapper;
import com.digiwin.dap.middleware.iam.repository.SpMetadataApiRepository;
import com.digiwin.dap.middleware.iam.service.service.permission.SpMetadataApiService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpMetadataApiServiceImpl
implements SpMetadataApiService {
    private static final Logger logger = LoggerFactory.getLogger(SpMetadataApiServiceImpl.class);
    @Autowired
    private SpMetadataApiRepository spMetadataApiRepository;
    @Autowired
    private ServicePermissionMapper servicePermissionMapper;

    @Override
    public void importMetadataApis(List<ServiceMetadataApi> serviceMetadataApiList) {
        List apps = serviceMetadataApiList.stream().map(ServiceMetadataApi::getApp).distinct().collect(Collectors.toList());
        ArrayList serviceMetadataApis = new ArrayList();
        for (String app : apps) {
            List<ServiceMetadataApi> currentApis = serviceMetadataApiList.stream().filter(a -> app.equals(a.getApp())).collect(Collectors.toList());
            List<ServiceMetadataApi> oldServiceMetadataApis = this.spMetadataApiRepository.findByApp(app);
            currentApis.forEach(a -> {
                ServiceMetadataApi serviceMetadataApi = oldServiceMetadataApis.stream().filter(m -> m.getMethod().equals(a.getMethod()) && m.getPath().equals(a.getPath())).findFirst().orElse(null);
                if (null == serviceMetadataApi) {
                    serviceMetadataApi = a;
                    EntityUtils.setCreateFields((BaseEntity)serviceMetadataApi);
                    serviceMetadataApis.add(serviceMetadataApi);
                } else {
                    serviceMetadataApi.setAnonymous(a.getAnonymous());
                    EntityUtils.setModifyFields((BaseEntity)serviceMetadataApi);
                    serviceMetadataApis.add(serviceMetadataApi);
                }
            });
            this.spMetadataApiRepository.saveAll(serviceMetadataApis);
        }
    }

    @Override
    public void updateWhiteApis(List<ServiceMetadataApi> apiList) {
        List<Long> apiSids = apiList.stream().map(BaseEntity::getSid).collect(Collectors.toList());
        List<ServiceMetadataApi> existedApis = this.spMetadataApiRepository.getAllInSids(apiSids);
        apiList.forEach(a -> {
            ServiceMetadataApi api = existedApis.stream().filter(p -> a.getSid() == p.getSid()).findFirst().orElse(null);
            if (null == api) {
                logger.error(String.format("\u5143\u6570\u636e\u63a5\u53e3%s\u4e0d\u5b58\u5728", a.getSid()));
                return;
            }
            api.setAnonymous(a.getAnonymous());
            api.setDisplayName(a.getDisplayName());
            api.setRemark(a.getRemark());
            api.setTableName(a.getTableName());
            EntityUtils.setModifyFields((BaseEntity)api);
        });
        this.spMetadataApiRepository.saveAll(existedApis);
    }

    @Override
    public void delete(List<Long> apiSids) {
        List<ServiceMetadataApi> serviceMetadataApiRelations = this.servicePermissionMapper.findInApiSids(apiSids);
        if (!serviceMetadataApiRelations.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.API_RELATION_ACTION_DELETE_EXCEPTION, new Object[]{serviceMetadataApiRelations.stream().map(ServiceMetadataApi::getPath).distinct().collect(Collectors.joining(","))});
        }
        this.spMetadataApiRepository.deleteInSids(apiSids);
    }

    @Override
    public PageSerializable getList(String app, String path, Boolean anonymous, String content, Integer pageNum, Integer pageSize, String orderBy) {
        List<ServiceMetadataApi> serviceMetadataApis = this.servicePermissionMapper.getListWithPage(app, path, content, anonymous, pageNum, pageSize, orderBy);
        return new PageSerializable(serviceMetadataApis);
    }

    @Override
    public List<MetadataApiVO> exportApis(String app) {
        return this.servicePermissionMapper.getList(app);
    }
}

