/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.servicer.impl;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.domain.tenant.isv.credential.IsvCredentialExcelVO;
import com.digiwin.dap.middleware.iam.domain.tenant.isv.credential.IsvCredentialVO;
import com.digiwin.dap.middleware.iam.entity.IsvCredential;
import com.digiwin.dap.middleware.iam.mapper.IsvCredentialMapper;
import com.digiwin.dap.middleware.iam.repository.IsvCredentialRepository;
import com.digiwin.dap.middleware.iam.service.servicer.IsvCredentialCrudService;
import com.digiwin.dap.middleware.iam.service.servicer.IsvCredentialService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IsvCredentialServiceImpl
implements IsvCredentialService {
    private final Logger logger = LoggerFactory.getLogger(IsvCredentialServiceImpl.class);
    @Resource
    private IsvCredentialCrudService isvCredentialCrudService;
    @Resource
    private IsvCredentialRepository isvCredentialRepository;
    @Resource
    private IsvCredentialMapper isvCredentialMapper;
    @Autowired
    private ChangeLogService changeLogService;

    @Override
    public Long add(IsvCredentialVO body) {
        List<IsvCredential> exist = this.isvCredentialRepository.findByTenantSid(UserUtils.getTenantSid());
        if (exist.size() > 1) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_ISV_CREDENTIAL_UNIQUENESS);
        }
        IsvCredential isvCredential = new IsvCredential();
        isvCredential.setTenantSid(UserUtils.getTenantSid());
        isvCredential.setDescription(body.getDescription());
        isvCredential.setId(this.genIsvCredential(20, true, true).toLowerCase());
        isvCredential.setDevKey(this.genIsvCredential(20, true, false).toUpperCase());
        isvCredential.setDevSecret(this.genIsvCredential(40, true, true));
        return this.isvCredentialCrudService.create(isvCredential);
    }

    private String genIsvCredential(int count, boolean letters, boolean numbers) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] randomBytes = new byte[32];
        secureRandom.nextBytes(randomBytes);
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] hash = digest.digest(randomBytes);
        String base64Key = Base64.getEncoder().encodeToString(hash);
        StringBuilder filteredKey = new StringBuilder();
        for (char c : base64Key.toCharArray()) {
            if (letters && Character.isLetter(c) || numbers && Character.isDigit(c)) {
                filteredKey.append(c);
            }
            if (filteredKey.length() == count) break;
        }
        return filteredKey.toString();
    }

    @Override
    @Transactional
    public IsvCredential mod(IsvCredentialVO body) {
        IsvCredential credential = (IsvCredential)this.isvCredentialCrudService.findBySid(body.getSid());
        Optional.ofNullable(credential).ifPresent(a -> {
            if (UserUtils.getTenantSid() != credential.getTenantSid()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
            }
            IsvCredential oldCredential = new IsvCredential();
            BeanUtils.copyProperties((Object)((Object)credential), (Object)((Object)oldCredential));
            a.setDescription(Optional.ofNullable(body.getDescription()).orElse(a.getDescription()));
            a.setDisabled(Optional.ofNullable(body.getDisabled()).orElse(a.isDisabled()));
            this.isvCredentialCrudService.update((BaseEntity)a);
            this.changeLogService.updateCompareChangeLog(ChangeTypeEnum.ISV_CREDENTIAL_UPDATE.getName(), (Object)oldCredential, (Object)credential, Arrays.asList(ChangeTypeEnum.ISV_CREDENTIAL_UPDATE.getPrimaryKey()), Arrays.asList("disabled", "description"));
        });
        return credential;
    }

    @Override
    public void export(Long tenantSid, long sid, HttpServletResponse response) {
        IsvCredential credential = (IsvCredential)this.isvCredentialCrudService.findBySid(sid);
        if (credential != null && credential.getCreateOrg() >= 1L) {
            throw new BusinessException("\u8bbf\u95ee\u5bc6\u94a5\u4ec5\u80fd\u4e0b\u8f7d\u4e00\u6b21");
        }
        List<IsvCredentialExcelVO> result = this.isvCredentialMapper.findExcel(tenantSid, sid);
        try {
            if (credential != null && !result.isEmpty()) {
                credential.setCreateOrg(1L);
                this.isvCredentialCrudService.update(credential);
            }
            InputStream inputStream = this.getClass().getResourceAsStream("/static/templates/credentials.xlsx");
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=credentials.xlsx");
            ((ExcelWriterSheetBuilder)EasyExcelFactory.write((OutputStream)response.getOutputStream(), IsvCredentialExcelVO.class).withTemplate(inputStream).sheet(Integer.valueOf(0)).needHead(Boolean.valueOf(false))).doWrite(result);
        }
        catch (Exception e) {
            this.logger.error("export credential failed", (Throwable)e);
        }
    }
}

