/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.servicer.impl;

import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.servicer.ApplyStatusEnum;
import com.digiwin.dap.middleware.iam.domain.servicer.ServicerExtVO;
import com.digiwin.dap.middleware.iam.domain.servicer.ServicerVO;
import com.digiwin.dap.middleware.iam.entity.IsvRelationDev;
import com.digiwin.dap.middleware.iam.entity.Servicer;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.repository.ServicerRepository;
import com.digiwin.dap.middleware.iam.repository.SysRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.service.servicer.ServicerService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.IsvRelationDevCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantService;
import com.digiwin.dap.middleware.iam.support.initialize.TenantInitializeService;
import java.util.Optional;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServicerServiceImpl
implements ServicerService {
    private static final Logger logger = LoggerFactory.getLogger(ServicerServiceImpl.class);
    @Autowired
    private ServicerRepository servicerRepository;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private TenantInitializeService tenantInitializeService;
    @Autowired
    private SysRepository sysRepository;
    @Autowired
    private SysInTenantCrudService sysInTenantCrudService;
    @Autowired
    private IsvRelationDevCrudService isvRelationDevCrudService;
    @Autowired
    private TenantService tenantService;

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Servicer createServicer(ServicerVO servicerVO) {
        Servicer servicer = servicerVO.getSid() != null ? (Servicer)this.servicerRepository.findById(servicerVO.getSid()).orElse(null) : this.servicerRepository.findByTenantSid(servicerVO.getTenantSid());
        if (servicer == null) {
            Optional tenant = this.tenantRepository.findById(servicerVO.getTenantSid());
            if (!tenant.isPresent()) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_21018);
            }
            return (Servicer)((Object)this.servicerRepository.save((Object)servicerVO.generateServicer(new Servicer())));
        }
        Optional tenant = this.tenantRepository.findById(servicerVO.getTenantSid());
        if (tenant.isPresent()) {
            Long tenantSid = ((Tenant)((Object)tenant.get())).getSid();
            Tenant servtenant = (Tenant)((Object)tenant.get());
            ServicerExtVO servicerExtVO = new ServicerExtVO(servicerVO);
            BeanUtils.mergeDifferentTypeObject((Object)servicerExtVO, (Object)((Object)servtenant));
            servtenant.setSid(tenantSid);
            this.tenantCrudService.update((BaseEntity)servtenant);
        }
        return (Servicer)((Object)this.servicerRepository.save((Object)servicerVO.generateServicer(servicer)));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void confirmServicer(ServicerVO servicerVO) {
        Servicer servicer = this.servicerRepository.findByTenantSid(servicerVO.getTenantSid());
        if (servicer == null) {
            logger.error("no servicer to confirm");
            return;
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(servicer.getTenantSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21018);
        }
        tenant.setIsv(true);
        tenant.setIsvApplyStatus(ApplyStatusEnum.QUALIFIED.getCode());
        this.tenantCrudService.update((BaseEntity)tenant);
        if (!this.isvRelationDevCrudService.existsByIsvTenantSidAndDevTenantSid(servicerVO.getTenantSid(), servicerVO.getTenantSid())) {
            IsvRelationDev isvRelationDev = new IsvRelationDev();
            isvRelationDev.setIsvTenantSid(servicerVO.getTenantSid());
            isvRelationDev.setDevTenantSid(servicerVO.getTenantSid());
            this.isvRelationDevCrudService.create(isvRelationDev);
        }
        this.tenantInitializeService.initIsvApp(servicerVO.getTenantSid());
        this.servicerRepository.save((Object)servicer);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void disqualifyServicer(ServicerVO servicerVO) {
        Servicer servicer = this.servicerRepository.findByTenantSid(servicerVO.getTenantSid());
        if (servicer == null) {
            logger.error("no servicer to disqualify");
            return;
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(servicer.getTenantSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21018);
        }
        tenant.setIsv(false);
        tenant.setIsvApplyStatus(ApplyStatusEnum.DISQUALIFIED.getCode());
        this.tenantCrudService.update((BaseEntity)tenant);
        servicer.setRemark(servicerVO.getRemark());
        this.servicerRepository.save((Object)servicer);
        Sys sys = (Sys)this.sysRepository.findById("ISV");
        if (sys != null) {
            this.sysInTenantCrudService.deleteByUnionKey(servicerVO.getTenantSid(), sys.getSid());
        }
    }

    @Override
    public void denyServicer(ServicerVO servicerVO) {
        Servicer servicer = this.servicerRepository.findByTenantSid(servicerVO.getTenantSid());
        if (servicer == null) {
            logger.error("no servicer to deny");
            return;
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(servicer.getTenantSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21018);
        }
        tenant.setIsvApplyStatus(ApplyStatusEnum.DENIED.getCode());
        this.tenantCrudService.update((BaseEntity)tenant);
        servicer.setRemark(servicerVO.getRemark());
        this.servicerRepository.save((Object)servicer);
    }

    @Override
    @Transactional
    public void deleteServicer(Long tenantSid) {
        Tenant tenant;
        Servicer servicer = this.servicerRepository.findByTenantSid(tenantSid);
        if (servicer != null) {
            this.servicerRepository.deleteById(servicer.getSid());
        }
        this.isvRelationDevCrudService.deleteByIsvTenantSid(tenantSid);
        Sys sys = (Sys)this.sysRepository.findById("ISV");
        if (sys != null) {
            this.sysInTenantCrudService.deleteByUnionKey(tenantSid, sys.getSid());
        }
        if ((tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid)) == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21018);
        }
        tenant.setIsv(false);
        tenant.setIsvApplyStatus(ApplyStatusEnum.NOTAPPLIED.getCode());
        this.tenantCrudService.update((BaseEntity)tenant);
    }
}

