/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.sys.impl;

import com.digiwin.dap.middleware.iam.domain.app.SysQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.SysInTenantTokenVO;
import com.digiwin.dap.middleware.iam.domain.tenant.SysInTenantVO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysInTenant;
import com.digiwin.dap.middleware.iam.mapper.SysInTenantMapper;
import com.digiwin.dap.middleware.iam.mapper.SysMapper;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantQueryService;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.GoodsLanguage;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SysInTenantQueryServiceImpl
implements SysInTenantQueryService {
    @Autowired
    private SysMapper sysMapper;
    @Autowired
    private SysInTenantMapper sysInTenantMapper;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private LanguageCrudService languageCrudService;

    @Override
    public List<SysQueryResultVO> getSysVOByTenantSid(long tenantSid) {
        return this.sysMapper.findSysVOByTenantSid(tenantSid);
    }

    @Override
    public Sys getSysByIdAndTenantSid(String sysId, long tenantSid) {
        return this.sysMapper.findByTenantSidAndId(tenantSid, sysId);
    }

    @Override
    public SysQueryResultVO getSysVOByIdAndTenantSid(String sysId, long tenantSid) {
        return this.sysMapper.findSysVOByTenantSidAndId(tenantSid, sysId);
    }

    @Override
    public SysInTenantVO getSysClientInfoByTenant(Long tenantSid, String appId) {
        return this.sysMapper.getSysClientInfoByTenant(tenantSid, appId);
    }

    @Override
    public SysInTenant getSysInTenantBySysIdAndTenantSid(Long tenantSid, String appId) {
        return this.sysInTenantMapper.getSysInTenantBySysIdAndTenantSid(tenantSid, appId);
    }

    @Override
    @Cacheable(cacheNames={"default"}, key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).REIDS_TENANT_APP_SECRET + #tenantSid+':'+#secret", cacheManager="dapCommonCacheManager", unless="#result==null")
    public SysInTenantVO getBySecret(Long tenantSid, String secret) {
        return this.sysInTenantMapper.getBySecret(tenantSid, secret);
    }

    @Override
    public List<SysInTenantTokenVO> getSysInTenantTokenInfo(Long tenantSid, Boolean includeAll) {
        List<SysInTenantTokenVO> sysInTenantTokenInfo = this.sysInTenantMapper.getSysInTenantTokenInfo(tenantSid, includeAll);
        if (CollectionUtils.isEmpty(sysInTenantTokenInfo)) {
            return Collections.emptyList();
        }
        sysInTenantTokenInfo.forEach(e -> {
            if (!Boolean.TRUE.equals(e.getTokenExpireAdjusted())) {
                e.setTokenExpireHours(e.getSysDefaultTokenExpireHours());
                e.setTokenExpire(e.getSysDefaultTokenExpire());
            }
        });
        List<String> sysIdList = sysInTenantTokenInfo.stream().map(SysInTenantTokenVO::getSysId).collect(Collectors.toList());
        List<GoodsLanguage> goodsLanguage = this.gmcService.getGoodsLanguage(sysIdList);
        Map<String, String> goodsMap = goodsLanguage.stream().collect(Collectors.toMap(GoodsLanguage::getGoodsCode, GoodsLanguage::getGoodsName, (k1, k2) -> k1));
        List sysSidList = sysInTenantTokenInfo.stream().map(SysInTenantTokenVO::getSysSid).collect(Collectors.toList());
        Map contentMapping = this.languageCrudService.findContent(sysSidList, "sysName");
        for (SysInTenantTokenVO sysInTenantTokenVO : sysInTenantTokenInfo) {
            String goodsName = goodsMap.get(sysInTenantTokenVO.getSysId());
            String sysName = (String)contentMapping.get(sysInTenantTokenVO.getSysSid());
            sysInTenantTokenVO.setSysDefaultTokenExpireHours((long)Math.ceil((double)sysInTenantTokenVO.getSysDefaultTokenExpire().longValue() / 60.0));
            sysInTenantTokenVO.setTokenExpireHours((long)Math.ceil((double)sysInTenantTokenVO.getTokenExpire().longValue() / 60.0));
            if (!StringUtils.hasText((String)goodsName) && !StringUtils.hasText((String)sysName)) continue;
            sysInTenantTokenVO.setSysName(StringUtils.hasText((String)goodsName) ? goodsName : sysName);
        }
        return sysInTenantTokenInfo;
    }
}

