/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.sys.impl;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.ActionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.ConditionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.ModuleQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.SysCascade;
import com.digiwin.dap.middleware.iam.domain.app.SysQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.authoritysummary.AuthoritySummaryVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopLanguage;
import com.digiwin.dap.middleware.iam.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.mapper.ActionMapper;
import com.digiwin.dap.middleware.iam.mapper.ConditionMapper;
import com.digiwin.dap.middleware.iam.mapper.ModuleMapper;
import com.digiwin.dap.middleware.iam.mapper.SysMapper;
import com.digiwin.dap.middleware.iam.service.permission.AuthActionService;
import com.digiwin.dap.middleware.iam.service.sys.SysQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import com.digiwin.dap.middleware.language.service.LanguageService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class SysQueryServiceImpl
implements SysQueryService {
    @Autowired
    private SysMapper sysMapper;
    @Autowired
    private ModuleMapper moduleMapper;
    @Autowired
    private ActionMapper actionMapper;
    @Autowired
    private ConditionMapper conditionMapper;
    @Autowired
    private CacService cacService;
    @Autowired
    private LanguageService languageService;
    @Autowired
    private LanguageCrudService languageCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private AuthActionService authActionService;

    @Override
    public SysCascade getSysCascade(long tenantSid, long sysSid, List<Long> actions) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        SysCascade sysCascade = this.getSysCascadeBySid(tenantSid, tenant.getId(), sysSid, null, tenant.isDealer(), tenant.isEoc());
        sysCascade.getModules().forEach(module -> module.getActions().removeIf(p -> !actions.contains(p.getSid())));
        sysCascade.getModules().removeIf(p -> p.getActions().isEmpty());
        sysCascade.setActions(null);
        return sysCascade;
    }

    @Override
    public SysCascade getSysCascadeBySid(long tenantSid, String tenantId, long sysSid, String sysId, boolean dealer, boolean eoc) {
        SysQueryResultVO app = this.sysMapper.findSysVOBySid(sysSid, sysId);
        if (app == null) {
            throw new BusinessException((ErrorHandler)I18nError.APP_NOT_EXISTED, new Object[]{StrUtils.isEmpty((String)sysId) ? Long.valueOf(sysSid) : sysId});
        }
        List<ModuleQueryResultVO> modules = this.moduleMapper.findModuleBySysSid(app.getSid());
        List<ActionQueryResultVO> actions = this.actionMapper.findActionBySys(tenantSid, app.getSid());
        List<ConditionQueryResultVO> conditions = this.conditionMapper.findConditionBySysSid(app.getSid(), true);
        this.authActionService.filterByAuth(tenantSid, app, modules, actions);
        String sysName = this.languageCrudService.findContent(app.getSid().longValue(), "sysName");
        app.setName(StrUtils.isEmpty((String)sysName) ? app.getName() : sysName);
        this.setModulesLanguage(modules);
        this.setActionsLanguage(actions);
        this.setConditionLanguage(conditions);
        Map<Long, List<ConditionQueryResultVO>> conditionMap = conditions.stream().collect(Collectors.groupingBy(ConditionQueryResultVO::getActionSid));
        actions.forEach(action -> {
            action.setCondition(conditionMap.getOrDefault(action.getSid(), new ArrayList()));
            action.setPaths(action.getPath() == null ? null : Arrays.asList(action.getPath().split(",")));
        });
        Map<String, List<ActionQueryResultVO>> actionMap = actions.stream().collect(Collectors.groupingBy(ActionQueryResultVO::getModuleId));
        modules.forEach(module -> module.setActions(actionMap.getOrDefault(module.getId(), new ArrayList())));
        modules.sort(Comparator.comparing(ModuleQueryResultVO::getCreateDate, Comparator.nullsFirst(LocalDateTime::compareTo)).thenComparing(ModuleQueryResultVO::getId));
        actions.sort(Comparator.comparing(ActionQueryResultVO::getCreateDate, Comparator.nullsFirst(LocalDateTime::compareTo)).thenComparing(ActionQueryResultVO::getId));
        return new SysCascade(app, modules, actions);
    }

    @Override
    public List<SysCascade> getPlatFormSysCascadeBySid(long tenantSid, String tenantId, long sysSid, String sysId, boolean dealer, boolean eoc) {
        SysQueryResultVO sysQueryResultVO = this.sysMapper.findSysVOBySid(sysSid, sysId);
        if (sysQueryResultVO == null) {
            throw new BusinessException((ErrorHandler)I18nError.APP_NOT_EXISTED, new Object[]{StringUtils.isEmpty((Object)sysId) ? Long.valueOf(sysSid) : sysId});
        }
        List<AuthoritySummaryVO> authoritySummaryChildren = this.gmcService.getAuthoritySummaryChildren(sysQueryResultVO.getId());
        List<AuthorizationResultVO> allAuthorization = this.cacService.queryAllAuthorization(tenantId);
        authoritySummaryChildren.removeIf(a -> allAuthorization.stream().noneMatch(cac -> a.getChildGoodsCode().equals(cac.getCode())));
        Locale threadLocale = LocaleContextHolder.getLocale();
        return authoritySummaryChildren.parallelStream().map(a -> {
            LocaleContextHolder.setLocale((Locale)threadLocale);
            return this.getSysCascadeBySid(tenantSid, tenantId, 0L, a.getChildGoodsCode(), dealer, eoc);
        }).collect(Collectors.toList());
    }

    @Override
    public List<SysCascade> getBundleSysCascadeBySid(long tenantSid, String tenantId, long sysSid, String sysId, boolean dealer, boolean eoc) {
        SysQueryResultVO currentSys = this.sysMapper.findSysVOBySid(sysSid, sysId);
        if (currentSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.APP_NOT_EXISTED, new Object[]{ObjectUtils.isEmpty((Object)sysId) ? Long.valueOf(sysSid) : sysId});
        }
        if (currentSys.isInside()) {
            return new ArrayList<SysCascade>();
        }
        List<AuthorizationResultVO> allAuthorization = this.cacService.queryAllAuthorization(tenantId);
        AuthorizationResultVO currentCac = allAuthorization.stream().filter(a -> a.getCode().equals(currentSys.getId())).findFirst().orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.APP_NOT_EXISTED, new Object[]{StringUtils.isEmpty((Object)sysId) ? Long.valueOf(sysSid) : sysId}));
        if (!GoodsCategoryEnum.BUNDLE.id().equals(currentCac.getCategoryId())) {
            return new ArrayList<SysCascade>();
        }
        String bundleCode = currentCac.getCode();
        List bundleChildren = allAuthorization.stream().filter(a -> bundleCode.equals(a.getBundleCode())).collect(Collectors.toList());
        Locale threadLocale = LocaleContextHolder.getLocale();
        return bundleChildren.parallelStream().map(a -> {
            LocaleContextHolder.setLocale((Locale)threadLocale);
            return this.getSysCascadeBySid(tenantSid, tenantId, 0L, a.getCode(), dealer, eoc);
        }).collect(Collectors.toList());
    }

    @Override
    public Sys findByTenantIdAndId(String tenantId, String sysId) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (tenant == null) {
            return null;
        }
        return this.sysMapper.findByTenantSidAndId(tenant.getSid(), sysId);
    }

    @Override
    public SysCascade getSysCascadeById(String sysId) {
        SysCascade sysCascade = new SysCascade();
        SysQueryResultVO sys = this.sysMapper.findSysVOBySid(0L, sysId);
        if (sys == null) {
            throw new BusinessException((ErrorHandler)I18nError.APP_NOT_EXISTED, new Object[]{sysId});
        }
        sysCascade.setApp(sys);
        List<ModuleQueryResultVO> modules = this.moduleMapper.findModuleBySysSid(sys.getSid());
        sysCascade.setModules(modules);
        List<ActionQueryResultVO> actions = this.actionMapper.findActionBySys(0L, sys.getSid());
        sysCascade.setActions(actions);
        Map<Long, List<ActionQueryResultVO>> actionMap = actions.stream().collect(Collectors.groupingBy(ActionQueryResultVO::getModuleSid));
        modules.forEach(module -> {
            if (actionMap.containsKey(module.getSid())) {
                module.getActions().addAll((Collection)actionMap.get(module.getSid()));
            }
        });
        return sysCascade;
    }

    private void setModulesLanguage(List<ModuleQueryResultVO> modules) {
        Map<String, String> map = Collections.singletonMap("name", "moduleName");
        List moduleSids = modules.stream().map(DevelopLanguage::getSid).collect(Collectors.toList());
        this.languageService.parse(modules, moduleSids, map, ModuleQueryResultVO.class);
    }

    private void setActionsLanguage(List<ActionQueryResultVO> actions) {
        List actionSids = actions.stream().map(ActionQueryResultVO::getSid).collect(Collectors.toList());
        this.languageService.parse(actions, actionSids, Collections.singletonMap("name", "actionName"), ActionQueryResultVO.class);
    }

    private void setConditionLanguage(List<ConditionQueryResultVO> conditions) {
        List conditionSids = conditions.stream().map(ConditionQueryResultVO::getSid).collect(Collectors.toList());
        Map contentMapping = this.languageCrudService.findContent(conditionSids, "conditionName");
        for (ConditionQueryResultVO condition : conditions) {
            condition.setTypeParameter((List)JsonUtils.jsonToObj((String)condition.getParameter(), List.class));
            String content = (String)contentMapping.get(condition.getSid());
            if (StringUtils.isEmpty((Object)content)) continue;
            condition.setName(content);
        }
    }
}

