/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.sys.impl;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.OperateException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.RamPolicyConstants;
import com.digiwin.dap.middleware.iam.constant.enums.UpdateTypeEnum;
import com.digiwin.dap.middleware.iam.domain.app.ActionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.ActionVO;
import com.digiwin.dap.middleware.iam.domain.app.ConditionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.ModuleVO;
import com.digiwin.dap.middleware.iam.domain.app.SysCascadeVO;
import com.digiwin.dap.middleware.iam.domain.app.SysVO;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.domain.request.MetaUriRequest;
import com.digiwin.dap.middleware.iam.domain.sys.SysProductCodeRequestVO;
import com.digiwin.dap.middleware.iam.domain.sys.SysProductCodeResultVO;
import com.digiwin.dap.middleware.iam.domain.sys.SysWithPlatformVO;
import com.digiwin.dap.middleware.iam.entity.Action;
import com.digiwin.dap.middleware.iam.entity.AppToken;
import com.digiwin.dap.middleware.iam.entity.Module;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysCategory;
import com.digiwin.dap.middleware.iam.entity.SysInTenant;
import com.digiwin.dap.middleware.iam.mapper.ActionMapper;
import com.digiwin.dap.middleware.iam.mapper.ConditionMapper;
import com.digiwin.dap.middleware.iam.mapper.ModuleMapper;
import com.digiwin.dap.middleware.iam.mapper.SysMapper;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ActionService;
import com.digiwin.dap.middleware.iam.service.app.ModuleCrudService;
import com.digiwin.dap.middleware.iam.service.app.ModuleService;
import com.digiwin.dap.middleware.iam.service.sys.AppTokenCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCategoryCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysService;
import com.digiwin.dap.middleware.iam.service.sys.impl.SysInTenantCrudServiceImpl;
import com.digiwin.dap.middleware.iam.support.auth.RamService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.remote.domain.MultiLanguageSysDetailVO;
import com.digiwin.dap.middleware.iam.support.validate.SysValidateService;
import com.digiwin.dap.middleware.language.entity.LanguageResource;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysServiceImpl
implements SysService {
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private ModuleCrudService moduleCrudService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private ActionCrudService actionCrudService;
    @Autowired
    private ActionService actionService;
    @Autowired
    private SysInTenantCrudServiceImpl sysInTenantCrudService;
    @Autowired
    private AppTokenCrudService appTokenCrudService;
    @Autowired
    private ActionMapper actionMapper;
    @Autowired
    private LanguageCrudService languageCrudService;
    @Autowired
    private ConditionMapper conditionMapper;
    @Autowired
    private RamService ramService;
    @Autowired
    private SysValidateService sysValidateService;
    @Autowired
    private ModuleMapper moduleMapper;
    @Autowired
    private SysMapper sysMapper;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private SysCategoryCrudService sysCategoryCrudService;
    @Autowired
    private WhiteListService whiteListService;

    @Override
    public long addSys(SysVO sysVO, boolean isCloud, long tenantSid) {
        AppToken appToken;
        this.sysValidateService.check8(sysVO);
        Sys sys = new Sys();
        sys.setId(sysVO.getId());
        BeanUtils.mergeDifferentTypeObject((Object)sysVO, (Object)((Object)sys));
        sys.setSyscategorySid(sysVO.getCategorySid());
        sys.setApp(true);
        long sysSid = this.sysCrudService.create((BaseEntity)sys);
        String token = sysVO.getAppToken();
        if (token == null) {
            token = DigestUtils.getAppToken((String)sysVO.getId(), (String)KeyConstant.OTHER);
        }
        if ((appToken = (AppToken)this.appTokenCrudService.findById(sysVO.getId())) == null) {
            appToken = new AppToken();
            appToken.setToken(token);
            appToken.setId(sysVO.getId());
            this.appTokenCrudService.create((BaseEntity)appToken);
        } else {
            appToken.setToken(token);
            this.appTokenCrudService.update((BaseEntity)appToken);
        }
        if (!isCloud) {
            SysInTenant sysInTenant = new SysInTenant();
            sysInTenant.setSysSid(sysSid);
            sysInTenant.setTenantSid(tenantSid);
            this.sysInTenantCrudService.create(sysInTenant);
        }
        return sysSid;
    }

    @Override
    @Transactional
    public void addSysCascade(SysCascadeVO sysCascadeVO, boolean isCloud, long tenantSid) {
        this.updateSysCategory(sysCascadeVO);
        this.addSysCascade(sysCascadeVO, new ArrayList<MultiLanguageSysDetailVO>(), isCloud, tenantSid);
    }

    @Override
    @Transactional
    public void addSysCascadeWithLanguage(SysCascadeVO sysCascadeVO, List<MultiLanguageSysDetailVO> sysLanguageResources, boolean isCloud, long tenantSid) {
        this.updateSysCategory(sysCascadeVO);
        this.addSysCascade(sysCascadeVO, sysLanguageResources, isCloud, tenantSid);
    }

    @Override
    public void deleteSysCascade(String sysId) {
        Sys sys = (Sys)this.sysCrudService.findById(sysId);
        if (sys != null) {
            this.conditionMapper.deleteConditionBySysSid(sys.getSid());
            this.actionMapper.deleteActionsBySysSid(sys.getSid());
            this.moduleMapper.deleteModuleBySysSid(sys.getSid());
            this.appTokenCrudService.deleteById(sys.getId());
            this.sysCrudService.deleteById(sys.getSid());
            this.changeLogService.createChangeLog(ChangeTypeEnum.SYS_DEL.getName(), (Object)sys, ChangeTypeEnum.SYS_DEL.getPrimaryKey(), sys.getId());
        }
    }

    @Override
    public void updateMetaUri(MetaUriRequest body) {
        Action action;
        Module module;
        Sys sys;
        Long targetSid = body.getSid();
        String sysId = body.getId();
        if ((null == body.getType() || UpdateTypeEnum.APP.getCode().equals(body.getType())) && (sys = StrUtils.isNotEmpty((Long)targetSid) ? (Sys)this.sysCrudService.findBySid(targetSid) : (Sys)this.sysCrudService.findById(sysId)) != null) {
            sys.setMetaUri(body.getMetaUri());
            sys.setEnableMultiRow(body.getEnableMultiRow());
            this.sysCrudService.update((BaseEntity)sys);
            return;
        }
        if ((null == body.getType() || UpdateTypeEnum.MODULE.getCode().equals(body.getType())) && (module = (Module)this.moduleCrudService.findBySid(targetSid)) != null) {
            module.setBackUri(body.getMetaUri());
            this.moduleCrudService.update(module);
            return;
        }
        if ((null == body.getType() || UpdateTypeEnum.ACTION.getCode().equals(body.getType())) && (action = (Action)this.actionCrudService.findBySid(targetSid)) != null) {
            action.setBackUri(body.getMetaUri());
            this.actionCrudService.update(action);
        }
    }

    private void updateSysCategory(SysCascadeVO sysCascadeVO) {
        SysVO sysVO = sysCascadeVO.getApp();
        if (sysVO == null) {
            throw new OperateException("\u7f3a\u5c11app\u53c2\u6570\uff0c\u4e0d\u80fd\u6dfb\u52a0");
        }
        long sysCategorySid = sysVO.getCategorySid();
        String sysCategoryId = sysVO.getCategoryId();
        if (sysCategorySid == 0L && sysCategoryId == null) {
            SysCategory oldSysCategory = (SysCategory)this.sysCategoryCrudService.findById(sysVO.getId());
            if (oldSysCategory == null) {
                SysCategory sysCategory = new SysCategory();
                sysCategory.setId(sysVO.getId());
                sysCategory.setName(sysVO.getName());
                sysCategorySid = this.sysCategoryCrudService.create((BaseEntity)sysCategory);
            } else {
                sysCategorySid = oldSysCategory.getSid();
            }
            sysVO.setCategorySid(sysCategorySid);
        }
        if (this.whiteListService.getWhiteList("IAM_APP_WHITE_LIST").contains(sysVO.getId().toLowerCase())) {
            sysVO.setInside(true);
            if ("servicecloud;digiwincloud;srobot;".contains(sysVO.getId().toLowerCase() + ";")) {
                sysVO.setHasPermission(true);
            }
        }
        if (sysCategoryId != null) {
            SysCategory sysCategory = (SysCategory)this.sysCategoryCrudService.findById(sysCategoryId);
            if (sysCategory != null) {
                sysCategorySid = sysCategory.getSid();
            } else {
                SysCategory newsysCategory = new SysCategory();
                newsysCategory.setId(sysCategoryId);
                newsysCategory.setName(sysVO.getName());
                sysCategorySid = this.sysCategoryCrudService.create((BaseEntity)newsysCategory);
            }
            sysVO.setCategorySid(sysCategorySid);
        }
    }

    private void addSysCascade(SysCascadeVO sysCascadeVO, List<MultiLanguageSysDetailVO> sysLanguageResources, boolean isCloud, long tenantSid) {
        if (sysCascadeVO == null || sysCascadeVO.getApp() == null) {
            throw new IllegalArgumentException("sysCascadeVO or app is null");
        }
        SysVO sysVO = sysCascadeVO.getApp();
        String token = sysCascadeVO.getAppToken();
        if (token != null) {
            sysVO.setAppToken(token);
        }
        ArrayList<LanguageResource> resources = new ArrayList<LanguageResource>();
        long sysSid = this.saveSys(sysVO, sysLanguageResources, isCloud, tenantSid, resources);
        List<ModuleVO> moduleVOS = sysCascadeVO.getModules();
        if (moduleVOS != null) {
            this.saveModules(sysVO, moduleVOS, sysLanguageResources, resources);
        }
        List<ActionQueryResultVO> oldActions = this.actionMapper.findActionBySys(0L, sysSid);
        List<ConditionQueryResultVO> oldConditions = this.conditionMapper.findConditionBySysSid(sysSid, false);
        List<ActionVO> actionVOS = sysCascadeVO.getActions();
        for (ActionVO actionVO : actionVOS) {
            actionVO.setAppSid(sysSid);
            long moduleSid = this.moduleCrudService.getSidByUnionKey(new Object[]{actionVO.getModuleId(), sysSid});
            if (moduleSid == 0L) {
                throw new BusinessException((ErrorHandler)I18nError.MODULE_NOT_EXIST, new Object[]{actionVO.getModuleId()});
            }
            actionVO.setModuleSid(moduleSid);
            actionVO.setAppId(sysVO.getId());
            List<LanguageResource> actionResources = this.actionService.batchAddActionWithLanguage(actionVO, sysLanguageResources, oldConditions);
            resources.addAll(actionResources);
        }
        if (oldActions.size() > 0) {
            for (ActionQueryResultVO oldAction : oldActions) {
                boolean deleted = true;
                for (ActionVO newAction : actionVOS) {
                    if (newAction.getModuleSid() != oldAction.getModuleSid().longValue() || !newAction.getId().trim().equals(oldAction.getId().trim())) continue;
                    deleted = false;
                    break;
                }
                if (!deleted) continue;
                this.actionService.deleteAction(oldAction);
            }
        }
        if (resources.size() > 0) {
            List sids = resources.stream().map(LanguageResource::getDataSid).distinct().collect(Collectors.toList());
            this.languageCrudService.deleteByDataSidsInBatch(sids);
            this.languageCrudService.saveAll(resources);
        }
    }

    private long saveSys(SysVO sysVO, List<MultiLanguageSysDetailVO> sysLanguageResources, boolean isCloud, long tenantSid, List<LanguageResource> resources) {
        Sys oldSys = (Sys)this.sysCrudService.findById(sysVO.getId());
        if (oldSys == null) {
            sysVO.setSid(this.addSys(sysVO, isCloud, tenantSid));
        } else {
            oldSys.setName(sysVO.getName());
            oldSys.setMultiLogin(sysVO.isMultiLogin());
            oldSys.setInside(sysVO.isInside());
            oldSys.setHasPermission(sysVO.isHasPermission());
            oldSys.setLinked(Optional.ofNullable(sysVO.getLinked()).orElse(oldSys.getLinked()));
            oldSys.setShowEntry(Optional.ofNullable(sysVO.getShowEntry()).orElse(oldSys.getShowEntry()));
            oldSys.setShowConsolePolicy(Optional.ofNullable(sysVO.getShowConsolePolicy()).orElse(oldSys.getShowConsolePolicy()));
            oldSys.setActionFilterUrl(Optional.ofNullable(sysVO.getActionFilterUrl()).orElse(oldSys.getActionFilterUrl()));
            this.sysCrudService.update((BaseEntity)oldSys);
            sysVO.setSid(oldSys.getSid());
        }
        sysLanguageResources.forEach(sysLanguageResource -> {
            if (sysLanguageResource.getSysCascadeVO() != null && sysLanguageResource.getSysCascadeVO().getApp() != null && sysLanguageResource.getSysCascadeVO().getApp().getId().equals(sysVO.getId())) {
                LanguageResource multiLanguageResource = new LanguageResource(sysVO.getSid(), "sysName", sysLanguageResource.getSysCascadeVO().getApp().getName(), sysLanguageResource.getLanguage());
                resources.add(multiLanguageResource);
            }
        });
        String policyKey = RamPolicyConstants.createRamKey(sysVO.getId(), new String[0]);
        this.ramService.createRouteWithPolicy(sysVO.getId(), policyKey, sysVO.getName(), sysVO.getApis());
        return sysVO.getSid();
    }

    private void saveModules(SysVO sysVO, List<ModuleVO> moduleVOS, List<MultiLanguageSysDetailVO> sysLanguageResources, List<LanguageResource> resources) {
        for (ModuleVO moduleVO : moduleVOS) {
            long moduleSid;
            moduleVO.setAppSid(sysVO.getSid());
            Module oldModule = (Module)this.moduleCrudService.findByUnionKey(new Object[]{moduleVO.getId(), sysVO.getSid()});
            if (oldModule == null) {
                moduleSid = this.moduleService.addModule(moduleVO);
            } else {
                moduleSid = oldModule.getSid();
                this.moduleService.modifyModule(moduleVO);
            }
            sysLanguageResources.forEach(sysLanguageResource -> {
                if (sysLanguageResource.getSysCascadeVO() == null || sysLanguageResource.getSysCascadeVO().getModules() == null) {
                    return;
                }
                sysLanguageResource.getSysCascadeVO().getModules().forEach(moduleVO1 -> {
                    if (moduleVO.getId().equals(moduleVO1.getId())) {
                        LanguageResource multiLanguageResource = new LanguageResource(moduleSid, "moduleName", moduleVO1.getName(), sysLanguageResource.getLanguage());
                        resources.add(multiLanguageResource);
                    }
                });
            });
            String policyKey = RamPolicyConstants.createRamKey(sysVO.getId(), moduleVO.getId());
            String policyName = RamPolicyConstants.createRamName(sysVO.getName(), moduleVO.getName());
            this.ramService.createRouteWithPolicy(sysVO.getId(), policyKey, policyName, sysVO.getApis());
        }
    }

    @Override
    public List<SysProductCodeResultVO> getSysProductCode(SysProductCodeRequestVO body) {
        ArrayList<SysProductCodeResultVO> result = new ArrayList<SysProductCodeResultVO>();
        for (Sys sys : this.sysCrudService.findByIdIn(body.getAppIds())) {
            SysProductCodeResultVO vo = new SysProductCodeResultVO();
            vo.setAppId(sys.getId());
            vo.setProductCode(sys.getProductCode());
            vo.setProductName(sys.getProductName());
            result.add(vo);
        }
        return result;
    }

    @Override
    public List<SysWithPlatformVO> getPlatformSys(SysWithPlatformVO body) {
        return this.sysMapper.findSysVOByPlatformId(body);
    }
}

