/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.tenant.impl;

import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.tenant.AutoEOCService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.eoc.AutoEOCVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.message.EmpUserBO;
import com.digiwin.dap.middleware.iam.support.remote.domain.message.EmpUserVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class AutoEOCServiceImpl
implements AutoEOCService {
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private UserCrudService userCrudService;

    @Override
    public boolean isConsole(Long tenantSid) {
        String autoEOC = this.tenantMetadataCrudService.getTenantMetadataValue((long)tenantSid, "basic", "eocEntrance");
        return autoEOC == null || "console".equals(autoEOC);
    }

    @Override
    public boolean isAutoEOC(Long tenantSid) {
        String autoEOC = this.tenantMetadataCrudService.getTenantMetadataValue((long)tenantSid, "basic", "autoEOC");
        return "enable".equals(autoEOC);
    }

    @Override
    public void autoEocInit(long tenantSid) {
        User user;
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null || Boolean.FALSE.equals(tenant.isEoc())) {
            return;
        }
        if (this.isConsole(tenantSid) && this.isAutoEOC(tenantSid) && (user = (User)this.userCrudService.findBySid(tenant.getOwnerUserSid())) != null) {
            this.remoteEocService.autoEocInit(new AutoEOCVO(tenant.getSid(), user));
        }
    }

    @Override
    public void userJoinTenant(String empId, User user, Long tenantSid, boolean userType, Boolean enableEmp) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null || Boolean.FALSE.equals(tenant.isEoc())) {
            return;
        }
        if (ObjectUtils.isEmpty((Object)empId)) {
            return;
        }
        boolean isConsole = this.isConsole(tenantSid);
        boolean isAutoEOC = this.isAutoEOC(tenantSid);
        if (isConsole && isAutoEOC && userType) {
            return;
        }
        if (isConsole) {
            EmpUserVO vo = new EmpUserVO(tenantSid, user, empId);
            vo.setAutoEOC(isAutoEOC);
            vo.setEnableEmp(enableEmp);
            this.remoteEocService.bindingUserConsole(vo);
        }
    }

    @Override
    public void userJoinTenant(EmpUserBO bo, String userToken) {
        if (!CollectionUtils.isEmpty(bo.getEmpUserVOList()) && Boolean.TRUE.equals(bo.getConsole())) {
            this.remoteEocService.bindingUserConsoleBatch(bo, userToken);
        }
    }
}

