/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.tenant.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.SysCascadeVO;
import com.digiwin.dap.middleware.iam.domain.app.SysQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.SysVO;
import com.digiwin.dap.middleware.iam.domain.authorization.DeletePurchaseGoods;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysInTenant;
import com.digiwin.dap.middleware.iam.entity.SysOnPlatform;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.repository.SysOnPlatformRepository;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.PurchaseApplicationService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.CacAuth;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.CustomAttributes;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.Goods;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.SellingStrategyVO;
import com.digiwin.dap.middleware.iam.util.SecretKeyUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class PurchaseApplicationServiceImpl
implements PurchaseApplicationService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseApplicationServiceImpl.class);
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private SysInTenantQueryService sysInTenantQueryService;
    @Autowired
    private SysInTenantCrudService sysInTenantCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private CacService cacService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private SysOnPlatformRepository sysOnPlatformRepository;
    @Autowired
    private CommonCacheService commonCacheService;

    @Override
    public void purchaseApplication(String tenantId, String userId, SysVO sysVO, boolean cascadePlatform) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        this.purchaseApplication(tenant, userId, sysVO, cascadePlatform);
    }

    @Override
    public void purchaseApplicationList(String tenantId, String userId, List<SysVO> sysVOS, Boolean cascadePlatform) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        sysVOS.forEach(sysVO -> this.purchaseApplication(tenant, userId, (SysVO)sysVO, (boolean)cascadePlatform));
    }

    @Override
    @Transactional
    public void deletePurchaseGoods(DeletePurchaseGoods goods) {
        long sysSid = this.sysCrudService.getSidById(goods.getGoodsCode());
        Tenant tenant = (Tenant)this.tenantCrudService.findById(goods.getTenantId());
        if (tenant != null) {
            this.cacService.deletePurchaseGoods(goods.getTenantId(), goods.getGoodsCode());
            this.sysInTenantCrudService.deleteByUnionKey(tenant.getSid(), sysSid);
            this.messageService.sendDeletePurchaseGoods(goods);
            this.changeLogService.saveDeletePurchaseGoodsChangeLogs(goods);
        }
    }

    @Override
    public Long purchaseApplication(Tenant tenant, String userId, SysVO sysVO, boolean cascadePlatform) {
        Sys sys;
        String sysId = null;
        if (StringUtils.isEmpty((Object)sysVO.getId())) {
            if (!StringUtils.isEmpty((Object)sysVO.getIdFirst())) {
                sysId = sysVO.getIdFirst();
                if (!StringUtils.isEmpty((Object)sysVO.getIdSecond())) {
                    sysId = sysId + "_" + sysVO.getIdSecond();
                }
            }
        } else {
            sysId = sysVO.getId();
        }
        if ((sys = this.commonCacheService.getSysById(sysId)) == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{sysId});
        }
        long sysSid = sys.getSid();
        SysInTenant existedApp = this.sysInTenantCrudService.findByUnionKey(tenant.getSid(), sysSid);
        if (existedApp != null) {
            if (cascadePlatform) {
                this.purchasePlatformApplication(tenant, sysId, userId);
            }
            if (!(!StringUtils.hasText((String)sysVO.getClientId()) || sysVO.getClientId().equals(existedApp.getClientId()) && Objects.equals(sysVO.getClientSecret(), existedApp.getClientSecret()))) {
                existedApp.setClientId(sysVO.getClientId());
                existedApp.setClientInstanceId(sysVO.getClientInstanceId());
                existedApp.setClientSecret(sysVO.getClientSecret());
                this.sysInTenantCrudService.update((BaseEntity)existedApp);
            }
            return sysSid;
        }
        SysInTenant sysInTenant = new SysInTenant();
        String secretKey = SecretKeyUtil.getSecretKey(tenant.getId(), sysId, userId);
        sysInTenant.setSecretKey(secretKey);
        sysInTenant.setSysSid(sysSid);
        sysInTenant.setTenantSid(tenant.getSid());
        sysInTenant.setClientInstanceId(sysVO.getClientInstanceId());
        sysInTenant.setClientId(sysVO.getClientId());
        sysInTenant.setClientSecret(sysVO.getClientSecret());
        sysInTenant.setTokenExpire(sys.getTokenExpire());
        this.sysInTenantCrudService.create((BaseEntity)sysInTenant);
        if (cascadePlatform) {
            this.purchasePlatformApplication(tenant, sysId, userId);
        }
        return sysSid;
    }

    private void purchasePlatformApplication(Tenant tenant, String sysId, String userId) {
        List<SysOnPlatform> sysOnPlatforms = this.sysOnPlatformRepository.getBySysId(sysId);
        if (!sysOnPlatforms.isEmpty()) {
            List<String> platformIds = sysOnPlatforms.stream().map(SysOnPlatform::getPlatformSysId).collect(Collectors.toList());
            List<Sys> platformSysList = this.sysCrudService.findByIdIn(platformIds);
            List<SysQueryResultVO> existedApps = this.sysInTenantQueryService.getSysVOByTenantSid(tenant.getSid());
            platformSysList.forEach(p -> {
                if (!existedApps.stream().anyMatch(a -> a.getId().equals(p.getId()))) {
                    SysInTenant sysInTenant = new SysInTenant();
                    String secretKey = SecretKeyUtil.getSecretKey(tenant.getId(), p.getId(), userId);
                    sysInTenant.setSecretKey(secretKey);
                    sysInTenant.setSysSid(p.getSid());
                    sysInTenant.setTenantSid(tenant.getSid());
                    sysInTenant.setTokenExpire(p.getTokenExpire());
                    this.sysInTenantCrudService.create((BaseEntity)sysInTenant);
                }
            });
        }
    }

    @Override
    public void purchaseAppWithAuthLanding(Long tenantSid, String tenantId, String tenantName, SysCascadeVO sysCascadeVO) {
        Tenant tenant = new Tenant(tenantSid, tenantId, tenantName);
        SysVO sysVO = sysCascadeVO.getApp();
        Long sysSid = this.purchaseApplication(tenant, "virtual", sysVO, false);
        CacAuth cacAuth = new CacAuth();
        cacAuth.setTenantId(tenant.getId());
        cacAuth.setTenantName(tenant.getName());
        cacAuth.setAuthUser(false);
        Goods goods = new Goods();
        goods.setId(sysSid);
        goods.setCode(sysVO.getId());
        goods.setItemId(sysVO.getId());
        goods.setDisplayName(sysVO.getName());
        goods.setDealer(false);
        goods.setVersion("1.0.0.0");
        goods.setPaymentType(3);
        goods.setOrderNumber(1);
        SellingStrategyVO sellingStrategyVO = new SellingStrategyVO();
        sellingStrategyVO.setId(sysSid);
        ArrayList<AuthorizationModuleVO> enabledModules = new ArrayList<AuthorizationModuleVO>();
        sysCascadeVO.getModules().forEach(m -> {
            AuthorizationModuleVO enabledModule = new AuthorizationModuleVO();
            enabledModule.setId(m.getId());
            enabledModule.setName(m.getName());
            enabledModules.add(enabledModule);
        });
        sellingStrategyVO.setEnabledModules(enabledModules);
        sellingStrategyVO.setCustomAttributes(new ArrayList<CustomAttributes>());
        goods.setSellingStrategy(sellingStrategyVO);
        cacAuth.getAuthorizations().add(goods);
        this.cacService.purchaseOrUpdateApp(cacAuth);
    }

    @Override
    public void purchaseAppForPreOrderInLanding(String appId, Tenant tenant, String authUserId) {
        try {
            Goods goods = this.gmcService.getGoodsInfoForTestEnv(appId);
            CacAuth cacAuth = new CacAuth();
            cacAuth.setTenantId(tenant.getId());
            cacAuth.setTenantName(tenant.getName());
            cacAuth.setUserId(authUserId);
            cacAuth.setAuthUser(true);
            goods.setOrderNumber(1);
            goods.setTotalUsage(5L);
            goods.setTotalCount(5L);
            goods.setCategory(3);
            goods.setEffectiveTime(LocalDateTime.now().withNano(0));
            goods.setExpiredTime(LocalDateTime.of(9999, 12, 31, 23, 59, 59));
            SellingStrategyVO goodsStrategy = goods.getFirstSellingStrategy();
            goods.setSellingStrategy(goodsStrategy);
            cacAuth.getAuthorizations().add(goods);
            this.cacService.purchaseApp(cacAuth);
        }
        catch (Exception ex) {
            log.error("\u63a7\u5236\u53f0\u4e0b\u5730:\u6ce8\u518c\u5e94\u7528{}\u6388\u6743\u5931\u8d25", (Object)appId, (Object)ex);
        }
    }
}

