/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.tenant.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.TenantConfirmEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.servicer.ApplyStatusEnum;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuditVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantInfoVO;
import com.digiwin.dap.middleware.iam.entity.Association;
import com.digiwin.dap.middleware.iam.entity.DevCertificationDO;
import com.digiwin.dap.middleware.iam.entity.InvoiceInfo;
import com.digiwin.dap.middleware.iam.entity.IsvRelationDev;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantCertification;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.repository.CertificationRepository;
import com.digiwin.dap.middleware.iam.repository.InvoiceInfoRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.service.authentication.impl.TenantCertificationCrudServiceImpl;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.IsvRelationDevCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantAuditService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.initialize.TenantInitializeService;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class TenantAuditServiceImpl
implements TenantAuditService {
    private static final Logger log = LoggerFactory.getLogger(TenantAuditServiceImpl.class);
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantInitializeService tenantInitializeService;
    @Autowired
    private InvoiceInfoRepository invoiceInfoRepository;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private TenantCertificationCrudServiceImpl tenantCertificationCrudService;
    @Autowired
    private CertificationRepository certificationRepository;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private UserInRoleCrudService userInRoleCrudService;
    @Autowired
    private TenantMetadataUpdateService tenantMetadataUpdateService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private IsvRelationDevCrudService isvRelationDevCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;

    @Override
    public void confirm(TenantAuditVO tenantAuditVO) {
        User user;
        Tenant existed = (Tenant)this.tenantCrudService.findBySid(tenantAuditVO.getSid());
        if (existed == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantAuditVO.getSid()});
        }
        if (TenantConfirmEnum.APPROVED.getValue().equals(existed.getConfirm())) {
            return;
        }
        if (!StringUtils.isEmpty((Object)tenantAuditVO.getCustomerId()) && !tenantAuditVO.isIsvFlag()) {
            if (!tenantAuditVO.getTestTenant().booleanValue() && this.tenantRepository.existsByCustomerId(tenantAuditVO.getCustomerId(), tenantAuditVO.getSid()) > 0L) {
                throw new BusinessException((ErrorHandler)I18nError.CUSTOMER_ID_ALREADY_EXISTED, new Object[]{tenantAuditVO.getCustomerId()});
            }
            existed.setCustomerId(tenantAuditVO.getCustomerId());
        }
        InvoiceInfo invoiceInfo = this.invoiceInfoRepository.getByTenantSid(existed.getSid());
        if (!StringUtils.isEmpty((Object)tenantAuditVO.getTaxCode())) {
            List<InvoiceInfo> invoiceInfos;
            if (invoiceInfo == null) {
                invoiceInfo = new InvoiceInfo();
            }
            if (!tenantAuditVO.getTaxCode().equals(invoiceInfo.getTaxCode()) && (invoiceInfos = this.invoiceInfoRepository.getByTaxCode(tenantAuditVO.getTaxCode())).size() > 0) {
                throw new BusinessException((ErrorHandler)I18nError.UNIFORM_CREDIT_NUMBER_EXISTED);
            }
            invoiceInfo.setTaxCode(tenantAuditVO.getTaxCode());
        }
        if (!StringUtils.isEmpty((Object)tenantAuditVO.getInvoiceTitle())) {
            if (invoiceInfo == null) {
                invoiceInfo = new InvoiceInfo();
            }
            invoiceInfo.setInvoiceTitle(tenantAuditVO.getInvoiceTitle());
        }
        existed.setConfirm(TenantConfirmEnum.APPROVED.getValue());
        existed.setTestTenant(tenantAuditVO.getTestTenant());
        existed.setExplain(tenantAuditVO.getExplain());
        Optional.ofNullable(tenantAuditVO.getTeamId()).filter(o -> !StringUtils.isEmpty((Object)o)).ifPresent(x -> existed.setTeamId(tenantAuditVO.getTeamId()));
        existed.setPreDeploy(tenantAuditVO.getPreDeploy());
        existed.setEoc(Optional.ofNullable(tenantAuditVO.getEoc()).orElse(false));
        existed.setTenantPurpose(tenantAuditVO.getTenantPurpose());
        this.tenantCrudService.update((BaseEntity)existed);
        if (Boolean.TRUE.equals(tenantAuditVO.getEoc())) {
            this.remoteEocService.initialize(new TenantInfoVO(existed.getSid(), existed.getId(), existed.getName()));
        }
        if ((user = (User)this.userCrudService.findBySid(existed.getOwnerUserSid())) == null) {
            throw new BusinessException((ErrorHandler)I18nError.AUTHENTICATION_NO_USER, new Object[]{existed.getId(), existed.getOwnerUserSid()});
        }
        user.setEnterprise(true);
        this.userCrudService.update((BaseEntity)user);
        if (existed.isIsv()) {
            this.tenantInitializeService.initServicerDefaultTenant(existed.getId(), existed.getSid(), user.getId(), user.getSid());
        } else {
            this.tenantInitializeService.initDefaultTenant(existed.getId(), existed.getSid(), user.getId(), user.getSid());
        }
        if (invoiceInfo != null) {
            this.invoiceInfoRepository.save((Object)invoiceInfo);
        }
        if (Locale.TRADITIONAL_CHINESE.getCountry().equals(this.envProperties.getCountry().toUpperCase())) {
            TenantCertification tenantCertification = this.tenantCertificationCrudService.findByTenantSid(tenantAuditVO.getSid());
            if (tenantCertification == null) {
                tenantCertification = new TenantCertification();
                tenantCertification.setTenantSid(tenantAuditVO.getSid());
                tenantCertification.setPassed(true);
                this.tenantCertificationCrudService.create((BaseEntity)tenantCertification);
            } else {
                tenantCertification.setPassed(true);
                this.tenantCertificationCrudService.update((BaseEntity)tenantCertification);
            }
        }
        this.saveDevCertification(tenantAuditVO, existed.getSid());
    }

    private void saveDevCertification(TenantAuditVO tenantAuditVO, long tenantSid) {
        DevCertificationDO devCertificationDO = this.certificationRepository.findByTenantSid(tenantSid);
        if (devCertificationDO == null) {
            devCertificationDO = new DevCertificationDO();
            devCertificationDO.setTenantSid(tenantSid);
            EntityUtils.setCreateFields((BaseEntity)devCertificationDO);
        } else {
            EntityUtils.setModifyFields((BaseEntity)devCertificationDO);
        }
        devCertificationDO.setSelfUploadImage(Optional.ofNullable(tenantAuditVO.getSelfUploadImage()).orElse(Boolean.TRUE));
        devCertificationDO.setPreTest(tenantAuditVO.getPreTest());
        this.certificationRepository.save((Object)devCertificationDO);
    }

    @Override
    public void disConfirm(TenantAuditVO tenantAuditVO) {
        if (StringUtils.isEmpty((Object)tenantAuditVO.getExplain())) {
            throw new IllegalArgumentException("explain is null");
        }
        Tenant existed = (Tenant)this.tenantCrudService.findBySid(tenantAuditVO.getSid());
        if (existed == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantAuditVO.getSid()});
        }
        if (TenantConfirmEnum.APPROVED.getValue().equals(existed.getConfirm())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_IS_CONFIRM, new Object[]{existed.getId()});
        }
        existed.setExplain(tenantAuditVO.getExplain());
        existed.setTestTenant(tenantAuditVO.getTestTenant());
        existed.setConfirm(-1);
        this.tenantCrudService.update((BaseEntity)existed);
    }

    @Override
    public void disConfirmIsv(TenantAuditVO tenantAuditVO) {
        Tenant existed = (Tenant)this.tenantCrudService.findBySid(tenantAuditVO.getSid());
        if (existed == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantAuditVO.getSid()});
        }
        existed.setIsvApplyStatus(ApplyStatusEnum.DENIED.getCode());
        this.tenantCrudService.update((BaseEntity)existed);
    }

    @Override
    @Transactional
    public void confirmIsv(TenantAuditVO tenantAuditVO) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantAuditVO.getSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantAuditVO.getSid()});
        }
        long tenantSid = tenant.getSid();
        tenant.setIsv(true);
        tenant.setIsvApplyStatus(ApplyStatusEnum.QUALIFIED.getCode());
        tenant.setCustomerId(tenantAuditVO.getCustomerId());
        tenant.setPotentialCustomerId(tenantAuditVO.getPotentialCustomerId());
        long oldOwnerUserSid = tenant.getOwnerUserSid();
        Long newOwnerSid = tenantAuditVO.getCreatorSid();
        if (newOwnerSid != null && newOwnerSid != oldOwnerUserSid) {
            this.changeAdmin(tenantSid, oldOwnerUserSid, newOwnerSid);
            tenant.setOwnerUserSid(newOwnerSid);
        }
        this.tenantCrudService.update((BaseEntity)tenant);
        this.updateCostMetaData(tenantAuditVO, tenantSid);
        this.createIsvDevRelation(tenantSid);
        this.tenantInitializeService.initIsvApp(tenantSid);
        this.messageService.sendIsvSuccessMail(tenant);
    }

    private void createIsvDevRelation(long tenantSid) {
        if (!this.isvRelationDevCrudService.existsByIsvTenantSidAndDevTenantSid(tenantSid, tenantSid)) {
            IsvRelationDev isvRelationDev = new IsvRelationDev();
            isvRelationDev.setIsvTenantSid(tenantSid);
            isvRelationDev.setDevTenantSid(tenantSid);
            this.isvRelationDevCrudService.create(isvRelationDev);
        }
    }

    private void updateCostMetaData(TenantAuditVO tenantAuditVO, long tenantSid) {
        if (StringUtils.hasLength((String)tenantAuditVO.getCostDeptId())) {
            this.tenantMetadataUpdateService.updateTenantMetadataValue(tenantSid, "resourceCost", "deptId", tenantAuditVO.getCostDeptId());
        }
        if (StringUtils.hasLength((String)tenantAuditVO.getCostDeptName())) {
            this.tenantMetadataUpdateService.updateTenantMetadataValue(tenantSid, "resourceCost", "deptName", tenantAuditVO.getCostDeptName());
        }
        if (StringUtils.hasLength((String)tenantAuditVO.getCostEmpId())) {
            this.tenantMetadataUpdateService.updateTenantMetadataValue(tenantSid, "resourceCost", "empId", tenantAuditVO.getCostEmpId());
        }
        if (StringUtils.hasLength((String)tenantAuditVO.getCostEmpName())) {
            this.tenantMetadataUpdateService.updateTenantMetadataValue(tenantSid, "resourceCost", "empName", tenantAuditVO.getCostEmpName());
        }
    }

    private void changeAdmin(long tenantSid, long oldOwnerUserSid, Long newOwnerSid) {
        Association association;
        long adminRoleSid;
        Association oldAdmin;
        UserInTenant userInTenantTemp = this.userInTenantCrudService.findByUnionKey(tenantSid, newOwnerSid);
        if (userInTenantTemp == null) {
            UserInTenant userInTenant = new UserInTenant();
            userInTenant.setTenantSid(tenantSid);
            userInTenant.setUserSid(newOwnerSid);
            this.userInTenantCrudService.create(userInTenant);
        }
        if ((oldAdmin = this.userInRoleCrudService.findByUnionKey(tenantSid, oldOwnerUserSid, adminRoleSid = this.roleCrudService.getSidByTenantAndId(tenantSid, "superadmin"))) != null) {
            this.userInRoleCrudService.deleteById(oldAdmin.getSid());
        }
        if ((association = this.userInRoleCrudService.findByUnionKey(tenantSid, newOwnerSid, adminRoleSid)) == null) {
            association = new Association();
            association.setTenantSid(tenantSid);
            association.setRoleSid(adminRoleSid);
            association.setUserSid(newOwnerSid);
            association.setStatus(Boolean.TRUE);
            this.userInRoleCrudService.create((BaseEntity)association);
        }
    }
}

